/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.erp.entity.ErpEntrepotEntity;
import com.bringspring.erp.entity.ErpMaterialEntity;
import com.bringspring.erp.entity.ErpWarehouseEntity;
import com.bringspring.erp.mapper.ErpWarehouseMapper;
import com.bringspring.erp.model.erpWarehouse.ErpWarehouseCrForm;
import com.bringspring.erp.model.erpWarehouse.ErpWarehouseDetailListVO;
import com.bringspring.erp.model.erpWarehouse.ErpWarehouseInfoVO;
import com.bringspring.erp.model.erpWarehouse.ErpWarehouseListVO;
import com.bringspring.erp.model.erpWarehouse.ErpWarehousePagination;
import com.bringspring.erp.model.erpWarehouse.ErpWarehouseUpForm;
import com.bringspring.erp.model.erpoutbound.ErpOutboundCrForm;
import com.bringspring.erp.service.ErpEntrepotService;
import com.bringspring.erp.service.ErpMaterialService;
import com.bringspring.erp.service.ErpWarehouseService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5e93\u5b58\u603b\u8868"}, value="erp")
@RequestMapping(value={"/api/erp/ErpWarehouse"})
public class ErpWarehouseController {
    private static final Logger log = LoggerFactory.getLogger(ErpWarehouseController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private ErpWarehouseService erpWarehouseService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ErpMaterialService erpMaterialService;
    @Autowired
    private ErpEntrepotService erpEntrepotService;
    @Autowired
    private ErpWarehouseMapper erpWarehouseMapper;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody ErpWarehousePagination erpWarehousePagination) throws IOException {
        List<ErpWarehouseEntity> list = this.erpWarehouseService.getList(erpWarehousePagination);
        List listVO = JsonUtil.getJsonToList(list, ErpWarehouseListVO.class);
        for (ErpWarehouseListVO erpWarehouseVO : listVO) {
            ErpMaterialEntity codeInfo;
            ErpEntrepotEntity info;
            if (!StrUtil.isBlank((CharSequence)erpWarehouseVO.getWarehouseId()) && ObjectUtil.isNotEmpty((Object)(info = this.erpEntrepotService.getCode(erpWarehouseVO.getWarehouseId())))) {
                erpWarehouseVO.setWarehouseId(info.getEntrepotName());
            }
            if (StrUtil.isBlank((CharSequence)erpWarehouseVO.getMaterialCode()) || !ObjectUtil.isNotEmpty((Object)(codeInfo = this.erpMaterialService.getCodeInfo(erpWarehouseVO.getMaterialCode())))) continue;
            erpWarehouseVO.setMaterialCode(codeInfo.getFullName());
            erpWarehouseVO.setMaterialId(codeInfo.getId());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)erpWarehousePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListAllInfo"})
    public ActionResult list(@RequestBody ErpWarehouseDetailListVO erpWarehousePagination) throws IOException {
        List listAllInfo = this.erpWarehouseService.getListAllInfo(erpWarehousePagination);
        PageListVO vo = new PageListVO();
        vo.setList(listAllInfo);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)erpWarehousePagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid ErpWarehouseCrForm erpWarehouseCrForm) throws DataException {
        String mainId = RandomUtil.uuId();
        UserInfo userInfo = this.userProvider.get();
        ErpWarehouseEntity entity = (ErpWarehouseEntity)JsonUtil.getJsonToBean((Object)erpWarehouseCrForm, ErpWarehouseEntity.class);
        entity.setId(mainId);
        entity.setVersion(1);
        this.erpWarehouseService.save(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<ErpWarehouseInfoVO> info(@PathVariable(value="id") String id) {
        ErpEntrepotEntity info;
        ErpWarehouseEntity entity = this.erpWarehouseService.getInfo(id);
        ErpWarehouseInfoVO vo = (ErpWarehouseInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpWarehouseInfoVO.class);
        if (!StrUtil.isBlank((CharSequence)vo.getWarehouseId()) && ObjectUtil.isNotEmpty((Object)(info = this.erpEntrepotService.getCode(vo.getWarehouseId())))) {
            vo.setWarehouseName(info.getEntrepotName());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<ErpWarehouseInfoVO> detailInfo(@PathVariable(value="id") String id) {
        ErpMaterialEntity codeInfo;
        ErpEntrepotEntity info;
        ErpWarehouseEntity entity = this.erpWarehouseService.getInfo(id);
        ErpWarehouseInfoVO vo = (ErpWarehouseInfoVO)JsonUtil.getJsonToBean((Object)entity, ErpWarehouseInfoVO.class);
        if (!StrUtil.isBlank((CharSequence)vo.getWarehouseId()) && ObjectUtil.isNotEmpty((Object)(info = this.erpEntrepotService.getCode(vo.getWarehouseId())))) {
            vo.setWarehouseId(info.getEntrepotName());
        }
        if (!StrUtil.isBlank((CharSequence)vo.getMaterialCode()) && ObjectUtil.isNotEmpty((Object)(codeInfo = this.erpMaterialService.getCodeInfo(vo.getMaterialCode())))) {
            vo.setMaterialCode(codeInfo.getFullName());
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    @Transactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid ErpWarehouseUpForm erpWarehouseUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        ErpWarehouseEntity entity = (ErpWarehouseEntity)this.erpWarehouseMapper.selectById((Serializable)((Object)id));
        if (entity != null) {
            ErpWarehouseEntity subentity = (ErpWarehouseEntity)JsonUtil.getJsonToBean((Object)erpWarehouseUpForm, ErpWarehouseEntity.class);
            entity.setAmount(subentity.getAmount());
            entity.setPrice(subentity.getPrice());
            entity.setId(id);
            this.erpWarehouseMapper.updateById(entity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        ErpWarehouseEntity entity = this.erpWarehouseService.getInfo(id);
        if (entity != null) {
            this.erpWarehouseService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @PutMapping(value={"/allocation/{id}"})
    @DSTransactional
    public ActionResult allocation(@PathVariable(value="id") String id, @RequestBody @Valid ErpOutboundCrForm erpOutboundCrForm) throws DataException {
        Boolean flag = this.erpWarehouseService.warehouseAllocation(id, erpOutboundCrForm);
        if (flag.booleanValue()) {
            return ActionResult.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
        }
        return ActionResult.success((String)"fail");
    }
}

