/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.DateUtil;
import com.bringspring.contract.entity.RkPurchaseApplyListEntity;
import com.bringspring.contract.service.RkPurchaseApplyListService;
import com.bringspring.erp.entity.ErpConsumingApplyEntity;
import com.bringspring.erp.entity.ErpConsumingDetailEntity;
import com.bringspring.erp.mapper.ErpConsumingDetailMapper;
import com.bringspring.erp.model.erpConsumingApply.ErpConsumingApplyPagination;
import com.bringspring.erp.service.ErpConsumingApplyService;
import com.bringspring.erp.service.ErpConsumingDetailService;
import com.bringspring.workflow.engine.enums.FlowTaskStatusEnum;
import com.github.pagehelper.util.StringUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpConsumingDetailServiceImpl
extends ServiceImpl<ErpConsumingDetailMapper, ErpConsumingDetailEntity>
implements ErpConsumingDetailService {
    @Autowired
    private ErpConsumingApplyService erpConsumingApplyService;
    @Autowired
    private RkPurchaseApplyListService rkPurchaseApplyListService;

    @Override
    public List<ErpConsumingDetailEntity> getListByApplyId(String applyId) {
        QueryWrapper queryWrapperErpConsumingDetail = new QueryWrapper();
        queryWrapperErpConsumingDetail.lambda().eq(ErpConsumingDetailEntity::getApplyId, (Object)applyId);
        return this.list((Wrapper)queryWrapperErpConsumingDetail);
    }

    @Override
    public List<ErpConsumingDetailEntity> deleteListByApplyId(String applyId) {
        QueryWrapper queryWrapperErpConsumingDetail = new QueryWrapper();
        queryWrapperErpConsumingDetail.lambda().eq(ErpConsumingDetailEntity::getApplyId, (Object)applyId);
        this.remove((Wrapper)queryWrapperErpConsumingDetail);
        return this.list((Wrapper)queryWrapperErpConsumingDetail);
    }

    @Override
    public List<ErpConsumingDetailEntity> getListByMaterialCode(String materialCode) {
        QueryWrapper queryWrapperErpConsumingDetail = new QueryWrapper();
        queryWrapperErpConsumingDetail.lambda().eq(ErpConsumingDetailEntity::getMaterialCode, (Object)materialCode);
        return this.list((Wrapper)queryWrapperErpConsumingDetail);
    }

    @Override
    public List<ErpConsumingDetailEntity> getDetailList(ErpConsumingApplyPagination erpConsumingApplyPagination) {
        QueryWrapper queryWrapperErpConsumingDetail = new QueryWrapper();
        QueryWrapper queryWrapper = new QueryWrapper();
        int applyNum = 0;
        if (ObjectUtil.isNotEmpty((Object)((Object)erpConsumingApplyPagination))) {
            if (StrUtil.isNotEmpty((CharSequence)erpConsumingApplyPagination.getMaterialCode())) {
                queryWrapperErpConsumingDetail.lambda().eq(ErpConsumingDetailEntity::getMaterialCode, (Object)erpConsumingApplyPagination.getMaterialCode());
            }
            if (StringUtil.isNotEmpty((String)erpConsumingApplyPagination.getContractId())) {
                ++applyNum;
                queryWrapper.lambda().like(ErpConsumingApplyEntity::getContractId, (Object)erpConsumingApplyPagination.getContractId());
            }
            if (StringUtil.isNotEmpty((String)erpConsumingApplyPagination.getApplyPerson())) {
                ++applyNum;
                queryWrapper.lambda().eq(ErpConsumingApplyEntity::getApplyPerson, (Object)erpConsumingApplyPagination.getApplyPerson());
            }
            if (ObjectUtil.isNotEmpty(erpConsumingApplyPagination.getApplyDate())) {
                ++applyNum;
                List<String> ApplyDateList = erpConsumingApplyPagination.getApplyDate();
                Long fir = Long.valueOf(ApplyDateList.get(0));
                Long sec = Long.valueOf(ApplyDateList.get(1));
                ((LambdaQueryWrapper)queryWrapper.lambda().ge(ErpConsumingApplyEntity::getApplyDate, (Object)new Date(fir))).le(ErpConsumingApplyEntity::getApplyDate, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
            }
            if (StrUtil.isNotEmpty((CharSequence)erpConsumingApplyPagination.getNotOut())) {
                queryWrapperErpConsumingDetail.lambda().gt(ErpConsumingDetailEntity::getNotOut, (Object)erpConsumingApplyPagination.getNotOut());
            }
            if (StrUtil.isNotEmpty((CharSequence)erpConsumingApplyPagination.getSearchType()) && StrUtil.equals((CharSequence)erpConsumingApplyPagination.getSearchType(), (CharSequence)"purchaseApply")) {
                queryWrapperErpConsumingDetail.lambda().gt(ErpConsumingDetailEntity::getNotOut, (Object)0);
                QueryWrapper purchaseQ = new QueryWrapper();
                purchaseQ.lambda().eq(RkPurchaseApplyListEntity::getMainFlowStatus, (Object)FlowTaskStatusEnum.Draft.getCode());
                purchaseQ.lambda().isNotNull(RkPurchaseApplyListEntity::getConsumingDetailId);
                List purchaseL = this.rkPurchaseApplyListService.list((Wrapper)purchaseQ);
                if (CollectionUtil.isNotEmpty((Collection)purchaseL)) {
                    List purchaseIds = purchaseL.stream().map(RkPurchaseApplyListEntity::getConsumingDetailId).collect(Collectors.toList());
                    queryWrapperErpConsumingDetail.lambda().notIn(ErpConsumingDetailEntity::getId, purchaseIds);
                }
            }
            if (StrUtil.isNotEmpty((CharSequence)erpConsumingApplyPagination.getProjectId())) {
                ++applyNum;
                queryWrapper.lambda().eq(ErpConsumingApplyEntity::getProjectId, (Object)erpConsumingApplyPagination.getProjectId());
            }
            if (StrUtil.isNotEmpty((CharSequence)erpConsumingApplyPagination.getEnabledMark())) {
                ++applyNum;
                queryWrapper.lambda().eq(ErpConsumingApplyEntity::getEnabledMark, (Object)erpConsumingApplyPagination.getEnabledMark());
            }
            if (applyNum > 0) {
                List list = this.erpConsumingApplyService.list((Wrapper)queryWrapper);
                if (CollectionUtil.isNotEmpty((Collection)list)) {
                    List ids = list.stream().map(ErpConsumingApplyEntity::getId).collect(Collectors.toList());
                    queryWrapperErpConsumingDetail.lambda().in(ErpConsumingDetailEntity::getApplyId, ids);
                } else {
                    queryWrapperErpConsumingDetail.lambda().eq(ErpConsumingDetailEntity::getId, (Object)"0");
                }
            }
        }
        Page page = new Page(erpConsumingApplyPagination.getCurrentPage(), erpConsumingApplyPagination.getPageSize());
        IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapperErpConsumingDetail);
        return erpConsumingApplyPagination.setData(userIPage.getRecords(), userIPage.getTotal());
    }
}

