/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.erp.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.util.UserProvider;
import com.bringspring.erp.entity.ErpStorageRecordsEntity;
import com.bringspring.erp.mapper.ErpStorageRecordsMapper;
import com.bringspring.erp.model.erpStorageRecords.ErpStorageRecordsPagination;
import com.bringspring.erp.service.ErpStorageRecordsService;
import com.bringspring.erp.service.ErpWarehouseService;
import com.bringspring.system.permission.service.AuthorizeService;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ErpStorageRecordsServiceImpl
extends ServiceImpl<ErpStorageRecordsMapper, ErpStorageRecordsEntity>
implements ErpStorageRecordsService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private ErpWarehouseService erpWarehouseService;

    @Override
    public List<ErpStorageRecordsEntity> getList(ErpStorageRecordsPagination erpStorageRecordsPagination) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int erpStorageRecordsNum = 0;
        QueryWrapper erpStorageRecordsQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)erpStorageRecordsPagination.getCompanyId())) {
            ++erpStorageRecordsNum;
            erpStorageRecordsQueryWrapper.lambda().like(ErpStorageRecordsEntity::getCompanyId, (Object)erpStorageRecordsPagination.getCompanyId());
        }
        if (StringUtil.isNotEmpty((String)erpStorageRecordsPagination.getWarehouseId())) {
            ++erpStorageRecordsNum;
            erpStorageRecordsQueryWrapper.lambda().like(ErpStorageRecordsEntity::getWarehouseId, (Object)erpStorageRecordsPagination.getWarehouseId());
        }
        if (StringUtil.isNotEmpty((String)erpStorageRecordsPagination.getMaterialCode())) {
            ++erpStorageRecordsNum;
            erpStorageRecordsQueryWrapper.lambda().like(ErpStorageRecordsEntity::getMaterialCode, (Object)erpStorageRecordsPagination.getMaterialCode());
        }
        if (ObjectUtil.isNotEmpty(erpStorageRecordsPagination.getTypeName())) {
            ++erpStorageRecordsNum;
            erpStorageRecordsQueryWrapper.lambda().in(ErpStorageRecordsEntity::getType, erpStorageRecordsPagination.getTypeName());
        }
        if (StringUtil.isNotEmpty((String)erpStorageRecordsPagination.getKeyword())) {
            ++erpStorageRecordsNum;
            erpStorageRecordsQueryWrapper.lambda().and(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.like(ErpStorageRecordsEntity::getApplyCode, (Object)erpStorageRecordsPagination.getKeyword())).or()).like(ErpStorageRecordsEntity::getBatch, (Object)erpStorageRecordsPagination.getKeyword())).or()).like(ErpStorageRecordsEntity::getDescription, (Object)erpStorageRecordsPagination.getKeyword());
            });
        }
        if (AllIdList.size() > 0) {
            erpStorageRecordsQueryWrapper.lambda().in(ErpStorageRecordsEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)erpStorageRecordsPagination.getSidx())) {
            erpStorageRecordsQueryWrapper.lambda().orderByDesc(ErpStorageRecordsEntity::getId);
        } else {
            try {
                String sidx = erpStorageRecordsPagination.getSidx();
                ErpStorageRecordsEntity erpStorageRecordsEntity = ErpStorageRecordsEntity.builder().build();
                Field declaredField = erpStorageRecordsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                erpStorageRecordsQueryWrapper = "asc".equals(erpStorageRecordsPagination.getSort().toLowerCase()) ? (QueryWrapper)erpStorageRecordsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)erpStorageRecordsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(erpStorageRecordsPagination.getCurrentPage(), erpStorageRecordsPagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)erpStorageRecordsQueryWrapper);
            return erpStorageRecordsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return erpStorageRecordsPagination.setData(list, list.size());
    }

    @Override
    public List<ErpStorageRecordsEntity> getTypeList(ErpStorageRecordsPagination erpStorageRecordsPagination, String dataType) {
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int erpStorageRecordsNum = 0;
        QueryWrapper erpStorageRecordsQueryWrapper = new QueryWrapper();
        if (StringUtil.isNotEmpty((String)erpStorageRecordsPagination.getCompanyId())) {
            ++erpStorageRecordsNum;
            erpStorageRecordsQueryWrapper.lambda().like(ErpStorageRecordsEntity::getCompanyId, (Object)erpStorageRecordsPagination.getCompanyId());
        }
        if (StringUtil.isNotEmpty((String)erpStorageRecordsPagination.getWarehouseId())) {
            ++erpStorageRecordsNum;
            erpStorageRecordsQueryWrapper.lambda().like(ErpStorageRecordsEntity::getWarehouseId, (Object)erpStorageRecordsPagination.getWarehouseId());
        }
        if (StringUtil.isNotEmpty((String)erpStorageRecordsPagination.getMaterialCode())) {
            ++erpStorageRecordsNum;
            erpStorageRecordsQueryWrapper.lambda().like(ErpStorageRecordsEntity::getMaterialCode, (Object)erpStorageRecordsPagination.getMaterialCode());
        }
        if (ObjectUtil.isNotEmpty(erpStorageRecordsPagination.getTypeName())) {
            ++erpStorageRecordsNum;
            erpStorageRecordsQueryWrapper.lambda().in(ErpStorageRecordsEntity::getType, erpStorageRecordsPagination.getTypeName());
        }
        if (StringUtil.isNotEmpty((String)erpStorageRecordsPagination.getKeyword())) {
            ++erpStorageRecordsNum;
            erpStorageRecordsQueryWrapper.lambda().and(a -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)a.like(ErpStorageRecordsEntity::getApplyCode, (Object)erpStorageRecordsPagination.getKeyword())).or()).like(ErpStorageRecordsEntity::getBatch, (Object)erpStorageRecordsPagination.getKeyword())).or()).like(ErpStorageRecordsEntity::getDescription, (Object)erpStorageRecordsPagination.getKeyword());
            });
        }
        if (AllIdList.size() > 0) {
            erpStorageRecordsQueryWrapper.lambda().in(ErpStorageRecordsEntity::getId, AllIdList);
        }
        if (StringUtil.isEmpty((String)erpStorageRecordsPagination.getSidx())) {
            erpStorageRecordsQueryWrapper.lambda().orderByDesc(ErpStorageRecordsEntity::getId);
        } else {
            try {
                String sidx = erpStorageRecordsPagination.getSidx();
                ErpStorageRecordsEntity erpStorageRecordsEntity = ErpStorageRecordsEntity.builder().build();
                Field declaredField = erpStorageRecordsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                erpStorageRecordsQueryWrapper = "asc".equals(erpStorageRecordsPagination.getSort().toLowerCase()) ? (QueryWrapper)erpStorageRecordsQueryWrapper.orderByAsc((Object)value) : (QueryWrapper)erpStorageRecordsQueryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(erpStorageRecordsPagination.getCurrentPage(), erpStorageRecordsPagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)erpStorageRecordsQueryWrapper);
                return erpStorageRecordsPagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return erpStorageRecordsPagination.setData(list, list.size());
        }
        return this.list((Wrapper)erpStorageRecordsQueryWrapper);
    }

    @Override
    public ErpStorageRecordsEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ErpStorageRecordsEntity::getId, (Object)id);
        return (ErpStorageRecordsEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public void create(ErpStorageRecordsEntity entity) {
        this.save(entity);
    }

    @Override
    public boolean update(String id, ErpStorageRecordsEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    public ErpStorageRecordsEntity saveBytype(ErpStorageRecordsEntity entity, String type) {
        if (ObjectUtil.isNotEmpty((Object)entity)) {
            entity.setType(type);
            Boolean flag = this.erpWarehouseService.computePriceAtAddStorage(entity);
            if (flag.booleanValue()) {
                this.save(entity);
            }
        }
        return entity;
    }

    @Override
    public void delete(ErpStorageRecordsEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }
}

