/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.base.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.common.model.visiual.FormCloumnUtil;
import com.bringspring.common.model.visiual.RecursionForm;
import com.bringspring.common.model.visiual.TableModel;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.RedisUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.base.exception.WorkFlowException;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visualdev.base.entity.VisualdevEntity;
import com.bringspring.visualdev.base.mapper.VisualdevMapper;
import com.bringspring.visualdev.base.model.PaginationVisualdev;
import com.bringspring.visualdev.base.model.VisualDevCrForm;
import com.bringspring.visualdev.base.model.VisualDevUpForm;
import com.bringspring.visualdev.base.model.VisualWebTypeEnum;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.workflow.engine.entity.FlowEngineEntity;
import com.bringspring.workflow.engine.entity.FlowEngineTemplateEntity;
import com.bringspring.workflow.engine.entity.FlowEngineVisibleEntity;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.ChildNode;
import com.bringspring.workflow.engine.model.flowengine.shuntjson.childnode.Properties;
import com.bringspring.workflow.engine.service.FlowEngineService;
import com.bringspring.workflow.engine.service.FlowEngineTemplateService;
import com.bringspring.workflow.engine.service.FlowEngineVisibleService;
import com.bringspring.workflow.engine.util.VisualDevTableCre;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VisualdevServiceImpl
extends ServiceImpl<VisualdevMapper, VisualdevEntity>
implements VisualdevService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private FlowEngineService flowEngineService;
    @Autowired
    private UserService userService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private VisualDevTableCre visualDevTableCre;
    @Autowired
    private FlowEngineTemplateService flowEngineTemplateService;
    @Autowired
    private FlowEngineVisibleService flowEngineVisibleService;

    @Override
    public List<VisualdevEntity> getList(PaginationVisualdev paginationVisualdev) {
        boolean flag = false;
        QueryWrapper queryWrapper = new QueryWrapper();
        if (!StringUtils.isEmpty((String)paginationVisualdev.getKeyword())) {
            flag = true;
            queryWrapper.lambda().like(VisualdevEntity::getFullName, (Object)paginationVisualdev.getKeyword());
        }
        queryWrapper.lambda().eq(VisualdevEntity::getType, (Object)paginationVisualdev.getType());
        if (StringUtils.isNotEmpty((String)paginationVisualdev.getCategory())) {
            flag = true;
            queryWrapper.lambda().eq(VisualdevEntity::getCategory, (Object)paginationVisualdev.getCategory());
        }
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(VisualdevEntity::getSortCode)).orderByDesc(VisualdevEntity::getCreatorTime);
        if (flag) {
            queryWrapper.lambda().orderByDesc(VisualdevEntity::getLastModifyTime);
        }
        Page page = new Page(paginationVisualdev.getCurrentPage(), paginationVisualdev.getPageSize());
        IPage userPage = this.page((IPage)page, (Wrapper)queryWrapper);
        return paginationVisualdev.setData(userPage.getRecords(), page.getTotal());
    }

    @Override
    public List<VisualdevEntity> getList() {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().orderByAsc(VisualdevEntity::getSortCode)).orderByDesc(VisualdevEntity::getCreatorTime);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public VisualdevEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(VisualdevEntity::getId, (Object)id);
        return (VisualdevEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    public Boolean create(VisualdevEntity entity) throws WorkFlowException {
        if (StringUtils.isEmpty((String)entity.getId())) {
            entity.setId(RandomUtil.uuId());
        }
        List tableModels = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        Map formMap = JsonUtil.stringToMap((String)entity.getFormData());
        if (tableModels.size() == 0) {
            List list = JsonUtil.getJsonToList(formMap.get("fields"), FieLdsModel.class);
            JSONArray formJsonArray = JsonUtil.getJsonToJsonArray((String)String.valueOf(formMap.get("fields")));
            ArrayList formAllModel = new ArrayList();
            RecursionForm recursionForm = new RecursionForm();
            recursionForm.setTableModelList(JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class));
            recursionForm.setList(list);
            FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
            String tableName = "mt" + RandomUtil.uuId();
            String dbLinkId = entity.getDbLinkId();
            List tableModelList = this.visualDevTableCre.tableList(formJsonArray, formAllModel, tableName, dbLinkId);
            formMap.put("fields", formJsonArray);
            entity.setFormData(JsonUtil.getObjectToString((Object)formMap));
            entity.setVisualTables(JsonUtil.getObjectToString((Object)tableModelList));
        }
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        entity.setSortCode(RandomUtil.parses());
        if (ObjectUtil.isNotEmpty((Object)entity.getWebType()) && VisualWebTypeEnum.FLOW_FROM.getType().equals(entity.getWebType())) {
            entity.setFlowId(entity.getId());
            if (entity.getType().equals(1) || entity.getType().equals(2)) {
                FlowEngineEntity flowEngineEntity = new FlowEngineEntity();
                flowEngineEntity.setId(entity.getId());
                flowEngineEntity.setEnCode("visualDev" + entity.getEnCode());
                flowEngineEntity.setType(Integer.valueOf(1));
                flowEngineEntity.setIcon("icon-ym icon-ym-node");
                flowEngineEntity.setIconBackground("#008cff");
                flowEngineEntity.setEnabledMark(Integer.valueOf(1));
                flowEngineEntity.setFullName(entity.getFullName());
                flowEngineEntity.setCategory(this.dictionaryDataService.getInfo(entity.getCategory()).getEnCode());
                flowEngineEntity.setFormType(Integer.valueOf(2));
                flowEngineEntity.setFlowTables(entity.getVisualTables());
                flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                flowEngineEntity.setFormData(entity.getFormData());
                this.flowEngineService.create(flowEngineEntity);
                entity.setFlowId(flowEngineEntity.getId());
            }
        }
        List templateList = this.flowEngineTemplateService.getListByFlowId(entity.getId());
        templateList.stream().forEach(template -> {
            template.setId(RandomUtil.uuId());
            template.setEnCode("visualDev" + entity.getEnCode());
            template.setFullName(entity.getFullName());
        });
        this.flowEngineTemplateService.saveBatch((Collection)templateList);
        return this.save(entity);
    }

    @Override
    public Boolean createForm(VisualDevCrForm devCrForm) throws WorkFlowException {
        VisualdevEntity entity = (VisualdevEntity)JsonUtil.getJsonToBean((String)JsonUtilEx.getObjectToString((Object)devCrForm), VisualdevEntity.class);
        if (StringUtils.isEmpty((String)entity.getId())) {
            entity.setId(RandomUtil.uuId());
        }
        List tableModels = JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class);
        Map formMap = JsonUtil.stringToMap((String)entity.getFormData());
        if (tableModels.size() == 0) {
            List list = JsonUtil.getJsonToList(formMap.get("fields"), FieLdsModel.class);
            JSONArray formJsonArray = JsonUtil.getJsonToJsonArray((String)String.valueOf(formMap.get("fields")));
            ArrayList formAllModel = new ArrayList();
            RecursionForm recursionForm = new RecursionForm();
            recursionForm.setTableModelList(JsonUtil.getJsonToList((String)entity.getVisualTables(), TableModel.class));
            recursionForm.setList(list);
            FormCloumnUtil.recursionForm((RecursionForm)recursionForm, formAllModel);
            String tableName = "mt" + RandomUtil.uuId();
            String dbLinkId = entity.getDbLinkId();
            List tableModelList = this.visualDevTableCre.tableList(formJsonArray, formAllModel, tableName, dbLinkId);
            formMap.put("fields", formJsonArray);
            entity.setFormData(JsonUtil.getObjectToString((Object)formMap));
            entity.setVisualTables(JsonUtil.getObjectToString((Object)tableModelList));
        }
        entity.setCreatorUserId(this.userProvider.get().getUserId());
        entity.setSortCode(RandomUtil.parses());
        List<FlowEngineTemplateEntity> templateList = devCrForm.getTemplateList();
        if (CollectionUtil.isNotEmpty(templateList)) {
            templateList.stream().forEach(template -> {
                template.setId(RandomUtil.uuId());
                template.setFlowId(entity.getId());
                template.setEnCode("visualDev" + entity.getEnCode());
                template.setEnabledMark(entity.getEnabledMark());
                template.setVersion(StringUtils.isEmpty((String)template.getVersion()) ? "1" : template.getVersion());
                template.setCreatorTime(new Date());
                template.setCreatorUserId(this.userProvider.get().getUserId());
                this.flowEngineTemplateService.save(template);
            });
        }
        if (ObjectUtil.isNotEmpty((Object)entity.getWebType()) && VisualWebTypeEnum.FLOW_FROM.getType().equals(entity.getWebType())) {
            entity.setFlowId(entity.getId());
            if (entity.getType().equals(1) || entity.getType().equals(2)) {
                FlowEngineEntity flowEngineEntity = new FlowEngineEntity();
                flowEngineEntity.setId(entity.getId());
                flowEngineEntity.setEnCode("visualDev" + entity.getEnCode());
                flowEngineEntity.setType(Integer.valueOf(1));
                flowEngineEntity.setIcon("icon-ym icon-ym-node");
                flowEngineEntity.setIconBackground("#008cff");
                flowEngineEntity.setEnabledMark(Integer.valueOf(1));
                flowEngineEntity.setFullName(entity.getFullName());
                flowEngineEntity.setCategory(this.dictionaryDataService.getInfo(entity.getCategory()).getEnCode());
                flowEngineEntity.setFormType(Integer.valueOf(2));
                flowEngineEntity.setFlowTables(entity.getVisualTables());
                flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                flowEngineEntity.setFormData(entity.getFormData());
                this.flowEngineService.create(flowEngineEntity);
                entity.setFlowId(flowEngineEntity.getId());
            }
        }
        return this.save(entity);
    }

    @Override
    public boolean update(String id, VisualdevEntity entity) throws WorkFlowException {
        entity.setId(id);
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        if (entity.getWebType() != null && VisualWebTypeEnum.FLOW_FROM.getType().equals(entity.getWebType())) {
            FlowEngineEntity flowEngineEntity = (FlowEngineEntity)this.flowEngineService.getById((Serializable)((Object)id));
            VisualdevEntity visualdevEntity = this.getInfo(id);
            if (visualdevEntity.getFlowId() == null) {
                entity.setFlowId(id);
            }
            if (entity.getType().equals(1) || entity.getType().equals(2)) {
                if (flowEngineEntity == null) {
                    flowEngineEntity = new FlowEngineEntity();
                    flowEngineEntity.setId(id);
                    flowEngineEntity.setEnCode("visualDev" + entity.getEnCode());
                    flowEngineEntity.setType(Integer.valueOf(1));
                    flowEngineEntity.setIcon("icon-ym icon-ym-node");
                    flowEngineEntity.setIconBackground("#008cff");
                    flowEngineEntity.setEnabledMark(Integer.valueOf(1));
                    flowEngineEntity.setFormType(Integer.valueOf(2));
                    flowEngineEntity.setFlowTables(entity.getVisualTables());
                    flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                    flowEngineEntity.setFormData(entity.getFormData());
                    flowEngineEntity.setFullName(entity.getFullName());
                    this.flowEngineService.create(flowEngineEntity);
                }
                flowEngineEntity.setFullName(entity.getFullName());
                flowEngineEntity.setFlowTables(entity.getVisualTables());
                flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                flowEngineEntity.setFormData(entity.getFormData());
                flowEngineEntity.setEnabledMark(entity.getState());
                this.flowEngineService.updateVisible(visualdevEntity.getId(), flowEngineEntity);
            }
        }
        return this.updateById(entity);
    }

    @Override
    public boolean updateForm(String id, VisualDevUpForm devUpForm) throws WorkFlowException {
        VisualdevEntity entity = (VisualdevEntity)JsonUtil.getJsonToBean((String)JsonUtilEx.getObjectToString((Object)devUpForm), VisualdevEntity.class);
        entity.setId(id);
        entity.setLastModifyUserId(this.userProvider.get().getUserId());
        if (entity.getWebType() != null && VisualWebTypeEnum.FLOW_FROM.getType().equals(entity.getWebType())) {
            FlowEngineEntity flowEngineEntity = (FlowEngineEntity)this.flowEngineService.getById((Serializable)((Object)id));
            VisualdevEntity visualdevEntity = this.getInfo(id);
            if (visualdevEntity.getFlowId() == null) {
                entity.setFlowId(id);
            }
            List<FlowEngineTemplateEntity> templateList = devUpForm.getTemplateList();
            templateList.stream().forEach(flowTemplate -> {
                if (ObjectUtil.isEmpty((Object)flowTemplate.getId())) {
                    flowTemplate.setId(RandomUtil.uuId());
                    flowTemplate.setFlowId(entity.getId());
                    flowTemplate.setEnCode("visualDev" + entity.getEnCode());
                    flowTemplate.setEnabledMark(entity.getEnabledMark());
                    flowTemplate.setVersion(StringUtils.isEmpty((String)flowTemplate.getVersion()) ? "1" : flowTemplate.getVersion());
                    flowTemplate.setCreatorTime(new Date());
                    flowTemplate.setCreatorUserId(this.userProvider.get().getUserId());
                    this.flowEngineTemplateService.save(flowTemplate);
                }
                FlowEngineTemplateEntity jsonToBean = (FlowEngineTemplateEntity)JsonUtil.getJsonToBean((Object)flowTemplate, FlowEngineTemplateEntity.class);
                jsonToBean.setLastModifyTime(new Date());
                jsonToBean.setLastModifyUserId(this.userProvider.get().getUserId());
                this.flowEngineTemplateService.updateById((Object)jsonToBean);
            });
            if (entity.getType().equals(1) || entity.getType().equals(2)) {
                if (flowEngineEntity == null) {
                    flowEngineEntity = new FlowEngineEntity();
                    flowEngineEntity.setId(id);
                    flowEngineEntity.setEnCode("visualDev" + entity.getEnCode());
                    flowEngineEntity.setType(Integer.valueOf(1));
                    flowEngineEntity.setIcon("icon-ym icon-ym-node");
                    flowEngineEntity.setIconBackground("#008cff");
                    flowEngineEntity.setEnabledMark(Integer.valueOf(1));
                    flowEngineEntity.setFormType(Integer.valueOf(2));
                    flowEngineEntity.setFlowTables(entity.getVisualTables());
                    flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                    flowEngineEntity.setFormData(entity.getFormData());
                    flowEngineEntity.setFullName(entity.getFullName());
                    this.flowEngineService.create(flowEngineEntity);
                }
                flowEngineEntity.setFullName(entity.getFullName());
                flowEngineEntity.setFlowTables(entity.getVisualTables());
                flowEngineEntity.setDbLinkId(entity.getDbLinkId());
                flowEngineEntity.setFormData(entity.getFormData());
                flowEngineEntity.setEnabledMark(entity.getState());
                this.flowEngineService.updateVisible(visualdevEntity.getId(), flowEngineEntity);
            }
        }
        return this.updateById(entity);
    }

    private List<FlowEngineVisibleEntity> visibleList(VisualdevEntity entity) {
        ArrayList<FlowEngineVisibleEntity> visibleList = new ArrayList<FlowEngineVisibleEntity>();
        List listByFlowId = this.flowEngineTemplateService.getListByFlowId(entity.getId());
        listByFlowId.stream().forEach(template -> {
            if (template.getFlowTemplateJson() != null) {
                FlowEngineVisibleEntity visible;
                ChildNode childNode = (ChildNode)JsonUtil.getJsonToBean((String)template.getFlowTemplateJson(), ChildNode.class);
                Properties properties = childNode.getProperties();
                for (String user : properties.getInitiator()) {
                    visible = new FlowEngineVisibleEntity();
                    visible.setTemplateId(template.getId());
                    visible.setOperatorId(user);
                    visible.setOperatorType("user");
                    visible.setCompanyId(template.getCompanyId());
                    visibleList.add(visible);
                }
                for (Object position : properties.getInitiatePos()) {
                    visible = new FlowEngineVisibleEntity();
                    visible.setTemplateId(template.getId());
                    visible.setOperatorId((String)position);
                    visible.setOperatorType("position");
                    visible.setCompanyId(template.getCompanyId());
                    visibleList.add(visible);
                }
                List roleList = properties.getInitiateRole() != null ? properties.getInitiateRole() : new ArrayList();
                for (String role : roleList) {
                    FlowEngineVisibleEntity visible2 = new FlowEngineVisibleEntity();
                    visible2.setTemplateId(template.getId());
                    visible2.setOperatorId(role);
                    visible2.setOperatorType("role");
                    visible2.setCompanyId(template.getCompanyId());
                    visibleList.add(visible2);
                }
                FlowEngineVisibleEntity visible3 = new FlowEngineVisibleEntity();
                visible3.setTemplateId(template.getId());
                visible3.setOperatorId(template.getCompanyId());
                visible3.setOperatorType("company");
                visible3.setCompanyId(template.getCompanyId());
                visibleList.add(visible3);
            }
        });
        return visibleList;
    }

    @Override
    public void delete(VisualdevEntity entity) throws WorkFlowException {
        if (entity != null) {
            FlowEngineEntity flowEngineEntity;
            if (StringUtils.isNotEmpty((String)entity.getFlowId()) && (flowEngineEntity = (FlowEngineEntity)this.flowEngineService.getById((Serializable)((Object)entity.getFlowId()))) != null) {
                this.flowEngineService.delete(flowEngineEntity);
            }
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    public Long getObjByEncode(String encode, Integer type) {
        QueryWrapper visualWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)visualWrapper.lambda().eq(VisualdevEntity::getEnCode, (Object)encode)).eq(VisualdevEntity::getType, (Object)type);
        Long count = ((VisualdevMapper)this.baseMapper).selectCount((Wrapper)visualWrapper);
        return count;
    }

    @Override
    public Long getCountByName(String name, Integer type) {
        QueryWrapper visualWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)visualWrapper.lambda().eq(VisualdevEntity::getFullName, (Object)name)).eq(VisualdevEntity::getType, (Object)type);
        Long count = ((VisualdevMapper)this.baseMapper).selectCount((Wrapper)visualWrapper);
        return count;
    }
}

