/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.generater.controller;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.NoDataSourceBind;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.visiual.DownloadCodeForm;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DesUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.visualdev.base.model.read.ReadListVO;
import com.bringspring.visualdev.base.service.VisualdevService;
import com.bringspring.visualdev.base.util.ReadFile;
import com.bringspring.visualdev.generater.service.VisualdevGenService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u4ee3\u7801\u751f\u6210\u5668"}, value="Generater")
@RestController
@RequestMapping(value={"/api/visualdev/Generater"})
public class VisualdevGenController {
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private VisualdevService visualdevService;
    @Autowired
    private VisualdevGenService visualdevGenService;

    @NoDataSourceBind
    @ApiOperation(value="\u4e0b\u8f7d\u6587\u4ef6")
    @GetMapping(value={"/DownloadVisCode"})
    public void downloadCode() throws DataException {
        HttpServletRequest request = ServletUtils.getRequest();
        String reqJson = request.getParameter("encryption");
        String fileNameAll = DesUtil.aesDecode((String)reqJson);
        if (!StringUtils.isEmpty((String)fileNameAll)) {
            String token = fileNameAll.split("#")[0];
            if (this.cacheUtil.exists(token)) {
                String fileName = fileNameAll.split("#")[1];
                String path = this.configValueUtil.getServiceDirectoryPath() + fileName;
                String zipFile = this.configValueUtil.getTemporaryFilePath() + fileName + ".zip";
                boolean exists = UploadUtil.downCode((String)this.configValueUtil.getFileType(), (String)(fileName + ".zip"), (String)"codetemp", (String)path, (String)zipFile);
                if (!exists) {
                    throw new DataException("\u6587\u4ef6\u4e0d\u5b58\u5728");
                }
            }
        } else {
            throw new DataException("token\u9a8c\u8bc1\u5931\u8d25");
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u547d\u540d\u7a7a\u95f4")
    @GetMapping(value={"/AreasName"})
    public ActionResult getAreasName() {
        String areasName = this.configValueUtil.getCodeAreasName();
        ArrayList<String> areasNameList = new ArrayList<String>(Arrays.asList(areasName.split(",")));
        return ActionResult.success(areasNameList);
    }

    @ApiOperation(value="\u4e0b\u8f7d\u4ee3\u7801")
    @PostMapping(value={"/{id}/Actions/DownloadCode"})
    @DSTransactional
    public ActionResult downloadCode(@PathVariable(value="id") String id, @RequestBody DownloadCodeForm downloadCodeForm) throws Exception {
        UserInfo userInfo = this.userProvider.get();
        String fileName = this.visualdevGenService.codeGengerate(id, downloadCodeForm);
        UploadUtil.uploadFolder((String)this.configValueUtil.getFileType(), (String)fileName, (String)"codetemp", (String)this.configValueUtil.getServiceDirectoryPath());
        DownloadVO vo = DownloadVO.builder().name(fileName).url(UploaderUtil.uploaderVisualFile((String)(userInfo.getId() + "#" + fileName))).build();
        if (vo == null) {
            return ActionResult.fail((String)MsgCode.FA006.get());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u9884\u89c8\u4ee3\u7801")
    @PostMapping(value={"/{id}/Actions/CodePreview"})
    public ActionResult codePreview(@PathVariable(value="id") String id, @RequestBody DownloadCodeForm downloadCodeForm) throws Exception {
        String fileName = this.visualdevGenService.codeGengerate(id, downloadCodeForm);
        List<ReadListVO> dataList = ReadFile.priviewCode(this.configValueUtil.getServiceDirectoryPath() + fileName);
        if (dataList.size() == 0) {
            return ActionResult.fail((String)MsgCode.FA015.get());
        }
        ListVO datas = new ListVO();
        datas.setList(dataList);
        return ActionResult.success((Object)datas);
    }

    @ApiOperation(value="App\u9884\u89c8(\u540e\u53f0APP\u8868\u5355\u8bbe\u8ba1)")
    @PostMapping(value={"/App/Preview"})
    public ActionResult appPreview(String data) {
        String id = RandomUtil.uuId();
        this.cacheUtil.insert("fiveMinutesCacheSpace", id, (Object)data, 300L);
        return ActionResult.success((Object)id);
    }

    @ApiOperation(value="App\u9884\u89c8\u67e5\u770b")
    @GetMapping(value={"/App/{id}/Preview"})
    public ActionResult preview(@PathVariable(value="id") String id) {
        if (this.cacheUtil.exists("fiveMinutesCacheSpace", id)) {
            Object object = this.cacheUtil.query("fiveMinutesCacheSpace", id);
            return ActionResult.success((Object)object);
        }
        return ActionResult.fail((String)MsgCode.FA019.get());
    }
}

