/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.onlinedev.util;

import cn.hutool.core.util.ObjectUtil;
import com.bringspring.common.model.visiual.fields.FieLdsModel;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.context.SpringContext;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.PositionEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.PermissionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class AutoFeildsUtil {
    private static OrganizeService organizeService;
    private static UserService userService;
    private static PositionService positionService;

    public static void init() {
        userService = (UserService)SpringContext.getBean(UserService.class);
        organizeService = (OrganizeService)SpringContext.getBean(OrganizeService.class);
        positionService = (PositionService)SpringContext.getBean(PositionService.class);
    }

    public static String autoFeilds(List<FieLdsModel> fieLdsModelList, String data) {
        AutoFeildsUtil.init();
        for (FieLdsModel fieLdsModel : fieLdsModelList) {
            Map dataMap = JsonUtil.stringToMap((String)data);
            block16: for (Map.Entry entry : dataMap.entrySet()) {
                String keyNameType;
                if (!fieLdsModel.getVModel().equals(entry.getKey())) continue;
                switch (keyNameType = fieLdsModel.getConfig().getKeyName()) {
                    case "currOrganize": 
                    case "currDept": {
                        List orgMapList = organizeService.getOrgRedisList();
                        for (OrganizeEntity organizeEntity : orgMapList) {
                            if (!String.valueOf(entry.getValue()).equals(organizeEntity.getId())) continue;
                            if ("all".equals(fieLdsModel.getShowLevel())) {
                                entry.setValue(PermissionUtil.getLinkInfoByOrgId((String)organizeEntity.getId(), (OrganizeService)organizeService, (Boolean)false));
                                continue;
                            }
                            entry.setValue(organizeEntity.getFullName());
                        }
                        continue block16;
                    }
                    case "createUser": 
                    case "modifyUser": {
                        UserEntity userCreEntity = userService.getInfo(String.valueOf(entry.getValue()));
                        if (userCreEntity == null) break;
                        entry.setValue(userCreEntity.getRealName());
                        break;
                    }
                    case "currPosition": {
                        String[] curPos = String.valueOf(entry.getValue()).split(",");
                        ArrayList<String> curPosList = new ArrayList<String>();
                        for (String pos : curPos) {
                            PositionEntity posEntity = positionService.getInfo(pos);
                            String posName = Objects.nonNull(posEntity) ? posEntity.getFullName() : "";
                            curPosList.add(posName);
                        }
                        entry.setValue(curPosList.stream().collect(Collectors.joining(",")));
                        break;
                    }
                    case "createTime": 
                    case "modifyTime": {
                        if (ObjectUtil.isNotEmpty(entry.getValue())) {
                            String dateStr = String.valueOf(entry.getValue());
                            dateStr = dateStr.length() > 19 ? dateStr.substring(0, 19) : dateStr;
                            entry.setValue(dateStr);
                            break;
                        }
                        entry.setValue(null);
                        break;
                    }
                }
            }
            data = JsonUtilEx.getObjectToString((Object)dataMap);
        }
        return data;
    }
}

