/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.visualdev.portal.controller;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.ListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.FileUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.enums.DictionaryDataEnum;
import com.bringspring.common.util.enums.ExportModelTypeEnum;
import com.bringspring.common.util.enums.ModuleTypeEnum;
import com.bringspring.common.util.file.FileExport;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.system.base.entity.DictionaryDataEntity;
import com.bringspring.system.base.entity.ModuleEntity;
import com.bringspring.system.base.service.DictionaryDataService;
import com.bringspring.system.base.service.ModuleService;
import com.bringspring.system.base.util.JsonUtilEx;
import com.bringspring.system.permission.entity.AuthorizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visualdev.base.model.VisualFunctionModel;
import com.bringspring.visualdev.portal.entity.PortalEntity;
import com.bringspring.visualdev.portal.model.PortalCrForm;
import com.bringspring.visualdev.portal.model.PortalExportDataVo;
import com.bringspring.visualdev.portal.model.PortalInfoAuthVO;
import com.bringspring.visualdev.portal.model.PortalInfoVO;
import com.bringspring.visualdev.portal.model.PortalPagination;
import com.bringspring.visualdev.portal.model.PortalSelectModel;
import com.bringspring.visualdev.portal.model.PortalSelectVO;
import com.bringspring.visualdev.portal.model.PortalUpForm;
import com.bringspring.visualdev.portal.service.PortalService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u53ef\u89c6\u5316\u95e8\u6237"}, value="Portal")
@RequestMapping(value={"/api/visualdev/Portal"})
public class PortalController {
    private static final Logger log = LoggerFactory.getLogger(PortalController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private PortalService portalService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private DictionaryDataService dictionaryDataService;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private FileExport fileExport;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private ModuleService moduleService;

    @GetMapping
    public ActionResult list(PortalPagination portalPagination) {
        List<PortalEntity> data = this.portalService.getList(portalPagination);
        List userId = data.stream().map(t -> t.getCreatorUserId()).collect(Collectors.toList());
        List lastUserId = data.stream().map(t -> t.getLastModifyUserId()).collect(Collectors.toList());
        List userEntities = this.userService.getUserName(userId);
        List lastUserIdEntities = this.userService.getUserName(lastUserId);
        List dictionList = this.dictionaryDataService.getList(DictionaryDataEnum.VISUALDEV_PORTAL.getDictionaryTypeId());
        List<Object> modelAll = new LinkedList();
        for (PortalEntity entity : data) {
            VisualFunctionModel model = (VisualFunctionModel)JsonUtil.getJsonToBean((Object)entity, VisualFunctionModel.class);
            DictionaryDataEntity dataEntity = dictionList.stream().filter(t -> t.getId().equals(entity.getCategory())).findFirst().orElse(null);
            if (dataEntity == null) continue;
            model.setCategory(dataEntity.getFullName());
            UserEntity creatorUser = userEntities.stream().filter(t -> t.getId().equals(model.getCreatorUserId())).findFirst().orElse(null);
            if (creatorUser != null) {
                model.setCreatorUserId(creatorUser.getRealName());
            } else {
                model.setCreatorUserId("");
            }
            UserEntity lastmodifyuser = lastUserIdEntities.stream().filter(t -> t.getId().equals(model.getLastModifyUserId())).findFirst().orElse(null);
            if (lastmodifyuser != null) {
                model.setLastModifyUserId(lastmodifyuser.getRealName());
            } else {
                model.setLastModifyUserId("");
            }
            if (Objects.isNull(model.getSortCode())) {
                model.setSortCode(0L);
            }
            modelAll.add(model);
        }
        modelAll = modelAll.stream().sorted(Comparator.comparing(VisualFunctionModel::getSortCode)).collect(Collectors.toList());
        PaginationVO paginationVO = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)portalPagination), PaginationVO.class);
        return ActionResult.page(modelAll, (PaginationVO)paginationVO);
    }

    @GetMapping(value={"/Selector"})
    public ActionResult listSelect(String type) {
        List<PortalSelectModel> modelList = this.portalService.getList(type);
        List sumTrees = TreeDotUtils.convertListToTreeDot(modelList);
        List listVO = JsonUtil.getJsonToList((Object)sumTrees, PortalSelectVO.class);
        ListVO treeVo = new ListVO();
        treeVo.setList(listVO);
        return ActionResult.success((Object)treeVo);
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<PortalInfoVO> info(@PathVariable(value="id") String id) {
        PortalEntity entity = this.portalService.getInfo(id);
        PortalInfoVO vo = (PortalInfoVO)JsonUtil.getJsonToBean((String)JsonUtilEx.getObjectToStringDateFormat((Object)entity, (String)"yyyy-MM-dd HH:mm:ss"), PortalInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/{id}/auth"})
    public ActionResult<PortalInfoAuthVO> infoAuth(@PathVariable(value="id") String id) {
        UserInfo userInfo = this.userProvider.get();
        UserEntity info = this.userService.getInfo(userInfo.getUserId());
        List<String> strings = Arrays.asList(info.getRoleId().split(","));
        if (userInfo != null && strings != null) {
            for (String roleId : strings) {
                List authByObjectId = this.authorizeService.getListByObjectId(roleId);
                List authorizeEntityList = authByObjectId.stream().filter(t -> "portal".equals(t.getItemType())).collect(Collectors.toList());
                for (AuthorizeEntity authorizeEntity : authorizeEntityList) {
                    if (!id.equals(authorizeEntity.getItemId())) continue;
                    PortalEntity entity = this.portalService.getInfo(id);
                    PortalInfoAuthVO vo = (PortalInfoAuthVO)JsonUtil.getJsonToBean((String)JsonUtilEx.getObjectToStringDateFormat((Object)entity, (String)"yyyy-MM-dd HH:mm:ss"), PortalInfoAuthVO.class);
                    return ActionResult.success((Object)vo);
                }
                List moduleListByProperty = this.moduleService.getModuleListByProperty(id).stream().map(ModuleEntity::getId).collect(Collectors.toList());
                List roleAuth = authByObjectId.stream().map(AuthorizeEntity::getItemId).collect(Collectors.toList());
                roleAuth.retainAll(moduleListByProperty);
                if (!ObjectUtil.isNotEmpty(roleAuth)) continue;
                PortalEntity entity = this.portalService.getInfo(id);
                PortalInfoAuthVO vo = (PortalInfoAuthVO)JsonUtil.getJsonToBean((String)JsonUtilEx.getObjectToStringDateFormat((Object)entity, (String)"yyyy-MM-dd HH:mm:ss"), PortalInfoAuthVO.class);
                return ActionResult.success((Object)vo);
            }
            if (userInfo.getIsAdministrator().booleanValue()) {
                PortalEntity entity = this.portalService.getInfo(id);
                PortalInfoAuthVO vo = (PortalInfoAuthVO)JsonUtil.getJsonToBean((String)JsonUtilEx.getObjectToStringDateFormat((Object)entity, (String)"yyyy-MM-dd HH:mm:ss"), PortalInfoAuthVO.class);
                return ActionResult.success((Object)vo);
            }
        }
        return ActionResult.fail((String)"\u60a8\u6ca1\u6709\u6b64\u95e8\u6237\u4f7f\u7528\u6743\u9650\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e");
    }

    @DeleteMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult delete(@PathVariable(value="id") String id) {
        PortalEntity entity = this.portalService.getInfo(id);
        if (entity != null) {
            this.portalService.delete(entity);
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(AuthorizeEntity::getItemId, (Object)id);
            this.authorizeService.remove((Wrapper)queryWrapper);
        }
        return ActionResult.success((String)MsgCode.SU003.get());
    }

    @PostMapping
    @DSTransactional
    public ActionResult create(@RequestBody @Valid PortalCrForm portalCrForm) {
        PortalEntity entity = (PortalEntity)JsonUtil.getJsonToBean((Object)portalCrForm, PortalEntity.class);
        entity.setId(RandomUtil.uuId());
        this.portalService.create(entity);
        return ActionResult.success((String)MsgCode.SU001.get());
    }

    @ApiOperation(value="\u590d\u5236\u529f\u80fd")
    @PostMapping(value={"/{id}/Actions/Copy"})
    public ActionResult copyInfo(@PathVariable(value="id") String id) {
        PortalEntity entity = this.portalService.getInfo(id);
        entity.setEnabledMark(0);
        String copyNum = UUID.randomUUID().toString().substring(0, 5);
        entity.setFullName(entity.getFullName() + ".\u526f\u672c" + copyNum);
        entity.setLastModifyTime(null);
        entity.setLastModifyUserId(null);
        entity.setId(RandomUtil.uuId());
        entity.setEnCode(entity.getEnCode() + copyNum);
        PortalEntity entity1 = (PortalEntity)JsonUtil.getJsonToBean((Object)entity, PortalEntity.class);
        if (entity1.getEnCode().length() > 50 || entity1.getFullName().length() > 50) {
            return ActionResult.fail((String)"\u5df2\u5230\u8fbe\u8be5\u6a21\u677f\u590d\u5236\u4e0a\u9650\uff0c\u8bf7\u590d\u5236\u6e90\u6a21\u677f");
        }
        this.portalService.create(entity1);
        return ActionResult.success((String)MsgCode.SU007.get());
    }

    @PutMapping(value={"/{id}"})
    @DSTransactional
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid PortalUpForm portalUpForm) {
        PortalEntity entity = (PortalEntity)JsonUtil.getJsonToBean((Object)portalUpForm, PortalEntity.class);
        boolean flag = this.portalService.update(id, entity);
        if (!flag) {
            return ActionResult.fail((String)MsgCode.FA002.get());
        }
        return ActionResult.success((String)MsgCode.SU004.get());
    }

    @DSTransactional
    @ApiOperation(value="\u8bbe\u7f6e\u9ed8\u8ba4\u95e8\u6237")
    @PutMapping(value={"/{id}/Actions/SetDefault"})
    public ActionResult setDefault(@PathVariable(value="id") String id) {
        UserEntity userEntity = this.userService.getInfo(this.userProvider.get().getUserId());
        if (userEntity != null) {
            userEntity.setPortalId(id);
            this.userService.update(userEntity);
            String catchKey = this.cacheKeyUtil.getAllUser();
            if (this.cacheUtil.exists(catchKey)) {
                this.cacheUtil.remove(catchKey);
            }
        } else {
            return ActionResult.fail((String)"\u8bbe\u7f6e\u5931\u8d25\uff0c\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return ActionResult.success((String)MsgCode.SU016.get());
    }

    @ApiOperation(value="\u95e8\u6237\u5bfc\u51fa")
    @PostMapping(value={"/{modelId}/Actions/ExportData"})
    public ActionResult exportFunction(@PathVariable(value="modelId") String modelId) {
        PortalEntity entity = this.portalService.getInfo(modelId);
        if (entity != null) {
            PortalExportDataVo vo = new PortalExportDataVo();
            BeanUtils.copyProperties((Object)entity, (Object)vo);
            vo.setModelType(ExportModelTypeEnum.Portal.getMessage());
            DownloadVO downloadVO = this.fileExport.exportFile((Object)vo, this.configValueUtil.getTemporaryFilePath(), entity.getFullName(), ModuleTypeEnum.VISUAL_PORTAL.getTableName());
            return ActionResult.success((Object)downloadVO);
        }
        return ActionResult.success((String)"\u5e76\u65e0\u8be5\u6761\u6570\u636e");
    }

    @ApiOperation(value="\u95e8\u6237\u5bfc\u5165")
    @PostMapping(value={"/Model/Actions/ImportData"}, consumes={"multipart/form-data"})
    public ActionResult importFunction(@RequestPart(value="file") MultipartFile multipartFile) {
        PortalEntity portalEntity;
        if (FileUtil.existsSuffix((MultipartFile)multipartFile, (String)ModuleTypeEnum.VISUAL_PORTAL.getTableName())) {
            return ActionResult.fail((String)MsgCode.IMP002.get());
        }
        String fileContent = FileUtil.getFileContent((MultipartFile)multipartFile, (String)this.configValueUtil.getTemporaryFilePath());
        PortalExportDataVo vo = (PortalExportDataVo)JsonUtil.getJsonToBean((String)fileContent, PortalExportDataVo.class);
        if (vo.getModelType() == null || !vo.getModelType().equals(ExportModelTypeEnum.Portal.getMessage())) {
            return ActionResult.fail((String)"\u8bf7\u5bfc\u5165\u5bf9\u5e94\u529f\u80fd\u7684json\u6587\u4ef6");
        }
        String modelId = vo.getId();
        if (StringUtils.isNotEmpty((String)modelId) && (portalEntity = this.portalService.getInfo(modelId)) != null) {
            return ActionResult.fail((String)"\u5df2\u5b58\u5728\u76f8\u540c\u529f\u80fd");
        }
        PortalEntity entity = (PortalEntity)JsonUtil.getJsonToBean((String)fileContent, PortalEntity.class);
        this.portalService.create(entity);
        return ActionResult.success((String)MsgCode.IMP001.get());
    }
}

