/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.excel.html;

import cn.afterturn.easypoi.excel.export.styler.ExcelExportStylerDefaultImpl;
import cn.afterturn.easypoi.excel.html.css.CssParseService;
import cn.afterturn.easypoi.excel.html.css.ICssConvertToExcel;
import cn.afterturn.easypoi.excel.html.css.impl.AlignCssConvertImpl;
import cn.afterturn.easypoi.excel.html.css.impl.BackgroundCssConvertImpl;
import cn.afterturn.easypoi.excel.html.css.impl.BorderCssConverImpl;
import cn.afterturn.easypoi.excel.html.css.impl.HeightCssConverImpl;
import cn.afterturn.easypoi.excel.html.css.impl.TextCssConvertImpl;
import cn.afterturn.easypoi.excel.html.css.impl.WidthCssConverImpl;
import cn.afterturn.easypoi.excel.html.entity.style.CellStyleEntity;
import cn.afterturn.easypoi.util.PoiMergeCellUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.RuntimeErrorException;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToExcelService {
    private final Logger LOGGER = LoggerFactory.getLogger(HtmlToExcelService.class);
    private static final List<ICssConvertToExcel> STYLE_APPLIERS = new LinkedList<ICssConvertToExcel>();
    private static final List<ICssConvertToExcel> SHEET_APPLIERS = new LinkedList<ICssConvertToExcel>();
    private Sheet sheet;
    private Map<String, Object> cellsOccupied;
    private Map<String, CellStyle> cellStyles;
    private CellStyle defaultCellStyle;
    private int maxRow;
    private CssParseService cssParse;

    public HtmlToExcelService() {
        STYLE_APPLIERS.add(new AlignCssConvertImpl());
        STYLE_APPLIERS.add(new BackgroundCssConvertImpl());
        STYLE_APPLIERS.add(new BorderCssConverImpl());
        STYLE_APPLIERS.add(new TextCssConvertImpl());
        SHEET_APPLIERS.add(new WidthCssConverImpl());
        SHEET_APPLIERS.add(new HeightCssConverImpl());
        this.cellsOccupied = new HashMap<String, Object>();
        this.cellStyles = new HashMap<String, CellStyle>();
        this.maxRow = 0;
        this.cssParse = new CssParseService();
    }

    private void processTable(Element table) {
        int rowIndex = 0;
        if (this.maxRow > 0) {
            this.maxRow += 2;
            rowIndex = this.maxRow;
        }
        this.LOGGER.debug("Interate Table Rows.");
        String freezeCol = null;
        int freezeColIndex = -1;
        for (Element row : table.select("tr")) {
            this.LOGGER.debug("Parse Table Row [{}]. Row Index [{}].", (Object)row, (Object)rowIndex);
            String freezeRow = row.attr("freezeRow");
            if ("true".equals(freezeRow)) {
                this.sheet.createFreezePane(0, rowIndex + 1, 0, rowIndex + 1);
            }
            int colIndex = 0;
            this.LOGGER.debug("Interate Cols.");
            for (Element td : row.select("td, th")) {
                freezeCol = td.attr("freezeCol");
                if ("true".equals(freezeCol) && colIndex > freezeColIndex) {
                    freezeColIndex = colIndex;
                }
                while (this.cellsOccupied.get(rowIndex + "_" + colIndex) != null) {
                    this.LOGGER.debug("Cell [{}][{}] Has Been Occupied, Skip.", (Object)rowIndex, (Object)colIndex);
                    ++colIndex;
                }
                this.LOGGER.debug("Parse Col [{}], Col Index [{}].", (Object)td, (Object)colIndex);
                int rowSpan = 0;
                String strRowSpan = td.attr("rowspan");
                if (StringUtils.isNotBlank((CharSequence)strRowSpan) && StringUtils.isNumeric((CharSequence)strRowSpan)) {
                    this.LOGGER.debug("Found Row Span [{}].", (Object)strRowSpan);
                    rowSpan = Integer.parseInt(strRowSpan);
                }
                int colSpan = 0;
                String strColSpan = td.attr("colspan");
                if (StringUtils.isNotBlank((CharSequence)strColSpan) && StringUtils.isNumeric((CharSequence)strColSpan)) {
                    this.LOGGER.debug("Found Col Span [{}].", (Object)strColSpan);
                    colSpan = Integer.parseInt(strColSpan);
                }
                if (colSpan > 1 && rowSpan > 1) {
                    this.spanRowAndCol(td, rowIndex, colIndex, rowSpan, colSpan);
                    colIndex += colSpan;
                    continue;
                }
                if (colSpan > 1) {
                    this.spanCol(td, rowIndex, colIndex, colSpan);
                    colIndex += colSpan;
                    continue;
                }
                if (rowSpan > 1) {
                    this.spanRow(td, rowIndex, colIndex, rowSpan);
                    ++colIndex;
                    continue;
                }
                this.createCell(td, this.getOrCreateRow(rowIndex), colIndex).setCellValue(td.text());
                ++colIndex;
            }
            ++rowIndex;
        }
        if (freezeColIndex != -1) {
            this.sheet.createFreezePane(freezeColIndex + 1, 0, freezeColIndex + 1, 0);
        }
    }

    public Workbook createSheet(String html, Workbook workbook) {
        Elements els = Jsoup.parseBodyFragment((String)html).select("table");
        HashMap<String, Sheet> sheets = new HashMap<String, Sheet>();
        HashMap<String, Integer> maxrowMap = new HashMap<String, Integer>();
        for (Element table : els) {
            String sheetName = table.attr("sheetName");
            if (StringUtils.isBlank((CharSequence)sheetName)) {
                this.LOGGER.error("table\u5fc5\u987b\u5b58\u5728name\u5c5e\u6027!");
                throw new RuntimeErrorException(null, "table\u5fc5\u987b\u5b58\u5728name\u5c5e\u6027");
            }
            if (sheets.containsKey(sheetName)) {
                this.maxRow = (Integer)maxrowMap.get(sheetName);
                this.sheet = (Sheet)sheets.get(sheetName);
            } else {
                this.maxRow = 0;
                this.cellStyles.clear();
                this.cellsOccupied.clear();
                this.sheet = workbook.createSheet(sheetName);
            }
            this.defaultCellStyle = new ExcelExportStylerDefaultImpl(workbook).stringNoneStyle(workbook, false);
            this.processTable(table);
            maxrowMap.put(sheetName, this.maxRow);
            sheets.put(sheetName, this.sheet);
        }
        return workbook;
    }

    private void spanRow(Element td, int rowIndex, int colIndex, int rowSpan) {
        this.LOGGER.debug("Span Row , From Row [{}], Span [{}].", (Object)rowIndex, (Object)rowSpan);
        this.mergeRegion(rowIndex, rowIndex + rowSpan - 1, colIndex, colIndex);
        for (int i = 0; i < rowSpan; ++i) {
            Row row = this.getOrCreateRow(rowIndex + i);
            this.createCell(td, row, colIndex);
            this.cellsOccupied.put(rowIndex + i + "_" + colIndex, true);
        }
        this.getOrCreateRow(rowIndex).getCell(colIndex).setCellValue(td.text());
    }

    private void spanCol(Element td, int rowIndex, int colIndex, int colSpan) {
        this.LOGGER.debug("Span Col, From Col [{}], Span [{}].", (Object)colIndex, (Object)colSpan);
        this.mergeRegion(rowIndex, rowIndex, colIndex, colIndex + colSpan - 1);
        Row row = this.getOrCreateRow(rowIndex);
        for (int i = 0; i < colSpan; ++i) {
            this.createCell(td, row, colIndex + i);
        }
        row.getCell(colIndex).setCellValue(td.text());
    }

    private void spanRowAndCol(Element td, int rowIndex, int colIndex, int rowSpan, int colSpan) {
        this.LOGGER.debug("Span Row And Col, From Row [{}], Span [{}].", (Object)rowIndex, (Object)rowSpan);
        this.LOGGER.debug("From Col [{}], Span [{}].", (Object)colIndex, (Object)colSpan);
        this.mergeRegion(rowIndex, rowIndex + rowSpan - 1, colIndex, colIndex + colSpan - 1);
        for (int i = 0; i < rowSpan; ++i) {
            Row row = this.getOrCreateRow(rowIndex + i);
            for (int j = 0; j < colSpan; ++j) {
                this.createCell(td, row, colIndex + j);
                this.cellsOccupied.put(rowIndex + i + "_" + (colIndex + j), true);
            }
        }
        this.getOrCreateRow(rowIndex).getCell(colIndex).setCellValue(td.text());
    }

    private Cell createCell(Element td, Row row, int colIndex) {
        Cell cell = row.getCell(colIndex);
        if (cell == null) {
            this.LOGGER.debug("Create Cell [{}][{}].", (Object)row.getRowNum(), (Object)colIndex);
            cell = row.createCell(colIndex);
        }
        return this.applyStyle(td, cell);
    }

    private Cell applyStyle(Element td, Cell cell) {
        String style = td.attr("style");
        CellStyle cellStyle = null;
        if (StringUtils.isNotBlank((CharSequence)style)) {
            CellStyleEntity styleEntity = this.cssParse.parseStyle(style.trim());
            cellStyle = this.cellStyles.get(styleEntity.toString());
            if (cellStyle == null) {
                this.LOGGER.debug("No Cell Style Found In Cache, Parse New Style.");
                cellStyle = cell.getRow().getSheet().getWorkbook().createCellStyle();
                cellStyle.cloneStyleFrom(this.defaultCellStyle);
                for (ICssConvertToExcel cssConvert : STYLE_APPLIERS) {
                    cssConvert.convertToExcel(cell, cellStyle, styleEntity);
                }
                this.cellStyles.put(styleEntity.toString(), cellStyle);
            }
            for (ICssConvertToExcel cssConvert : SHEET_APPLIERS) {
                cssConvert.convertToExcel(cell, cellStyle, styleEntity);
            }
            if (this.cellStyles.size() >= 4000) {
                this.LOGGER.info("Custom Cell Style Exceeds 4000, Could Not Create New Style, Use Default Style.");
                cellStyle = this.defaultCellStyle;
            }
        } else {
            this.LOGGER.debug("Style is null ,Use Default Cell Style.");
            cellStyle = this.defaultCellStyle;
        }
        cell.setCellStyle(cellStyle);
        return cell;
    }

    private Row getOrCreateRow(int rowIndex) {
        Row row = this.sheet.getRow(rowIndex);
        if (row == null) {
            this.LOGGER.debug("Create New Row [{}].", (Object)rowIndex);
            row = this.sheet.createRow(rowIndex);
            if (rowIndex > this.maxRow) {
                this.maxRow = rowIndex;
            }
        }
        return row;
    }

    private void mergeRegion(int firstRow, int lastRow, int firstCol, int lastCol) {
        this.LOGGER.debug("Merge Region, From Row [{}], To [{}].", (Object)firstRow, (Object)lastRow);
        this.LOGGER.debug("From Col [{}], To [{}].", (Object)firstCol, (Object)lastCol);
        PoiMergeCellUtil.addMergedRegion(this.sheet, firstRow, lastRow, firstCol, lastCol);
    }
}

