/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.enums;

import com.google.zxing.BarcodeFormat;

public enum BarcodeType {
    CODA_BAR(BarcodeFormat.CODABAR),
    CODE_39(BarcodeFormat.CODE_39),
    CODE_93(BarcodeFormat.CODE_93),
    CODE_128(BarcodeFormat.CODE_128),
    EAN_8(BarcodeFormat.EAN_8),
    EAN_13(BarcodeFormat.EAN_13),
    ITF(BarcodeFormat.ITF),
    UPC_A(BarcodeFormat.UPC_A),
    UPC_E(BarcodeFormat.UPC_E),
    QR_CODE(BarcodeFormat.QR_CODE),
    AZTEC(BarcodeFormat.AZTEC),
    DATA_MATRIX(BarcodeFormat.DATA_MATRIX),
    MAXI_CODE(BarcodeFormat.MAXICODE),
    PDF_417(BarcodeFormat.PDF_417);

    private final BarcodeFormat codeFormat;

    private BarcodeType(BarcodeFormat codeFormat) {
        this.codeFormat = codeFormat;
    }

    public BarcodeFormat getCodeFormat() {
        return this.codeFormat;
    }

    public boolean isQrType() {
        switch (this) {
            case QR_CODE: 
            case AZTEC: 
            case DATA_MATRIX: 
            case MAXI_CODE: 
            case PDF_417: {
                return true;
            }
        }
        return false;
    }
}

