/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.analyzer;

import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.analyzer.AbstractBookmarkAnalyzer;

public class BookmarkAnalyzer
extends AbstractBookmarkAnalyzer {
    public BookmarkAnalyzer(Document document) {
        super(document);
    }

    @Override
    public void processOutlineItem(int ... bookmarkIndex) {
        PDDocumentCatalog documentCatalog = this.getDocument().getDocumentCatalog();
        PDDocumentOutline documentOutline = documentCatalog.getDocumentOutline();
        if (Objects.nonNull(documentOutline)) {
            if (Objects.nonNull(bookmarkIndex) && bookmarkIndex.length > 0) {
                List<PDOutlineItem> items = this.toOutlineItemList(documentOutline.children());
                for (int index : bookmarkIndex) {
                    if (index <= 0) continue;
                    this.processOutlineItem(this.infoSet, documentCatalog, items.get(index));
                }
            } else {
                documentOutline.children().forEach(outlineItem -> this.processOutlineItem(this.infoSet, documentCatalog, (PDOutlineItem)outlineItem));
            }
        }
    }
}

