/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.convertor.html;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.convertor.AbstractConvertor;
import org.dromara.pdf.pdfbox.core.ext.convertor.html.HtmlType;

public abstract class AbstractHtmlConvertor
extends AbstractConvertor {
    public AbstractHtmlConvertor(Document document) {
        super(document);
    }

    public abstract Document toPdf(HtmlType var1, InputStream var2);

    public Document toPdf(HtmlType type, String source) {
        Objects.requireNonNull(type, "the type can not be null");
        return super.toPdf(type.getType(), source);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document toPdf(HtmlType type, File source) {
        Objects.requireNonNull(source, "the source can not be null");
        try (InputStream inputStream = Files.newInputStream(source.toPath(), new OpenOption[0]);){
            Document document = this.toPdf(type, inputStream);
            return document;
        }
    }
}

