/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.extractor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFreeText;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationText;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.extractor.AbstractExtractor;

public abstract class AbstractCommentExtractor
extends AbstractExtractor {
    public AbstractCommentExtractor(Document document) {
        super(document);
    }

    public abstract Map<Integer, List<String>> extract(String var1, int ... var2);

    protected Map<Integer, List<String>> processComment(String regex, int ... pageIndexes) {
        HashMap<Integer, List<String>> data = new HashMap<Integer, List<String>>(32);
        PDPageTree pageTree = this.getDocument().getPages();
        if (Objects.nonNull(pageIndexes) && pageIndexes.length > 0) {
            for (int index : pageIndexes) {
                data.put(index, this.processComment(regex, pageTree.get(index)));
            }
        } else {
            for (int index = 0; index < this.getDocument().getNumberOfPages(); ++index) {
                data.put(index, this.processComment(regex, pageTree.get(index)));
            }
        }
        return data;
    }

    protected List<String> processComment(String regex, PDPage page) {
        ArrayList<String> list = new ArrayList<String>(32);
        List pdAnnotations = page.getAnnotations();
        for (PDAnnotation pa : pdAnnotations) {
            if (!(pa instanceof PDAnnotationText) && !(pa instanceof PDAnnotationFreeText)) continue;
            String comment = pa.getContents();
            if (Objects.nonNull(regex) && !regex.trim().isEmpty()) {
                Matcher matcher = Pattern.compile(regex).matcher(comment);
                while (matcher.find()) {
                    list.add(matcher.group());
                }
                continue;
            }
            list.add(comment);
        }
        return list;
    }
}

