/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.parser.ai;

import com.alibaba.fastjson2.JSONObject;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.ext.parser.ai.AIParseInfo;
import org.dromara.pdf.pdfbox.core.ext.parser.ai.AbstractAIParser;
import org.dromara.pdf.pdfbox.util.HttpUtil;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class BaiDuAIParser
extends AbstractAIParser {
    public BaiDuAIParser(Document document, String ak, String sk) {
        super(document, ak, sk, false);
    }

    @Override
    public AIParseInfo parsePageWithImage(String prompt, int pageIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AIParseInfo parseImageWithPage(String prompt, int pageIndex, int imageIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AIParseInfo parseTextWithPage(String prompt, int beginPageIndex, int endPageIndex) {
        throw new UnsupportedOperationException();
    }

    protected static class Message {
        protected String role;
        protected String content;

        public Message(String role, String content) {
            this.role = role;
            this.content = content;
        }

        @Generated
        public void setRole(String role) {
            this.role = role;
        }

        @Generated
        public void setContent(String content) {
            this.content = content;
        }

        @Generated
        public String getRole() {
            return this.role;
        }

        @Generated
        public String getContent() {
            return this.content;
        }
    }

    protected static class TextParser
    extends Parser {
        private static final String URL = "https://aip.baidubce.com/rpc/2.0/ai_custom/v1/wenxinworkshop/chat/ernie-speed-128k";
        protected String systemPrompt = "<role>\u4f60\u662f\u4e00\u4e2a\u6570\u636e\u5206\u6790\u4e0e\u63d0\u53d6\u4e13\u5bb6</role>";

        protected TextParser() {
        }

        public void setModel(String model) {
            throw new UnsupportedOperationException();
        }

        public AIParseInfo parse(OkHttpClient client, String ak, String sk, String prompt, String text) {
            String jsonBody = JSONObject.of((String)"messages", this.createMessages(prompt, text)).toString();
            return this.parseInfo(client, ak, sk, URL, jsonBody);
        }

        protected List<Message> createMessages(String prompt, String text) {
            ArrayList<Message> messages = new ArrayList<Message>(3);
            if (Objects.nonNull(this.systemPrompt)) {
                messages.add(new Message("user", this.systemPrompt));
            }
            messages.add(new Message("user", text));
            messages.add(new Message("user", prompt));
            return messages;
        }

        @Generated
        public void setSystemPrompt(String systemPrompt) {
            this.systemPrompt = systemPrompt;
        }
    }

    protected static class ImageParser
    extends Parser {
        private static final String URL = "https://aip.baidubce.com/rpc/2.0/ai_custom/v1/wenxinworkshop/image2text/fuyu_8b";

        protected ImageParser() {
        }

        public void setModel(String model) {
            throw new UnsupportedOperationException();
        }

        public void setSystemPrompt(String prompt) {
            throw new UnsupportedOperationException();
        }

        public AIParseInfo parse(OkHttpClient client, String ak, String sk, String prompt, BufferedImage image) {
            String jsonBody = JSONObject.of((String)"prompt", (Object)prompt).fluentPut("image", (Object)ImageUtil.toBase64(image, ImageType.PNG.getType())).toString();
            return this.parseInfo(client, ak, sk, URL, jsonBody);
        }
    }

    protected static class Parser {
        private static final String ACCESS_TOKEN_URL = "https://aip.baidubce.com/oauth/2.0/token";
        private static final String TOKEN_JSON_PATH = "$.usage.total_tokens";

        protected Parser() {
        }

        protected AIParseInfo parseInfo(OkHttpClient client, String ak, String sk, String url, String jsonBody) {
            Headers headers = new Headers.Builder().add("Content-Type", "application/json").build();
            String allUrl = url + "?access_token=" + this.getAccessToken(client, ak, sk);
            JSONObject response = HttpUtil.request(client, allUrl, headers, jsonBody);
            if (response.containsKey("error_msg")) {
                throw new RuntimeException(response.getString("error_msg"));
            }
            return new AIParseInfo(response.getString("id"), response.getString("result"), String.valueOf(response.getByPath(TOKEN_JSON_PATH)));
        }

        protected String getAccessToken(OkHttpClient client, String ak, String sk) {
            FormBody body;
            Headers headers = new Headers.Builder().add("Content-Type", "application/x-www-form-urlencoded").build();
            JSONObject response = HttpUtil.request(client, ACCESS_TOKEN_URL, headers, (RequestBody)(body = new FormBody.Builder().add("grant_type", "client_credentials").add("client_id", ak).add("client_secret", sk).build()));
            if (response.containsKey("error")) {
                throw new RuntimeException("ai request fail: " + response.getString("error_description"));
            }
            return response.getString("access_token");
        }
    }
}

