/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.parser.ai;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.awt.image.BufferedImage;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import okhttp3.Headers;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.enums.ImageType;
import org.dromara.pdf.pdfbox.core.ext.parser.ai.AIParseInfo;
import org.dromara.pdf.pdfbox.core.ext.parser.ai.AIParserConfig;
import org.dromara.pdf.pdfbox.core.ext.parser.ai.AbstractAIParser;
import org.dromara.pdf.pdfbox.util.HttpUtil;
import org.dromara.pdf.pdfbox.util.ImageUtil;

public class TencentAIParser
extends AbstractAIParser {
    public TencentAIParser(Document document, String ak, String sk, boolean isJsonResponse) {
        super(document, ak, sk, isJsonResponse);
        this.config.setImageModel("hunyuan-turbo-vision");
        this.config.setTextModel("hunyuan-turbo");
    }

    @Override
    public AIParseInfo parsePageWithImage(String prompt, int pageIndex) {
        return new ImageParser().parse(this.config, prompt, this.getPageImage(pageIndex));
    }

    @Override
    public AIParseInfo parseImageWithPage(String prompt, int pageIndex, int imageIndex) {
        return new ImageParser().parse(this.config, prompt, this.getPageImage(pageIndex, imageIndex));
    }

    @Override
    public AIParseInfo parseTextWithPage(String prompt, int beginPageIndex, int endPageIndex) {
        return new TextParser().parse(this.config, prompt, this.getPageText(beginPageIndex, endPageIndex));
    }

    protected static class Sign {
        protected Sign() {
        }

        public static String sign(String secretKey, String sigStr, String sigMethod) {
            Mac mac = Mac.getInstance(sigMethod);
            mac.init(new SecretKeySpec(secretKey.getBytes(StandardCharsets.UTF_8), mac.getAlgorithm()));
            byte[] hash = mac.doFinal(sigStr.getBytes(StandardCharsets.UTF_8));
            return DatatypeConverter.printBase64Binary((byte[])hash);
        }

        public static String sha256Hex(byte[] b) {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] d = md.digest(b);
            return DatatypeConverter.printHexBinary((byte[])d).toLowerCase();
        }

        public static byte[] hmac256(byte[] key, String msg) {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(key, mac.getAlgorithm()));
            return mac.doFinal(msg.getBytes(StandardCharsets.UTF_8));
        }
    }

    protected static class ImageUrl {
        protected String Url;

        public ImageUrl(String url) {
            this.Url = url;
        }

        @Generated
        public void setUrl(String Url) {
            this.Url = Url;
        }

        @Generated
        public String getUrl() {
            return this.Url;
        }
    }

    protected static class ImageContent {
        protected String Type = "image_url";
        protected ImageUrl ImageUrl;

        public ImageContent(String url) {
            this.ImageUrl = new ImageUrl(url);
        }

        @Generated
        public void setType(String Type2) {
            this.Type = Type2;
        }

        @Generated
        public void setImageUrl(ImageUrl ImageUrl2) {
            this.ImageUrl = ImageUrl2;
        }

        @Generated
        public String getType() {
            return this.Type;
        }

        @Generated
        public ImageUrl getImageUrl() {
            return this.ImageUrl;
        }
    }

    protected static class TextContent {
        protected String Type = "text";
        protected String Text;

        public TextContent(String text) {
            this.Text = text;
        }

        @Generated
        public void setType(String Type2) {
            this.Type = Type2;
        }

        @Generated
        public void setText(String Text2) {
            this.Text = Text2;
        }

        @Generated
        public String getType() {
            return this.Type;
        }

        @Generated
        public String getText() {
            return this.Text;
        }
    }

    protected static class Message {
        protected String Role;
        protected String Content;
        protected Object Contents;

        public Message(String role, String content) {
            this.Role = role;
            this.Content = content;
        }

        public Message(String role, Object contents) {
            this.Role = role;
            this.Contents = contents;
        }

        @Generated
        public void setRole(String Role) {
            this.Role = Role;
        }

        @Generated
        public void setContent(String Content) {
            this.Content = Content;
        }

        @Generated
        public void setContents(Object Contents) {
            this.Contents = Contents;
        }

        @Generated
        public String getRole() {
            return this.Role;
        }

        @Generated
        public String getContent() {
            return this.Content;
        }

        @Generated
        public Object getContents() {
            return this.Contents;
        }
    }

    protected static class TextParser
    extends Parser {
        protected TextParser() {
        }

        public AIParseInfo parse(AIParserConfig config, String prompt, String text) {
            return this.parseInfo(config, config.getTextModel(), this.createMessages(config.getTextSystemPrompt(), prompt, text));
        }

        protected List<Message> createMessages(String systemPrompt, String prompt, String text) {
            ArrayList<Message> messages = new ArrayList<Message>(3);
            if (Objects.nonNull(systemPrompt)) {
                messages.add(new Message("system", systemPrompt));
            }
            messages.add(new Message("user", text));
            messages.add(new Message("user", prompt));
            return messages;
        }
    }

    protected static class ImageParser
    extends Parser {
        protected ImageParser() {
        }

        public AIParseInfo parse(AIParserConfig config, String prompt, BufferedImage image) {
            return this.parseInfo(config, config.getImageModel(), this.createMessages(config.getImageSystemPrompt(), prompt, image));
        }

        protected List<Message> createMessages(String systemPrompt, String prompt, BufferedImage image) {
            ArrayList<Message> messages = new ArrayList<Message>(2);
            if (Objects.nonNull(systemPrompt)) {
                messages.add(new Message("system", systemPrompt));
            }
            messages.add(new Message("user", this.createMessageContents(prompt, image)));
            return messages;
        }

        protected List<Object> createMessageContents(String prompt, BufferedImage image) {
            ArrayList<Object> contents = new ArrayList<Object>(2);
            contents.add(new ImageContent("data:image/png;base64," + ImageUtil.toBase64(image, ImageType.PNG.getType())));
            contents.add(new TextContent(prompt));
            return contents;
        }
    }

    protected static class Parser {
        private static final String ENDPOINT = "hunyuan.tencentcloudapi.com";
        private static final String SERVICE = "hunyuan";
        private static final String VERSION = "2023-09-01";
        private static final String ACTION = "ChatCompletions";
        private static final String URL = "https://hunyuan.tencentcloudapi.com";
        private static final String CONTENT_JSON_PATH = "$.Choices[0].Message.Content";
        private static final String TOKEN_JSON_PATH = "$.Usage.TotalTokens";

        protected Parser() {
        }

        protected AIParseInfo parseInfo(AIParserConfig config, String model, List<Message> messages) {
            String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
            String body = JSONObject.of((String)"Model", (Object)model).fluentPut("Messages", messages).toString(new JSONWriter.Feature[]{JSONWriter.Feature.FieldBased});
            Headers headers = new Headers.Builder().add("Authorization", this.getAuthorization(timestamp, config.getAk(), config.getSk(), body.getBytes(StandardCharsets.UTF_8))).add("X-TC-Action", ACTION).add("X-TC-Version", VERSION).add("X-TC-Timestamp", timestamp).build();
            JSONObject response = HttpUtil.request(config.getClient(), URL, headers, body).getJSONObject("Response");
            if (response.containsKey("ErrorMsg")) {
                throw new RuntimeException(response.getByPath("$.ErrorMsg.Msg").toString());
            }
            return new AIParseInfo(response.getString("Id"), String.valueOf(response.getByPath(CONTENT_JSON_PATH)), String.valueOf(response.getByPath(TOKEN_JSON_PATH)));
        }

        protected String getAuthorization(String timestamp, String ak, String sk, byte[] body) {
            String contentType = "application/json; charset=utf-8";
            String canonicalUri = "/";
            String canonicalQueryString = "";
            String canonicalHeaders = "content-type:" + contentType + "\nhost:" + ENDPOINT + "\n";
            String signedHeaders = "content-type;host";
            String hashedRequestPayload = Sign.sha256Hex(body);
            String canonicalRequest = "POST\n" + canonicalUri + "\n" + canonicalQueryString + "\n" + canonicalHeaders + "\n" + signedHeaders + "\n" + hashedRequestPayload;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String date = sdf.format(new Date(Long.parseLong(timestamp + "000")));
            String credentialScope = date + "/" + SERVICE + "/tc3_request";
            String hashedCanonicalRequest = Sign.sha256Hex(canonicalRequest.getBytes(StandardCharsets.UTF_8));
            String stringToSign = "TC3-HMAC-SHA256\n" + timestamp + "\n" + credentialScope + "\n" + hashedCanonicalRequest;
            byte[] secretDate = Sign.hmac256(("TC3" + sk).getBytes(StandardCharsets.UTF_8), date);
            byte[] secretService = Sign.hmac256(secretDate, SERVICE);
            byte[] secretSigning = Sign.hmac256(secretService, "tc3_request");
            String signature = DatatypeConverter.printHexBinary((byte[])Sign.hmac256(secretSigning, stringToSign)).toLowerCase();
            return "TC3-HMAC-SHA256 Credential=" + ak + "/" + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
        }
    }
}

