/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.ext.processor.AbstractProcessor;
import org.dromara.pdf.pdfbox.core.ext.processor.MetadataProcessor;
import org.dromara.pdf.pdfbox.util.FileUtil;

public class SplitProcessor
extends AbstractProcessor {
    public SplitProcessor(Document document) {
        super(document);
    }

    public void split(String outputPath, int ... pageIndexes) {
        Objects.requireNonNull(outputPath, "the output path can not be null");
        Objects.requireNonNull(pageIndexes, "the page indexes can not be null");
        try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(FileUtil.createDirectories(Paths.get(outputPath, new String[0])), new OpenOption[0]));){
            this.split((OutputStream)outputStream, pageIndexes);
        }
    }

    public void split(OutputStream outputStream, int ... pageIndexes) {
        Objects.requireNonNull(outputStream, "the output stream can not be null");
        Objects.requireNonNull(pageIndexes, "the page indexes can not be null");
        this.split(outputStream, this.toIntegerList(pageIndexes));
    }

    public void split(OutputStream outputStream, List<Integer> pageIndexes) {
        Objects.requireNonNull(outputStream, "the output stream can not be null");
        Objects.requireNonNull(pageIndexes, "the page indexes can not be null");
        PDDocument target = new PDDocument();
        PDPageTree sourcePages = this.getDocument().getPages();
        for (int index : pageIndexes) {
            PDPage pdPage = sourcePages.get(index);
            PDPage importPage = target.importPage(pdPage);
            importPage.setResources(pdPage.getResources());
        }
        this.saveTarget(target, outputStream);
    }

    public void splitAll(String directory) {
        Objects.requireNonNull(directory, "the directory can not be null");
        int index = 1;
        PDPageTree pageTree = this.getDocument().getPages();
        for (PDPage sourcePage : pageTree) {
            PDDocument target = new PDDocument();
            PDPage importPage = target.importPage(sourcePage);
            importPage.setResources(sourcePage.getResources());
            StringBuilder fileNameBuilder = new StringBuilder();
            fileNameBuilder.append(directory).append(File.separator).append("x-easypdf-split").append(index).append(".pdf");
            try (BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(FileUtil.createDirectories(Paths.get(fileNameBuilder.toString(), new String[0])), new OpenOption[0]));){
                this.saveTarget(target, outputStream);
            }
            ++index;
        }
    }

    protected void saveTarget(PDDocument target, OutputStream outputStream) {
        if (Optional.ofNullable(this.document.getIsFlushMetadata()).orElse(Boolean.TRUE).booleanValue()) {
            new MetadataProcessor(this.document).flush();
        }
        target.setVersion(this.document.getVersion().floatValue());
        target.getDocumentCatalog().setMetadata(this.getDocument().getDocumentCatalog().getMetadata());
        target.save(outputStream, new CompressParameters(Integer.MAX_VALUE));
        target.close();
    }

    protected List<Integer> toIntegerList(int[] array) {
        return Arrays.stream(array).boxed().collect(Collectors.toList());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SplitProcessor)) {
            return false;
        }
        SplitProcessor other = (SplitProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SplitProcessor;
    }

    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

