/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor.form;

import java.awt.Color;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDTextField;
import org.dromara.pdf.pdfbox.core.base.Document;
import org.dromara.pdf.pdfbox.core.base.Page;
import org.dromara.pdf.pdfbox.core.base.Size;
import org.dromara.pdf.pdfbox.core.enums.HorizontalAlignment;
import org.dromara.pdf.pdfbox.core.ext.processor.form.AbstractFormFieldBuilder;
import org.dromara.pdf.pdfbox.support.Constants;
import org.dromara.pdf.pdfbox.util.ColorUtil;

public class TextFieldBuilder
extends AbstractFormFieldBuilder {
    protected static final String DEFAULT_APPEARANCE_FORMATTER = "/%s %d Tf %s";
    protected String fontName;
    protected Float fontSize;
    protected Color fontColor;
    protected Boolean isMultiline;
    protected Boolean isPassword;
    protected Boolean isFileSelect;
    protected Boolean isDoNotSpellCheck;
    protected Boolean isDoNotScroll;
    protected Boolean isCombination;
    protected Boolean isRichText;
    protected String richTextValue;
    protected Integer maxLength;
    protected String defaultValue;

    private TextFieldBuilder(Document document, Page page, Size size) {
        super(document, page, size);
    }

    public static TextFieldBuilder builder(Document document, Page page, Size size) {
        return new TextFieldBuilder(document, page, size);
    }

    @Override
    public PDField build(PDAcroForm form) {
        PDTextField field = new PDTextField(form);
        this.initProperties(field);
        this.initSize((PDField)field);
        this.initAppearance(field);
        return field;
    }

    protected void initProperties(PDTextField field) {
        super.initProperties((PDField)field);
        Optional.ofNullable(this.alignment).map(HorizontalAlignment::getAlignment).ifPresent(arg_0 -> ((PDTextField)field).setQ(arg_0));
        Optional.ofNullable(this.isMultiline).ifPresent(arg_0 -> ((PDTextField)field).setMultiline(arg_0));
        Optional.ofNullable(this.isPassword).ifPresent(arg_0 -> ((PDTextField)field).setPassword(arg_0));
        Optional.ofNullable(this.isFileSelect).ifPresent(arg_0 -> ((PDTextField)field).setFileSelect(arg_0));
        Optional.ofNullable(this.isDoNotSpellCheck).ifPresent(arg_0 -> ((PDTextField)field).setDoNotSpellCheck(arg_0));
        Optional.ofNullable(this.isDoNotScroll).ifPresent(arg_0 -> ((PDTextField)field).setDoNotScroll(arg_0));
        Optional.ofNullable(this.isCombination).ifPresent(arg_0 -> ((PDTextField)field).setComb(arg_0));
        Optional.ofNullable(this.isRichText).ifPresent(arg_0 -> ((PDTextField)field).setRichText(arg_0));
        Optional.ofNullable(this.richTextValue).ifPresent(arg_0 -> ((PDTextField)field).setRichTextValue(arg_0));
        Optional.ofNullable(this.maxLength).ifPresent(arg_0 -> ((PDTextField)field).setMaxLen(arg_0));
        Optional.ofNullable(this.defaultValue).ifPresent(arg_0 -> ((PDTextField)field).setDefaultValue(arg_0));
    }

    protected void initAppearance(PDTextField field) {
        String fontName = Optional.ofNullable(this.fontName).map(this.document.getContext()::getFont).orElse(this.document.getFont()).getName();
        Float fontSize = Optional.ofNullable(this.fontSize).orElse(Constants.DEFAULT_FONT_SIZE);
        Color fontColor = Optional.ofNullable(this.fontColor).orElse(Constants.DEFAULT_FONT_COLOR);
        String appearance = String.format(DEFAULT_APPEARANCE_FORMATTER, fontName, fontSize.intValue(), ColorUtil.toPDColorString(fontColor));
        field.setDefaultAppearance(appearance);
    }

    @Generated
    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    @Generated
    public void setFontSize(Float fontSize) {
        this.fontSize = fontSize;
    }

    @Generated
    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    @Generated
    public void setIsMultiline(Boolean isMultiline) {
        this.isMultiline = isMultiline;
    }

    @Generated
    public void setIsPassword(Boolean isPassword) {
        this.isPassword = isPassword;
    }

    @Generated
    public void setIsFileSelect(Boolean isFileSelect) {
        this.isFileSelect = isFileSelect;
    }

    @Generated
    public void setIsDoNotSpellCheck(Boolean isDoNotSpellCheck) {
        this.isDoNotSpellCheck = isDoNotSpellCheck;
    }

    @Generated
    public void setIsDoNotScroll(Boolean isDoNotScroll) {
        this.isDoNotScroll = isDoNotScroll;
    }

    @Generated
    public void setIsCombination(Boolean isCombination) {
        this.isCombination = isCombination;
    }

    @Generated
    public void setIsRichText(Boolean isRichText) {
        this.isRichText = isRichText;
    }

    @Generated
    public void setRichTextValue(String richTextValue) {
        this.richTextValue = richTextValue;
    }

    @Generated
    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    @Generated
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TextFieldBuilder)) {
            return false;
        }
        TextFieldBuilder other = (TextFieldBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Float this$fontSize = this.fontSize;
        Float other$fontSize = other.fontSize;
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Boolean this$isMultiline = this.isMultiline;
        Boolean other$isMultiline = other.isMultiline;
        if (this$isMultiline == null ? other$isMultiline != null : !((Object)this$isMultiline).equals(other$isMultiline)) {
            return false;
        }
        Boolean this$isPassword = this.isPassword;
        Boolean other$isPassword = other.isPassword;
        if (this$isPassword == null ? other$isPassword != null : !((Object)this$isPassword).equals(other$isPassword)) {
            return false;
        }
        Boolean this$isFileSelect = this.isFileSelect;
        Boolean other$isFileSelect = other.isFileSelect;
        if (this$isFileSelect == null ? other$isFileSelect != null : !((Object)this$isFileSelect).equals(other$isFileSelect)) {
            return false;
        }
        Boolean this$isDoNotSpellCheck = this.isDoNotSpellCheck;
        Boolean other$isDoNotSpellCheck = other.isDoNotSpellCheck;
        if (this$isDoNotSpellCheck == null ? other$isDoNotSpellCheck != null : !((Object)this$isDoNotSpellCheck).equals(other$isDoNotSpellCheck)) {
            return false;
        }
        Boolean this$isDoNotScroll = this.isDoNotScroll;
        Boolean other$isDoNotScroll = other.isDoNotScroll;
        if (this$isDoNotScroll == null ? other$isDoNotScroll != null : !((Object)this$isDoNotScroll).equals(other$isDoNotScroll)) {
            return false;
        }
        Boolean this$isCombination = this.isCombination;
        Boolean other$isCombination = other.isCombination;
        if (this$isCombination == null ? other$isCombination != null : !((Object)this$isCombination).equals(other$isCombination)) {
            return false;
        }
        Boolean this$isRichText = this.isRichText;
        Boolean other$isRichText = other.isRichText;
        if (this$isRichText == null ? other$isRichText != null : !((Object)this$isRichText).equals(other$isRichText)) {
            return false;
        }
        Integer this$maxLength = this.maxLength;
        Integer other$maxLength = other.maxLength;
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        String this$fontName = this.fontName;
        String other$fontName = other.fontName;
        if (this$fontName == null ? other$fontName != null : !this$fontName.equals(other$fontName)) {
            return false;
        }
        Color this$fontColor = this.fontColor;
        Color other$fontColor = other.fontColor;
        if (this$fontColor == null ? other$fontColor != null : !((Object)this$fontColor).equals(other$fontColor)) {
            return false;
        }
        String this$richTextValue = this.richTextValue;
        String other$richTextValue = other.richTextValue;
        if (this$richTextValue == null ? other$richTextValue != null : !this$richTextValue.equals(other$richTextValue)) {
            return false;
        }
        String this$defaultValue = this.defaultValue;
        String other$defaultValue = other.defaultValue;
        return !(this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TextFieldBuilder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Float $fontSize = this.fontSize;
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Boolean $isMultiline = this.isMultiline;
        result = result * 59 + ($isMultiline == null ? 43 : ((Object)$isMultiline).hashCode());
        Boolean $isPassword = this.isPassword;
        result = result * 59 + ($isPassword == null ? 43 : ((Object)$isPassword).hashCode());
        Boolean $isFileSelect = this.isFileSelect;
        result = result * 59 + ($isFileSelect == null ? 43 : ((Object)$isFileSelect).hashCode());
        Boolean $isDoNotSpellCheck = this.isDoNotSpellCheck;
        result = result * 59 + ($isDoNotSpellCheck == null ? 43 : ((Object)$isDoNotSpellCheck).hashCode());
        Boolean $isDoNotScroll = this.isDoNotScroll;
        result = result * 59 + ($isDoNotScroll == null ? 43 : ((Object)$isDoNotScroll).hashCode());
        Boolean $isCombination = this.isCombination;
        result = result * 59 + ($isCombination == null ? 43 : ((Object)$isCombination).hashCode());
        Boolean $isRichText = this.isRichText;
        result = result * 59 + ($isRichText == null ? 43 : ((Object)$isRichText).hashCode());
        Integer $maxLength = this.maxLength;
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        String $fontName = this.fontName;
        result = result * 59 + ($fontName == null ? 43 : $fontName.hashCode());
        Color $fontColor = this.fontColor;
        result = result * 59 + ($fontColor == null ? 43 : ((Object)$fontColor).hashCode());
        String $richTextValue = this.richTextValue;
        result = result * 59 + ($richTextValue == null ? 43 : $richTextValue.hashCode());
        String $defaultValue = this.defaultValue;
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        return result;
    }
}

