/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.core.ext.processor.sign;

import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureOptions;
import org.dromara.pdf.pdfbox.core.ext.processor.sign.SignPermission;
import org.dromara.pdf.pdfbox.core.ext.processor.sign.VisualOptions;

public class SignOptions {
    private Integer pageIndex;
    private PrivateKey key;
    private Certificate[] certificates;
    private String algorithm;
    private Integer preferredSignatureSize;
    private SignPermission permission;
    private VisualOptions visualOptions;

    protected void init() {
        Objects.requireNonNull(this.pageIndex, "the page index can not be null");
        Objects.requireNonNull(this.key, "the key can not be null");
        Objects.requireNonNull(this.certificates, "the certificates can not be null");
        Objects.requireNonNull(this.algorithm, "the algorithm can not be null");
        if (Objects.isNull(this.preferredSignatureSize)) {
            this.preferredSignatureSize = 9472;
        }
        if (Objects.isNull((Object)this.permission)) {
            this.permission = SignPermission.NONE_LIMIT;
        }
    }

    protected SignatureOptions createOptions(PDDocument document, PDSignature signature) {
        SignatureOptions signatureOptions = new SignatureOptions();
        signatureOptions.setPage(this.pageIndex.intValue());
        signatureOptions.setPreferredSignatureSize(this.preferredSignatureSize.intValue());
        if (Objects.nonNull(this.visualOptions)) {
            this.visualOptions.initVisualOptions(document, signature, signatureOptions);
        }
        return signatureOptions;
    }

    @Generated
    SignOptions(Integer pageIndex, PrivateKey key, Certificate[] certificates, String algorithm, Integer preferredSignatureSize, SignPermission permission, VisualOptions visualOptions) {
        this.pageIndex = pageIndex;
        this.key = key;
        this.certificates = certificates;
        this.algorithm = algorithm;
        this.preferredSignatureSize = preferredSignatureSize;
        this.permission = permission;
        this.visualOptions = visualOptions;
    }

    @Generated
    public static SignOptionsBuilder builder() {
        return new SignOptionsBuilder();
    }

    @Generated
    public Integer getPageIndex() {
        return this.pageIndex;
    }

    @Generated
    public PrivateKey getKey() {
        return this.key;
    }

    @Generated
    public Certificate[] getCertificates() {
        return this.certificates;
    }

    @Generated
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Generated
    public Integer getPreferredSignatureSize() {
        return this.preferredSignatureSize;
    }

    @Generated
    public SignPermission getPermission() {
        return this.permission;
    }

    @Generated
    public VisualOptions getVisualOptions() {
        return this.visualOptions;
    }

    @Generated
    public void setPageIndex(Integer pageIndex) {
        this.pageIndex = pageIndex;
    }

    @Generated
    public void setKey(PrivateKey key) {
        this.key = key;
    }

    @Generated
    public void setCertificates(Certificate[] certificates) {
        this.certificates = certificates;
    }

    @Generated
    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    @Generated
    public void setPreferredSignatureSize(Integer preferredSignatureSize) {
        this.preferredSignatureSize = preferredSignatureSize;
    }

    @Generated
    public void setPermission(SignPermission permission) {
        this.permission = permission;
    }

    @Generated
    public void setVisualOptions(VisualOptions visualOptions) {
        this.visualOptions = visualOptions;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignOptions)) {
            return false;
        }
        SignOptions other = (SignOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageIndex = this.getPageIndex();
        Integer other$pageIndex = other.getPageIndex();
        if (this$pageIndex == null ? other$pageIndex != null : !((Object)this$pageIndex).equals(other$pageIndex)) {
            return false;
        }
        Integer this$preferredSignatureSize = this.getPreferredSignatureSize();
        Integer other$preferredSignatureSize = other.getPreferredSignatureSize();
        if (this$preferredSignatureSize == null ? other$preferredSignatureSize != null : !((Object)this$preferredSignatureSize).equals(other$preferredSignatureSize)) {
            return false;
        }
        PrivateKey this$key = this.getKey();
        PrivateKey other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCertificates(), other.getCertificates())) {
            return false;
        }
        String this$algorithm = this.getAlgorithm();
        String other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !this$algorithm.equals(other$algorithm)) {
            return false;
        }
        SignPermission this$permission = this.getPermission();
        SignPermission other$permission = other.getPermission();
        if (this$permission == null ? other$permission != null : !((Object)((Object)this$permission)).equals((Object)other$permission)) {
            return false;
        }
        VisualOptions this$visualOptions = this.getVisualOptions();
        VisualOptions other$visualOptions = other.getVisualOptions();
        return !(this$visualOptions == null ? other$visualOptions != null : !((Object)this$visualOptions).equals(other$visualOptions));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SignOptions;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageIndex = this.getPageIndex();
        result = result * 59 + ($pageIndex == null ? 43 : ((Object)$pageIndex).hashCode());
        Integer $preferredSignatureSize = this.getPreferredSignatureSize();
        result = result * 59 + ($preferredSignatureSize == null ? 43 : ((Object)$preferredSignatureSize).hashCode());
        PrivateKey $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCertificates());
        String $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : $algorithm.hashCode());
        SignPermission $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : ((Object)((Object)$permission)).hashCode());
        VisualOptions $visualOptions = this.getVisualOptions();
        result = result * 59 + ($visualOptions == null ? 43 : ((Object)$visualOptions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SignOptions(pageIndex=" + this.getPageIndex() + ", key=" + this.getKey() + ", certificates=" + Arrays.deepToString(this.getCertificates()) + ", algorithm=" + this.getAlgorithm() + ", preferredSignatureSize=" + this.getPreferredSignatureSize() + ", permission=" + (Object)((Object)this.getPermission()) + ", visualOptions=" + this.getVisualOptions() + ")";
    }

    @Generated
    public static class SignOptionsBuilder {
        @Generated
        private Integer pageIndex;
        @Generated
        private PrivateKey key;
        @Generated
        private Certificate[] certificates;
        @Generated
        private String algorithm;
        @Generated
        private Integer preferredSignatureSize;
        @Generated
        private SignPermission permission;
        @Generated
        private VisualOptions visualOptions;

        @Generated
        SignOptionsBuilder() {
        }

        @Generated
        public SignOptionsBuilder pageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
            return this;
        }

        @Generated
        public SignOptionsBuilder key(PrivateKey key) {
            this.key = key;
            return this;
        }

        @Generated
        public SignOptionsBuilder certificates(Certificate[] certificates) {
            this.certificates = certificates;
            return this;
        }

        @Generated
        public SignOptionsBuilder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Generated
        public SignOptionsBuilder preferredSignatureSize(Integer preferredSignatureSize) {
            this.preferredSignatureSize = preferredSignatureSize;
            return this;
        }

        @Generated
        public SignOptionsBuilder permission(SignPermission permission) {
            this.permission = permission;
            return this;
        }

        @Generated
        public SignOptionsBuilder visualOptions(VisualOptions visualOptions) {
            this.visualOptions = visualOptions;
            return this;
        }

        @Generated
        public SignOptions build() {
            return new SignOptions(this.pageIndex, this.key, this.certificates, this.algorithm, this.preferredSignatureSize, this.permission, this.visualOptions);
        }

        @Generated
        public String toString() {
            return "SignOptions.SignOptionsBuilder(pageIndex=" + this.pageIndex + ", key=" + this.key + ", certificates=" + Arrays.deepToString(this.certificates) + ", algorithm=" + this.algorithm + ", preferredSignatureSize=" + this.preferredSignatureSize + ", permission=" + (Object)((Object)this.permission) + ", visualOptions=" + this.visualOptions + ")";
        }
    }
}

