/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.fonts;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.ttf.OpenTypeFont;
import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.fontbox.type1.Type1Font;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.pdmodel.font.CIDFontMapping;
import org.apache.pdfbox.pdmodel.font.FontCache;
import org.apache.pdfbox.pdmodel.font.FontFormat;
import org.apache.pdfbox.pdmodel.font.FontMapper;
import org.apache.pdfbox.pdmodel.font.FontMappers;
import org.apache.pdfbox.pdmodel.font.FontMapping;
import org.apache.pdfbox.pdmodel.font.PDCIDSystemInfo;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDPanoseClassification;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.dromara.pdf.pdfbox.support.fonts.FileSystemFontProvider;
import org.dromara.pdf.pdfbox.support.fonts.FontInfo;
import org.dromara.pdf.pdfbox.support.fonts.FontProvider;

public class FontMapperImpl
implements FontMapper {
    private static final Log LOG = LogFactory.getLog(FontMapperImpl.class);
    private static final FontCache fontCache = new FontCache();
    private FontProvider fontProvider;
    private Map<String, FontInfo> fontInfoByName;
    private final TrueTypeFont lastResortFont;
    private final Map<String, List<String>> substitutes = new HashMap<String, List<String>>();
    private static final FontMapperImpl INSTANCE = new FontMapperImpl();

    private FontMapperImpl() {
        this.substitutes.put("Courier", new ArrayList<String>(Arrays.asList("CourierNew", "CourierNewPSMT", "LiberationMono", "NimbusMonL-Regu")));
        this.substitutes.put("Courier-Bold", new ArrayList<String>(Arrays.asList("CourierNewPS-BoldMT", "CourierNew-Bold", "LiberationMono-Bold", "NimbusMonL-Bold")));
        this.substitutes.put("Courier-Oblique", new ArrayList<String>(Arrays.asList("CourierNewPS-ItalicMT", "CourierNew-Italic", "LiberationMono-Italic", "NimbusMonL-ReguObli")));
        this.substitutes.put("Courier-BoldOblique", new ArrayList<String>(Arrays.asList("CourierNewPS-BoldItalicMT", "CourierNew-BoldItalic", "LiberationMono-BoldItalic", "NimbusMonL-BoldObli")));
        this.substitutes.put("Helvetica", new ArrayList<String>(Arrays.asList("ArialMT", "Arial", "LiberationSans", "NimbusSanL-Regu")));
        this.substitutes.put("Helvetica-Bold", new ArrayList<String>(Arrays.asList("Arial-BoldMT", "Arial-Bold", "LiberationSans-Bold", "NimbusSanL-Bold")));
        this.substitutes.put("Helvetica-Oblique", new ArrayList<String>(Arrays.asList("Arial-ItalicMT", "Arial-Italic", "Helvetica-Italic", "LiberationSans-Italic", "NimbusSanL-ReguItal")));
        this.substitutes.put("Helvetica-BoldOblique", new ArrayList<String>(Arrays.asList("Arial-BoldItalicMT", "Helvetica-BoldItalic", "LiberationSans-BoldItalic", "NimbusSanL-BoldItal")));
        this.substitutes.put("Times-Roman", new ArrayList<String>(Arrays.asList("TimesNewRomanPSMT", "TimesNewRoman", "TimesNewRomanPS", "LiberationSerif", "NimbusRomNo9L-Regu")));
        this.substitutes.put("Times-Bold", new ArrayList<String>(Arrays.asList("TimesNewRomanPS-BoldMT", "TimesNewRomanPS-Bold", "TimesNewRoman-Bold", "LiberationSerif-Bold", "NimbusRomNo9L-Medi")));
        this.substitutes.put("Times-Italic", new ArrayList<String>(Arrays.asList("TimesNewRomanPS-ItalicMT", "TimesNewRomanPS-Italic", "TimesNewRoman-Italic", "LiberationSerif-Italic", "NimbusRomNo9L-ReguItal")));
        this.substitutes.put("Times-BoldItalic", new ArrayList<String>(Arrays.asList("TimesNewRomanPS-BoldItalicMT", "TimesNewRomanPS-BoldItalic", "TimesNewRoman-BoldItalic", "LiberationSerif-BoldItalic", "NimbusRomNo9L-MediItal")));
        this.substitutes.put("Symbol", new ArrayList<String>(Arrays.asList("Symbol", "SymbolMT", "StandardSymL")));
        this.substitutes.put("ZapfDingbats", new ArrayList<String>(Arrays.asList("ZapfDingbatsITCbyBT-Regular", "ZapfDingbatsITC", "Dingbats", "MS-Gothic")));
        for (String baseName : Standard14Fonts.getNames()) {
            this.substitutes.computeIfAbsent(baseName, key -> {
                Standard14Fonts.FontName mappedName = Standard14Fonts.getMappedFontName((String)key);
                return new ArrayList(this.substitutes.get(mappedName.getName()));
            });
        }
        String resourceName = "org/dromara/pdf/pdfbox/ttf/HarmonyOS_Sans_SC_Regular.ttf";
        InputStream resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        if (resourceAsStream == null) {
            throw new IOException("resource '" + resourceName + "' not found");
        }
        TTFParser ttfParser = new TTFParser();
        this.lastResortFont = ttfParser.parse((RandomAccessRead)new RandomAccessReadBuffer((InputStream)new BufferedInputStream(resourceAsStream)));
        FontMappers.set((FontMapper)this);
    }

    public static FontMapperImpl getInstance() {
        return INSTANCE;
    }

    public synchronized void setProvider(FontProvider fontProvider) {
        this.fontInfoByName = this.createFontInfoByName(fontProvider.getFontInfo());
        this.fontProvider = fontProvider;
    }

    public synchronized FontProvider getProvider() {
        if (this.fontProvider == null) {
            this.setProvider(DefaultFontProvider.INSTANCE);
        }
        return this.fontProvider;
    }

    public FontCache getFontCache() {
        return fontCache;
    }

    public Map<String, FontInfo> getFontInfoByName() {
        return this.fontInfoByName;
    }

    public void resetFontInfoByName() {
        List<? extends FontInfo> list = this.fontProvider.getFontInfo();
        if (!list.isEmpty()) {
            ArrayList<FontInfo> tempList = new ArrayList<FontInfo>(1);
            tempList.add(list.get(list.size() - 1));
            this.fontInfoByName.putAll(this.createFontInfoByName(tempList));
        }
    }

    private Map<String, FontInfo> createFontInfoByName(List<? extends FontInfo> fontInfoList) {
        LinkedHashMap<String, FontInfo> map = new LinkedHashMap<String, FontInfo>();
        for (FontInfo fontInfo : fontInfoList) {
            for (String name : this.getPostScriptNames(fontInfo.getPostScriptName())) {
                map.put(name, fontInfo);
            }
            map.put(fontInfo.getFontName(), fontInfo);
        }
        return map;
    }

    private Set<String> getPostScriptNames(String postScriptName) {
        HashSet<String> names = new HashSet<String>(2);
        names.add(postScriptName);
        names.add(postScriptName.replace("-", ""));
        return names;
    }

    public void addSubstitute(String match, String replace) {
        this.substitutes.computeIfAbsent(match, key -> new ArrayList()).add(replace);
    }

    private List<String> getSubstitutes(String postScriptName) {
        List<String> subs = this.substitutes.get(postScriptName.replace(" ", ""));
        if (subs != null) {
            return subs;
        }
        return Collections.emptyList();
    }

    private String getFallbackFontName(PDFontDescriptor fontDescriptor) {
        String fontName;
        if (fontDescriptor != null) {
            boolean isBold = false;
            String name = fontDescriptor.getFontName();
            if (name != null) {
                String lower = fontDescriptor.getFontName().toLowerCase();
                boolean bl = isBold = lower.contains("bold") || lower.contains("black") || lower.contains("heavy");
            }
            if (fontDescriptor.isFixedPitch()) {
                fontName = "Courier";
                if (isBold && fontDescriptor.isItalic()) {
                    fontName = fontName + "-BoldOblique";
                } else if (isBold) {
                    fontName = fontName + "-Bold";
                } else if (fontDescriptor.isItalic()) {
                    fontName = fontName + "-Oblique";
                }
            } else if (fontDescriptor.isSerif()) {
                fontName = "Times";
                fontName = isBold && fontDescriptor.isItalic() ? fontName + "-BoldItalic" : (isBold ? fontName + "-Bold" : (fontDescriptor.isItalic() ? fontName + "-Italic" : fontName + "-Roman"));
            } else {
                fontName = "Helvetica";
                if (isBold && fontDescriptor.isItalic()) {
                    fontName = fontName + "-BoldOblique";
                } else if (isBold) {
                    fontName = fontName + "-Bold";
                } else if (fontDescriptor.isItalic()) {
                    fontName = fontName + "-Oblique";
                }
            }
        } else {
            fontName = "HarmonyOS Sans SC";
        }
        return fontName;
    }

    public FontMapping<TrueTypeFont> getTrueTypeFont(String baseFont, PDFontDescriptor fontDescriptor) {
        TrueTypeFont ttf = (TrueTypeFont)this.findFont(FontFormat.TTF, baseFont);
        if (ttf == null) {
            ttf = (TrueTypeFont)this.findFont(FontFormat.OTF, baseFont);
        }
        if (ttf == null) {
            ttf = (TrueTypeFont)this.findFont(FontFormat.PFB, baseFont);
        }
        if (ttf != null) {
            return new FontMapping((FontBoxFont)ttf, false);
        }
        String fontName = this.getFallbackFontName(fontDescriptor);
        ttf = (TrueTypeFont)this.findFont(FontFormat.TTF, fontName);
        if (ttf == null) {
            ttf = this.lastResortFont;
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn((Object)("the font ['" + baseFont + "'] can not be found, will be used default font ['" + fontName + "']"));
        }
        return new FontMapping((FontBoxFont)ttf, true);
    }

    public FontMapping<FontBoxFont> getFontBoxFont(String baseFont, PDFontDescriptor fontDescriptor) {
        FontBoxFont font = this.findFontBoxFont(baseFont);
        if (font != null) {
            return new FontMapping(font, false);
        }
        String fallbackName = this.getFallbackFontName(fontDescriptor);
        font = this.findFontBoxFont(fallbackName);
        if (font == null) {
            font = this.lastResortFont;
        }
        return new FontMapping(font, true);
    }

    private FontBoxFont findFontBoxFont(String postScriptName) {
        TrueTypeFont ttf = (TrueTypeFont)this.findFont(FontFormat.TTF, postScriptName);
        if (ttf != null) {
            return ttf;
        }
        OpenTypeFont otf = (OpenTypeFont)this.findFont(FontFormat.OTF, postScriptName);
        if (otf != null) {
            return otf;
        }
        Type1Font t1 = (Type1Font)this.findFont(FontFormat.PFB, postScriptName);
        if (t1 != null) {
            return t1;
        }
        return null;
    }

    private FontBoxFont findFont(FontFormat format, String postScriptName) {
        FontInfo info;
        if (postScriptName == null) {
            return null;
        }
        if (this.fontProvider == null) {
            this.getProvider();
        }
        if ((info = this.getFont(format, postScriptName)) != null) {
            return info.getFont();
        }
        info = this.getFont(format, postScriptName.replace("-", ""));
        if (info != null) {
            return info.getFont();
        }
        for (String substituteName : this.getSubstitutes(postScriptName)) {
            info = this.getFont(format, substituteName);
            if (info == null) continue;
            return info.getFont();
        }
        info = this.getFont(format, postScriptName.replace(",", "-"));
        if (info != null) {
            return info.getFont();
        }
        info = this.getFont(format, postScriptName + "-Regular");
        if (info != null) {
            return info.getFont();
        }
        return null;
    }

    private FontInfo getFont(FontFormat format, String postScriptName) {
        if (postScriptName.contains("+")) {
            postScriptName = postScriptName.substring(postScriptName.indexOf(43) + 1);
        }
        return this.fontInfoByName.get(postScriptName);
    }

    public CIDFontMapping getCIDFont(String baseFont, PDFontDescriptor fontDescriptor, PDCIDSystemInfo cidSystemInfo) {
        PriorityQueue<FontMatch> queue;
        FontMatch bestMatch;
        String collection;
        try {
            TrueTypeFont ttf = (TrueTypeFont)this.findFont(FontFormat.TTF, baseFont);
            if (ttf != null) {
                return new CIDFontMapping(null, (FontBoxFont)ttf, false);
            }
        }
        catch (Exception ttf) {
            // empty catch block
        }
        try {
            OpenTypeFont otf1 = (OpenTypeFont)this.findFont(FontFormat.OTF, baseFont);
            if (otf1 != null) {
                return new CIDFontMapping(otf1, null, false);
            }
        }
        catch (Exception otf1) {
            // empty catch block
        }
        if (cidSystemInfo != null && ((collection = cidSystemInfo.getRegistry() + "-" + cidSystemInfo.getOrdering()).equals("Adobe-GB1") || collection.equals("Adobe-CNS1") || collection.equals("Adobe-Japan1") || collection.equals("Adobe-Korea1")) && (bestMatch = (queue = this.getFontMatches(fontDescriptor, cidSystemInfo)).poll()) != null) {
            FontBoxFont font = bestMatch.info.getFont();
            if (font instanceof OpenTypeFont) {
                return new CIDFontMapping((OpenTypeFont)font, null, true);
            }
            if (font != null) {
                return new CIDFontMapping(null, font, true);
            }
        }
        return new CIDFontMapping(null, (FontBoxFont)this.lastResortFont, true);
    }

    private PriorityQueue<FontMatch> getFontMatches(PDFontDescriptor fontDescriptor, PDCIDSystemInfo cidSystemInfo) {
        PriorityQueue<FontMatch> queue = new PriorityQueue<FontMatch>(20);
        for (FontInfo info : this.fontInfoByName.values()) {
            if (cidSystemInfo != null && !this.isCharSetMatch(cidSystemInfo, info)) continue;
            FontMatch match = new FontMatch(info);
            if (fontDescriptor.getPanose() != null && info.getPanose() != null) {
                PDPanoseClassification panose = fontDescriptor.getPanose().getPanose();
                if (panose.getFamilyKind() == info.getPanose().getFamilyKind()) {
                    if (panose.getFamilyKind() == 0 && (info.getPostScriptName().toLowerCase().contains("barcode") || info.getPostScriptName().startsWith("Code")) && !this.probablyBarcodeFont(fontDescriptor)) continue;
                    if (panose.getSerifStyle() == info.getPanose().getSerifStyle()) {
                        match.score += 2.0;
                    } else if (panose.getSerifStyle() >= 2 && panose.getSerifStyle() <= 5 && info.getPanose().getSerifStyle() >= 2 && info.getPanose().getSerifStyle() <= 5) {
                        match.score += 1.0;
                    } else if (panose.getSerifStyle() >= 11 && panose.getSerifStyle() <= 13 && info.getPanose().getSerifStyle() >= 11 && info.getPanose().getSerifStyle() <= 13) {
                        match.score += 1.0;
                    } else if (panose.getSerifStyle() != 0 && info.getPanose().getSerifStyle() != 0) {
                        match.score -= 1.0;
                    }
                    int weight = info.getPanose().getWeight();
                    int weightClass = info.getWeightClassAsPanose();
                    if (Math.abs(weight - weightClass) > 2) {
                        weight = weightClass;
                    }
                    if (panose.getWeight() == weight) {
                        match.score += 2.0;
                    } else if (panose.getWeight() > 1 && weight > 1) {
                        float dist = Math.abs(panose.getWeight() - weight);
                        match.score += 1.0 - (double)dist * 0.5;
                    }
                }
            } else if (fontDescriptor.getFontWeight() > 0.0f && info.getWeightClass() > 0) {
                float dist = Math.abs(fontDescriptor.getFontWeight() - (float)info.getWeightClass());
                match.score += 1.0 - (double)(dist / 100.0f) * 0.5;
            }
            queue.add(match);
        }
        return queue;
    }

    private boolean probablyBarcodeFont(PDFontDescriptor fontDescriptor) {
        String fn;
        String ff = fontDescriptor.getFontFamily();
        if (ff == null) {
            ff = "";
        }
        if ((fn = fontDescriptor.getFontName()) == null) {
            fn = "";
        }
        return ff.startsWith("Code") || ff.toLowerCase().contains("barcode") || fn.startsWith("Code") || fn.toLowerCase().contains("barcode");
    }

    private boolean isCharSetMatch(PDCIDSystemInfo cidSystemInfo, FontInfo info) {
        if (info.getCIDSystemInfo() != null) {
            return info.getCIDSystemInfo().getRegistry().equals(cidSystemInfo.getRegistry()) && info.getCIDSystemInfo().getOrdering().equals(cidSystemInfo.getOrdering());
        }
        long codePageRange = info.getCodePageRange();
        long JIS_JAPAN = 131072L;
        long CHINESE_SIMPLIFIED = 262144L;
        long KOREAN_WANSUNG = 524288L;
        long CHINESE_TRADITIONAL = 0x100000L;
        long KOREAN_JOHAB = 0x200000L;
        if ("MalgunGothic-Semilight".equals(info.getPostScriptName())) {
            codePageRange &= (JIS_JAPAN | CHINESE_SIMPLIFIED | CHINESE_TRADITIONAL) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        if (cidSystemInfo.getOrdering().equals("GB1") && (codePageRange & CHINESE_SIMPLIFIED) == CHINESE_SIMPLIFIED) {
            return true;
        }
        if (cidSystemInfo.getOrdering().equals("CNS1") && (codePageRange & CHINESE_TRADITIONAL) == CHINESE_TRADITIONAL) {
            return true;
        }
        if (cidSystemInfo.getOrdering().equals("Japan1") && (codePageRange & JIS_JAPAN) == JIS_JAPAN) {
            return true;
        }
        return cidSystemInfo.getOrdering().equals("Korea1") && ((codePageRange & KOREAN_WANSUNG) == KOREAN_WANSUNG || (codePageRange & KOREAN_JOHAB) == KOREAN_JOHAB);
    }

    static /* synthetic */ FontCache access$000() {
        return fontCache;
    }

    private static class FontMatch
    implements Comparable<FontMatch> {
        double score;
        final FontInfo info;

        FontMatch(FontInfo info) {
            this.info = info;
        }

        @Override
        public int compareTo(FontMatch match) {
            return Double.compare(match.score, this.score);
        }
    }

    private static class DefaultFontProvider {
        private static final FileSystemFontProvider INSTANCE = new FileSystemFontProvider(FontMapperImpl.access$000());

        private DefaultFontProvider() {
        }
    }
}

