/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.linearizer;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.dromara.pdf.pdfbox.support.linearizer.BidirectionalMultiMap;
import org.dromara.pdf.pdfbox.support.linearizer.ObjUser;

class PreLinearizationOptimizer {
    private static final Log LOG = LogFactory.getLog(PreLinearizationOptimizer.class);
    private final COSDocument document;
    BidirectionalMultiMap<ObjUser, COSBase> userObjectMap;
    private boolean pushed_inherited_attributes_to_pages = false;

    PreLinearizationOptimizer(COSDocument document) {
        this.document = document;
        this.userObjectMap = new BidirectionalMultiMap();
    }

    private List<COSObject> pushInheritedAttributesToPage(List<COSObject> pages, boolean allow_changes, boolean warn_skipped_keys) {
        HashMap<COSName, COSBase> key_ancestors = new HashMap<COSName, COSBase>();
        HashSet<COSBase> visited = new HashSet<COSBase>();
        COSDictionary trailer = this.document.getTrailer();
        COSObject root_obj = (COSObject)trailer.getItem(COSName.ROOT);
        COSDictionary root = (COSDictionary)root_obj.getObject();
        COSObject pages_obj = (COSObject)root.getItem(COSName.PAGES);
        this.pushInheritedAttributesToPageInternal(pages_obj, key_ancestors, pages, allow_changes, warn_skipped_keys, visited);
        if (!key_ancestors.isEmpty()) {
            LOG.info((Object)"key_ancestors not empty after pushing inherited attributes to pages");
        }
        this.pushed_inherited_attributes_to_pages = true;
        return pages;
    }

    private void pushInheritedAttributesToPageInternal(COSObject cur_pages_obj, HashMap<COSName, COSBase> key_ancestors, List<COSObject> pages, boolean allow_changes, boolean warn_skipped_keys, Set<COSBase> visited) {
        COSDictionary cur_pages = (COSDictionary)cur_pages_obj.getObject();
        if (visited.contains(cur_pages)) {
            LOG.info((Object)"Loop detected in /Pages structure (inherited attributes)");
        }
        visited.add((COSBase)cur_pages);
        COSName type = (COSName)cur_pages.getItem(COSName.TYPE);
        if (type == COSName.PAGES) {
            HashSet<COSName> inheritable_keys = new HashSet<COSName>();
            Set keys = cur_pages.keySet();
            for (COSName key2 : keys) {
                if (key2 == COSName.MEDIA_BOX || key2 == COSName.CROP_BOX || key2 == COSName.RESOURCES || key2 == COSName.ROTATE) {
                    if (!allow_changes) {
                        LOG.info((Object)"optimize detected an inheritable attribute when called in no-change mode");
                    }
                    inheritable_keys.add(key2);
                    COSBase oh = cur_pages.getItem(key2);
                    key_ancestors.put(key2, oh);
                    cur_pages.removeItem(key2);
                    continue;
                }
                if (key2 == COSName.TYPE || key2 == COSName.PARENT || key2 == COSName.KIDS || key2 == COSName.COUNT || !warn_skipped_keys || !cur_pages.containsKey(COSName.PARENT)) continue;
                LOG.info((Object)"unknown key not inherited");
                LOG.info((Object)("Unknown key " + key2 + " in /Pages object is being discarded as a result of flattening the /Pages tree"));
            }
            COSArray kids = (COSArray)cur_pages.getItem(COSName.KIDS);
            for (COSBase kid : kids) {
                this.pushInheritedAttributesToPageInternal((COSObject)kid, key_ancestors, pages, allow_changes, warn_skipped_keys, visited);
            }
            for (COSName key3 : inheritable_keys) {
                key_ancestors.remove(key3);
            }
        } else if (type == COSName.PAGE) {
            key_ancestors.forEach((key, object) -> {
                if (!cur_pages.containsKey(key)) {
                    cur_pages.setItem(key, object);
                }
            });
            pages.add(cur_pages_obj);
        } else {
            LOG.info((Object)"Invalid type in page tree!");
        }
        visited.remove(cur_pages);
    }

    BidirectionalMultiMap<ObjUser, COSBase> optimize(List<COSObject> pages) throws IOException {
        if (!this.userObjectMap.isT1Empty()) {
            return this.userObjectMap;
        }
        this.pushInheritedAttributesToPage(pages, true, false);
        COSObject root = (COSObject)this.document.getTrailer().getItem(COSName.ROOT);
        int pageno = 0;
        for (COSBase cOSBase : pages) {
            this.updateObjectMaps(new ObjUser(ObjUser.user_e.ou_page, pageno++), cOSBase);
        }
        this.document.getTrailer().keySet().forEach(key -> {
            if (key != COSName.ROOT) {
                this.updateObjectMaps(new ObjUser(ObjUser.user_e.ou_trailer_key, (COSName)key), this.document.getTrailer().getItem(key));
            }
        });
        ((COSDictionary)root.getObject()).keySet().forEach(key -> this.updateObjectMaps(new ObjUser(ObjUser.user_e.ou_root_key, (COSName)key), ((COSDictionary)root.getObject()).getItem(key)));
        this.userObjectMap.addValuePair(new ObjUser(ObjUser.user_e.ou_root), (COSBase)root);
        return this.userObjectMap;
    }

    private void updateObjectMaps(ObjUser ou, COSBase treeObj) {
        HashSet<COSBase> visited = new HashSet<COSBase>();
        this.updateObjectMapsInternal(ou, visited, treeObj, true);
    }

    private void updateObjectMapsInternal(ObjUser ou, Set<COSBase> visited, COSBase treeObjIn, boolean top) {
        block11: {
            COSBase treeObj;
            boolean is_page_node;
            block10: {
                COSName type;
                if (visited.contains(treeObjIn)) {
                    return;
                }
                is_page_node = false;
                treeObj = treeObjIn;
                if (treeObj instanceof COSObject && ((COSObject)treeObj).getObject() == null) {
                    treeObj.setDirect(false);
                } else {
                    treeObj.setDirect(true);
                }
                if (treeObjIn instanceof COSObject) {
                    treeObj = ((COSObject)treeObjIn).getObject();
                }
                if (treeObj instanceof COSDictionary && ((COSDictionary)treeObj).containsKey(COSName.TYPE) && (type = (COSName)((COSDictionary)treeObj).getItem(COSName.TYPE)) == COSName.PAGE) {
                    is_page_node = true;
                    if (!top) {
                        return;
                    }
                }
                if (treeObjIn instanceof COSObject) {
                    this.userObjectMap.addValuePair(ou, treeObjIn);
                    visited.add(treeObjIn);
                }
                if (!(treeObj instanceof COSArray)) break block10;
                visited.add(treeObjIn);
                for (COSBase item : (COSArray)treeObj) {
                    this.updateObjectMapsInternal(ou, visited, item, false);
                }
                break block11;
            }
            if (!(treeObj instanceof COSDictionary) && !(treeObj instanceof COSStream)) break block11;
            visited.add(treeObjIn);
            for (COSName key : ((COSDictionary)treeObj).keySet()) {
                if (is_page_node && key == COSName.THUMB) {
                    this.updateObjectMaps(new ObjUser(ObjUser.user_e.ou_thumb, ou.pageno), ((COSDictionary)treeObj).getItem(key));
                    continue;
                }
                if (is_page_node && key == COSName.PARENT) continue;
                COSBase child = ((COSDictionary)treeObj).getItem(key);
                this.updateObjectMapsInternal(ou, visited, child, false);
            }
        }
    }
}

