/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.support.linearizer;

import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSString;

public class SimplifiedPDFDocument
extends COSDocument
implements Closeable {
    private static final long DUMMY_MAX_VALUE_LONG = 1111111111111111111L;
    private static final int DUMMY_MAX_VALUE_INT = 1111111111;
    private final COSDocument wrappedDocument;
    private int pageCount = 0;

    public SimplifiedPDFDocument(COSDocument doc) throws IOException {
        this.wrappedDocument = doc;
        this.integrateDocument(doc);
        this.setVersion(Math.max(doc.getVersion(), 1.6f));
    }

    private static COSObject createPagesObjekt() throws IOException {
        COSDictionary pagesDict = new COSDictionary();
        pagesDict.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        pagesDict.setInt(COSName.COUNT, 1111111111);
        pagesDict.setItem(COSName.KIDS, (COSBase)new COSArray());
        return new COSObject((COSBase)pagesDict, new COSObjectKey(1111111111111111112L, 0));
    }

    private static List<COSObject> getKids(COSObject node) {
        ArrayList<COSObject> result = new ArrayList<COSObject>();
        COSBase base = node.getObject();
        COSArray kids = base instanceof COSDictionary ? ((COSDictionary)base).getCOSArray(COSName.KIDS) : null;
        if (kids == null) {
            return result;
        }
        int size = kids.size();
        for (int i = 0; i < size; ++i) {
            result.add((COSObject)kids.get(i));
        }
        return result;
    }

    private static boolean isPageTreeNode(COSObject node) {
        COSDictionary dict = (COSDictionary)node.getObject();
        return dict.getCOSName(COSName.TYPE) == COSName.PAGES || dict.containsKey(COSName.KIDS);
    }

    public int getPageCount() {
        return this.pageCount;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.wrappedDocument.close();
    }

    private int integrateDocument(COSDocument doc) throws IOException {
        if (this.getTrailer() == null) {
            this.setTrailer(this.createDocumentTrailer());
        }
        COSDictionary root = this.getTrailer().getCOSDictionary(COSName.ROOT);
        COSDictionary pages = root.getCOSDictionary(COSName.PAGES);
        COSArray pagesKids = pages.getCOSArray(COSName.KIDS);
        int pagesCount = 0;
        COSDictionary docRoot = doc.getTrailer().getCOSDictionary(COSName.ROOT);
        COSDictionary docPages = docRoot.getCOSDictionary(COSName.PAGES);
        COSArray docPageArray = docPages.getCOSArray(COSName.KIDS);
        for (COSBase page : docPageArray) {
            ((COSDictionary)((COSObject)page).getObject()).setItem(COSName.PARENT, (COSBase)pages);
            pagesKids.add(page);
            ++pagesCount;
        }
        pages.setInt(COSName.COUNT, pagesKids.size());
        this.pageCount += pagesCount;
        return pagesCount;
    }

    private COSObject createDocumentRoot() throws IOException {
        COSDictionary rootDict = new COSDictionary();
        rootDict.setDirect(true);
        rootDict.setItem(COSName.TYPE, (COSBase)COSName.CATALOG);
        rootDict.setItem(COSName.PAGES, (COSBase)SimplifiedPDFDocument.createPagesObjekt());
        return new COSObject((COSBase)rootDict, new COSObjectKey(1111111111111111111L, 0));
    }

    private COSDictionary createDocumentTrailer() throws IOException {
        COSDictionary trailerDict = new COSDictionary();
        trailerDict.setDirect(true);
        trailerDict.setInt(COSName.SIZE, 1111111111);
        trailerDict.setItem(COSName.ROOT, (COSBase)this.createDocumentRoot());
        this.addIDToTrailer(trailerDict);
        return trailerDict;
    }

    void addIDToTrailer(COSDictionary trailer) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md5.update((System.currentTimeMillis() + "PDF_BOX_SALT_STRING" + this.hashCode()).getBytes(StandardCharsets.ISO_8859_1));
        COSDictionary info = (COSDictionary)trailer.getDictionaryObject(COSName.INFO);
        if (info != null) {
            info.getValues().forEach(cosBase -> md5.update(cosBase.toString().getBytes(StandardCharsets.ISO_8859_1)));
        }
        COSString firstID = new COSString(md5.digest());
        COSArray idArray = new COSArray();
        idArray.add((COSBase)firstID);
        trailer.setItem(COSName.ID, (COSBase)idArray);
    }
}

