/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.pdfbox.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class FileUtil {
    public static Path createDirectories(Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Path directoryPath = !Files.isDirectory(path, new LinkOption[0]) ? path.getParent() : path;
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("the path is illegal and create directory fail");
            }
        }
        return path;
    }

    public static String parseSuffix(File file) {
        Objects.requireNonNull(file, "the file can not be null");
        String name = file.getName();
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            throw new IllegalArgumentException("the file suffix can not supported: " + name);
        }
        return name.substring(dot + 1).toLowerCase();
    }
}

