/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.dynamic.datasource.aop.DynamicDataSourceAnnotationAdvisor;
import com.baomidou.dynamic.datasource.creator.DefaultDataSourceCreator;
import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.baomidou.dynamic.datasource.processor.DsProcessor;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DynamicDataSourceProperties;
import com.baomidou.mybatisplus.autoconfigure.SpringBootVFS;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.incrementer.IKeyGenerator;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.extension.incrementer.H2KeyGenerator;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.database.config.MybatisPlusMetaObjectHandler;
import com.bringspring.common.database.model.DataSourceModel;
import com.bringspring.common.database.model.DbTableModel;
import com.bringspring.common.database.plugins.DynamicGeneratorInterceptor;
import com.bringspring.common.database.plugins.MyMasterSlaveAutoRoutingPlugin;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.source.impl.DbOracle;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.database.util.JdbcUtil;
import com.github.pagehelper.PageInterceptor;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.aopalliance.intercept.MethodInterceptor;
import org.apache.ibatis.logging.slf4j.Slf4jImpl;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Advisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

@Configuration
@ComponentScan(value={"com.bringspring"})
@MapperScan(basePackages={"com.bringspring.**.mapper"})
public class MybatisPlusConfig {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusConfig.class);
    static final String ALIASES_PACKAGE = "com.bringspring.**.entity";
    @Autowired
    private DataSourceModel dataSourceModel;
    @Autowired
    private ConfigValueUtil configValueUtil;

    @Primary
    @Bean(name={"dataSourceSystem"})
    public DataSource dataSourceOne(DynamicDataSourceProperties properties, DefaultDataSourceCreator dataSourceCreator) throws Exception {
        return this.dynamicDataSource(properties, dataSourceCreator);
    }

    @Bean(name={"sqlSessionFactorySystem"})
    public SqlSessionFactory sqlSessionFactoryOne(@Qualifier(value="dataSourceSystem") DataSource dataSource) throws Exception {
        return this.createSqlSessionFactory(dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        try {
            DbBase dbBase = DbTypeUtil.getDb(this.dataSourceModel);
            if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
                DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor = new DynamicTableNameInnerInterceptor();
                HashMap map = new HashMap(150);
                Connection conn = ConnUtil.getConn(this.dataSourceModel);
                try {
                    ArrayList<String> tableNames = new ArrayList<String>();
                    if (conn != null) {
                        JdbcUtil.queryCustomMods(dbBase.getSqlBase().getTableListPSD(conn, this.dataSourceModel), DbTableModel.class).forEach(dbTableModel -> tableNames.add(dbTableModel.getTable().toLowerCase()));
                    }
                    DbBase.dynamicAllTableName = tableNames;
                    dynamicTableNameInnerInterceptor.setTableNameHandler(dbBase.getDynamicTableNameHandler());
                    interceptor.addInnerInterceptor((InnerInterceptor)dynamicTableNameInnerInterceptor);
                }
                finally {
                    if (Collections.singletonList(conn).get(0) != null) {
                        conn.close();
                    }
                }
            }
            interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return interceptor;
    }

    protected DataSource dynamicDataSource(DynamicDataSourceProperties properties, DefaultDataSourceCreator dataSourceCreator) throws Exception {
        String url;
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            url = ConnUtil.getUrl(this.dataSourceModel, "jsbos_protect");
            try {
                ConnUtil.getConn(this.dataSourceModel.getUserName(), this.dataSourceModel.getPassword(), url).close();
            }
            catch (Exception e) {
                throw new Exception("JSBOS_PROTECT\u5e93\u5f02\u5e38\u6216\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u521b\u5efa\u591a\u79df\u6237\u521d\u59cb\u4fdd\u62a4\u5e93JSBOS_PROTECT\u5e93\uff1a" + e.getMessage());
            }
        }
        url = ConnUtil.getUrl(this.dataSourceModel);
        DataSourceProperty dataSourceProperty = new DataSourceProperty();
        dataSourceProperty.setUsername(this.dataSourceModel.getUserName());
        dataSourceProperty.setPassword(this.dataSourceModel.getPassword());
        dataSourceProperty.setUrl(url);
        dataSourceProperty.setDriverClassName(DbTypeUtil.getDb(this.dataSourceModel).getDriver());
        DynamicRoutingDataSource dataSource = new DynamicRoutingDataSource();
        dataSource.setPrimary(properties.getPrimary());
        dataSource.setStrict(properties.getStrict());
        dataSource.setStrategy(properties.getStrategy());
        dataSource.setP6spy(properties.getP6spy());
        dataSource.setSeata(properties.getSeata());
        boolean hasPrimary = false;
        for (Map.Entry ds : properties.getDatasource().entrySet()) {
            if (!((String)ds.getKey()).equals(properties.getPrimary()) && !((String)ds.getKey()).startsWith(properties.getPrimary() + "_") && !properties.getPrimary().equals(((DataSourceProperty)ds.getValue()).getPoolName())) continue;
            hasPrimary = true;
            break;
        }
        if (!hasPrimary) {
            dataSource.addDataSource(properties.getPrimary(), dataSourceCreator.createDataSource(dataSourceProperty));
        }
        DataSource ds = dataSource.getDataSource(properties.getPrimary());
        if (DbTypeUtil.getDb(url).getClass() == DbOracle.class && ds instanceof ItemDataSource) {
            String logonUer = "Default";
            Properties connProp = DbOracle.setConnProp(logonUer, dataSourceProperty.getUsername(), dataSourceProperty.getPassword());
            ((DruidDataSource)((ItemDataSource)ds).getDataSource()).setConnectProperties(connProp);
        }
        return dataSource;
    }

    @Bean
    public Advisor myDynamicDatasourceGeneratorAdvisor(DsProcessor dsProcessor) {
        DynamicGeneratorInterceptor interceptor = new DynamicGeneratorInterceptor(true, dsProcessor);
        DynamicDataSourceAnnotationAdvisor advisor = new DynamicDataSourceAnnotationAdvisor((MethodInterceptor)interceptor, DS.class);
        return advisor;
    }

    protected DataSource druidDataSource() throws Exception {
        DbBase dbBase = DbTypeUtil.getDb(this.dataSourceModel);
        String userName = this.dataSourceModel.getUserName();
        String password = this.dataSourceModel.getPassword();
        String driver = dbBase.getDriver();
        String url = "";
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            url = ConnUtil.getUrl(this.dataSourceModel, "JSBOS_PROTECT");
            try {
                ConnUtil.getConn(userName, password, url).close();
            }
            catch (Exception e) {
                throw new Exception("JSBOS_PROTECT\u5e93\u5f02\u5e38\u6216\u4e0d\u5b58\u5728,\u8bf7\u91cd\u65b0\u521b\u5efa\u591a\u79df\u6237\u521d\u59cb\u4fdd\u62a4\u5e93JSBOS_PROTECT\u5e93\uff1a" + e.getMessage());
            }
        } else {
            url = ConnUtil.getUrl(this.dataSourceModel);
        }
        DruidDataSource dataSource = new DruidDataSource();
        if (dbBase.getClass() == DbOracle.class) {
            String logonUer = "SYSDBA";
            Properties properties = DbOracle.setConnProp(logonUer, userName, password);
            dataSource.setConnectProperties(properties);
        } else {
            dataSource.setUsername(userName);
            dataSource.setPassword(password);
        }
        dataSource.setUrl(url);
        dataSource.setDriverClassName(driver);
        return dataSource;
    }

    public Resource[] resolveMapperLocations() {
        PathMatchingResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
        ArrayList<String> mapperLocations = new ArrayList<String>();
        mapperLocations.add("classpath*:mapper/**.xml");
        mapperLocations.add("classpath*:mapper/*/*.xml");
        mapperLocations.add("classpath*:mapper/*/*/*.xml");
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String mapperLocation : mapperLocations) {
            try {
                Resource[] mappers = resourceResolver.getResources(mapperLocation);
                resources.addAll(Arrays.asList(mappers));
            }
            catch (IOException iOException) {}
        }
        return resources.toArray(new Resource[0]);
    }

    public SqlSessionFactory createSqlSessionFactory(DataSource dataSource) throws Exception {
        MybatisSqlSessionFactoryBean bean = new MybatisSqlSessionFactoryBean();
        bean.setDataSource(dataSource);
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setMetaObjectHandler((MetaObjectHandler)new MybatisPlusMetaObjectHandler());
        bean.setGlobalConfig(globalConfig);
        bean.setVfs(SpringBootVFS.class);
        bean.setTypeAliasesPackage(ALIASES_PACKAGE);
        bean.setMapperLocations(this.resolveMapperLocations());
        bean.setConfiguration(this.configuration(dataSource));
        bean.setPlugins(new Interceptor[]{this.pageHelper(), new MyMasterSlaveAutoRoutingPlugin(dataSource)});
        return bean.getObject();
    }

    public PageInterceptor pageHelper() {
        PageInterceptor pageHelper = new PageInterceptor();
        Properties properties = new Properties();
        properties.setProperty("dialectAlias", "kingbasees8=com.github.pagehelper.dialect.helper.MySqlDialect");
        properties.setProperty("autoRuntimeDialect", "true");
        properties.setProperty("offsetAsPageNum", "false");
        properties.setProperty("rowBoundsWithCount", "false");
        properties.setProperty("pageSizeZero", "true");
        properties.setProperty("reasonable", "false");
        properties.setProperty("supportMethodsArguments", "false");
        properties.setProperty("returnPageInfo", "none");
        pageHelper.setProperties(properties);
        return pageHelper;
    }

    public MybatisConfiguration configuration(DataSource dataSource) {
        MybatisConfiguration mybatisConfiguration = new MybatisConfiguration();
        mybatisConfiguration.setMapUnderscoreToCamelCase(false);
        mybatisConfiguration.setCacheEnabled(false);
        mybatisConfiguration.addInterceptor((Interceptor)this.mybatisPlusInterceptor());
        mybatisConfiguration.setLogImpl(Slf4jImpl.class);
        mybatisConfiguration.setJdbcTypeForNull(JdbcType.NULL);
        return mybatisConfiguration;
    }

    @Bean
    public IKeyGenerator keyGenerator() {
        return new H2KeyGenerator();
    }

    @Bean
    public ISqlInjector sqlInjector() {
        return (builderAssistant, mapperClass) -> {};
    }
}

