/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.enums.datatype;

import com.bringspring.common.database.enums.datatype.interfaces.DtInterface;
import com.bringspring.common.database.model.DataTypeModel;

public enum DtOracle implements DtInterface
{
    VARCHAR2("VARCHAR2", "varchar", 50, 4000),
    NVARCHAR2("NVARCHAR2", "varchar", 50, 2000),
    DATA("DATE", "datetime", false),
    CLOB("CLOB", "text", false),
    NUMBER_VIEW("NUMBER", "\u6570\u5b57\u7c7b\u578b", 11, 38, 0, 127),
    NUMBER_DECIMAL("NUMBER", "decimal", 11, 38, 0, 127),
    NUMBER_INT("NUMBER", "int", 11, 38, 0, 127),
    NUMBER_BIG("NUMBER", "bigint", 11, 38, 0, 127);

    private final String dbFieldType;
    private final Boolean lengthModifyFlag;
    private final String viewDataType;
    private final Integer defaultLength;
    private final Integer lengthMax;
    private final Integer defaultPrecision;
    private final Integer precisionMax;

    private DtOracle(String dbFieldType, String viewDataType, Integer defaultLength, Integer lengthMax, Integer defaultPrecision, Integer precisionMax) {
        this.dbFieldType = dbFieldType;
        this.lengthModifyFlag = true;
        this.viewDataType = viewDataType;
        this.defaultLength = defaultLength;
        this.lengthMax = lengthMax;
        this.defaultPrecision = defaultPrecision;
        this.precisionMax = precisionMax;
    }

    private DtOracle(String dbFieldType, String viewDataType, Integer defaultLength, Integer lengthMax) {
        this.dbFieldType = dbFieldType;
        this.lengthModifyFlag = true;
        this.viewDataType = viewDataType;
        this.defaultLength = defaultLength;
        this.lengthMax = lengthMax;
        this.defaultPrecision = null;
        this.precisionMax = null;
    }

    private DtOracle(String dbFieldType, String viewDataType, Boolean lengthModifyFlag) {
        this.dbFieldType = dbFieldType;
        this.lengthModifyFlag = lengthModifyFlag;
        this.viewDataType = viewDataType;
        this.defaultLength = null;
        this.lengthMax = null;
        this.defaultPrecision = null;
        this.precisionMax = null;
    }

    @Override
    public DataTypeModel getDataTypeModel() {
        return new DataTypeModel(this.dbFieldType, this.viewDataType, this.defaultLength, this.lengthMax, this.lengthModifyFlag, this.defaultPrecision, this.precisionMax);
    }

    @Override
    public String getDbFieldType() {
        return this.dbFieldType;
    }
}

