/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.model;

import java.sql.Connection;
import java.sql.DatabaseMetaData;

public class DbModel {
    private String catalog;
    private String jdbcDbType;
    private String version;
    private Integer majorVersion;
    private String url;

    public DbModel(Connection connection) {
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            this.catalog = connection.getCatalog();
            this.jdbcDbType = databaseMetaData.getDatabaseProductName();
            this.version = databaseMetaData.getDatabaseProductVersion();
            this.majorVersion = databaseMetaData.getDatabaseMajorVersion();
            this.url = databaseMetaData.getURL();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getJdbcDbType() {
        return this.jdbcDbType;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public String getUrl() {
        return this.url;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setJdbcDbType(String jdbcDbType) {
        this.jdbcDbType = jdbcDbType;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setMajorVersion(Integer majorVersion) {
        this.majorVersion = majorVersion;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbModel)) {
            return false;
        }
        DbModel other = (DbModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$majorVersion = this.getMajorVersion();
        Integer other$majorVersion = other.getMajorVersion();
        if (this$majorVersion == null ? other$majorVersion != null : !((Object)this$majorVersion).equals(other$majorVersion)) {
            return false;
        }
        String this$catalog = this.getCatalog();
        String other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$jdbcDbType = this.getJdbcDbType();
        String other$jdbcDbType = other.getJdbcDbType();
        if (this$jdbcDbType == null ? other$jdbcDbType != null : !this$jdbcDbType.equals(other$jdbcDbType)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DbModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $majorVersion = this.getMajorVersion();
        result = result * 59 + ($majorVersion == null ? 43 : ((Object)$majorVersion).hashCode());
        String $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $jdbcDbType = this.getJdbcDbType();
        result = result * 59 + ($jdbcDbType == null ? 43 : $jdbcDbType.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public String toString() {
        return "DbModel(catalog=" + this.getCatalog() + ", jdbcDbType=" + this.getJdbcDbType() + ", version=" + this.getVersion() + ", majorVersion=" + this.getMajorVersion() + ", url=" + this.getUrl() + ")";
    }
}

