/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.model;

import com.bringspring.common.database.enums.DbAliasEnum;
import com.bringspring.common.database.model.DataTypeModel;
import com.bringspring.common.database.model.dto.ModelDTO;
import com.bringspring.common.database.model.interfaces.JdbcGetMod;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.util.StringUtils;
import java.sql.ResultSet;

public class DbTableFieldModel
extends JdbcGetMod {
    private String field;
    private String defaults;
    private String identity;
    private String fieldName;
    private String fieldComment;
    private String description;
    private String dataType;
    private String columnType;
    private String dataLength;
    private Integer primaryKey;
    private Integer allowNull;

    @Override
    public void setMod(ModelDTO modelDTO) {
        try {
            String dataLength;
            String fieldComment;
            ResultSet result = modelDTO.getResultSet();
            DbBase db = modelDTO.getDbBase();
            DbTableFieldModel model = db.getPartFieldModel(result);
            String dbFieldType = result.getString(DbAliasEnum.getAsByDb(db, "DATATYPE"));
            String columnType = result.getString(DbAliasEnum.getAsByDb(db, "COLUMNTYPE"));
            DataTypeModel dataTypeModel = db.getDataTypeModel(dbFieldType);
            String dataType = dataTypeModel != null ? (model.getDataType() != null ? model.getDataType() : dataTypeModel.getViewDataType()) : dbFieldType;
            String fieldName = model.getField() != null ? model.getField() : result.getString(DbAliasEnum.getAsByDb(db, "FIELD_NAME"));
            String string = fieldComment = model.getFieldComment() != null ? model.getFieldComment() : result.getString(DbAliasEnum.getAsByDb(db, "FIELD_COMMENT"));
            if (dataTypeModel != null && !dataTypeModel.getLengthModifyFlag().booleanValue()) {
                dataLength = "\u9ed8\u8ba4";
            } else {
                String string2 = dataLength = model.getDataLength() != null ? model.getDataLength() : String.valueOf(result.getLong(DbAliasEnum.getAsByDb(db, "DATA_LENGTH")));
                if ("0".equals(dataLength) || StringUtils.isEmpty(dataLength) || "null".equals(dataLength)) {
                    dataLength = "\u9ed8\u8ba4";
                }
            }
            Integer primaryKey = model.getPrimaryKey() != null ? model.getPrimaryKey().intValue() : result.getInt(DbAliasEnum.PRIMARY_KEY.asByDb(db));
            Integer allowNull = model.getAllowNull() != null ? model.getAllowNull().intValue() : result.getInt(DbAliasEnum.ALLOW_NULL.asByDb(db));
            this.setField(fieldName).setFieldName(fieldComment).setDataType(dataType).setDescription(fieldName + "(" + fieldComment + ")").setDataLength(dataLength).setAllowNull(allowNull).setPrimaryKey(primaryKey);
            this.setColumnType(columnType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getField() {
        return this.field;
    }

    public String getDefaults() {
        return this.defaults;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getFieldComment() {
        return this.fieldComment;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public String getDataLength() {
        return this.dataLength;
    }

    public Integer getPrimaryKey() {
        return this.primaryKey;
    }

    public Integer getAllowNull() {
        return this.allowNull;
    }

    public DbTableFieldModel setField(String field) {
        this.field = field;
        return this;
    }

    public DbTableFieldModel setDefaults(String defaults) {
        this.defaults = defaults;
        return this;
    }

    public DbTableFieldModel setIdentity(String identity) {
        this.identity = identity;
        return this;
    }

    public DbTableFieldModel setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public DbTableFieldModel setFieldComment(String fieldComment) {
        this.fieldComment = fieldComment;
        return this;
    }

    public DbTableFieldModel setDescription(String description) {
        this.description = description;
        return this;
    }

    public DbTableFieldModel setDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }

    public DbTableFieldModel setColumnType(String columnType) {
        this.columnType = columnType;
        return this;
    }

    public DbTableFieldModel setDataLength(String dataLength) {
        this.dataLength = dataLength;
        return this;
    }

    public DbTableFieldModel setPrimaryKey(Integer primaryKey) {
        this.primaryKey = primaryKey;
        return this;
    }

    public DbTableFieldModel setAllowNull(Integer allowNull) {
        this.allowNull = allowNull;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbTableFieldModel)) {
            return false;
        }
        DbTableFieldModel other = (DbTableFieldModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$primaryKey = this.getPrimaryKey();
        Integer other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !((Object)this$primaryKey).equals(other$primaryKey)) {
            return false;
        }
        Integer this$allowNull = this.getAllowNull();
        Integer other$allowNull = other.getAllowNull();
        if (this$allowNull == null ? other$allowNull != null : !((Object)this$allowNull).equals(other$allowNull)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$defaults = this.getDefaults();
        String other$defaults = other.getDefaults();
        if (this$defaults == null ? other$defaults != null : !this$defaults.equals(other$defaults)) {
            return false;
        }
        String this$identity = this.getIdentity();
        String other$identity = other.getIdentity();
        if (this$identity == null ? other$identity != null : !this$identity.equals(other$identity)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$fieldComment = this.getFieldComment();
        String other$fieldComment = other.getFieldComment();
        if (this$fieldComment == null ? other$fieldComment != null : !this$fieldComment.equals(other$fieldComment)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$columnType = this.getColumnType();
        String other$columnType = other.getColumnType();
        if (this$columnType == null ? other$columnType != null : !this$columnType.equals(other$columnType)) {
            return false;
        }
        String this$dataLength = this.getDataLength();
        String other$dataLength = other.getDataLength();
        return !(this$dataLength == null ? other$dataLength != null : !this$dataLength.equals(other$dataLength));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DbTableFieldModel;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : ((Object)$primaryKey).hashCode());
        Integer $allowNull = this.getAllowNull();
        result = result * 59 + ($allowNull == null ? 43 : ((Object)$allowNull).hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $defaults = this.getDefaults();
        result = result * 59 + ($defaults == null ? 43 : $defaults.hashCode());
        String $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $fieldComment = this.getFieldComment();
        result = result * 59 + ($fieldComment == null ? 43 : $fieldComment.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $columnType = this.getColumnType();
        result = result * 59 + ($columnType == null ? 43 : $columnType.hashCode());
        String $dataLength = this.getDataLength();
        result = result * 59 + ($dataLength == null ? 43 : $dataLength.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "DbTableFieldModel(field=" + this.getField() + ", defaults=" + this.getDefaults() + ", identity=" + this.getIdentity() + ", fieldName=" + this.getFieldName() + ", fieldComment=" + this.getFieldComment() + ", description=" + this.getDescription() + ", dataType=" + this.getDataType() + ", columnType=" + this.getColumnType() + ", dataLength=" + this.getDataLength() + ", primaryKey=" + this.getPrimaryKey() + ", allowNull=" + this.getAllowNull() + ")";
    }
}

