/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.source;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.extension.plugins.handler.TableNameHandler;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.database.enums.ParamEnum;
import com.bringspring.common.database.enums.datatype.interfaces.DtInterface;
import com.bringspring.common.database.enums.datatype.viewshow.DataTypeEnum;
import com.bringspring.common.database.model.DataTypeModel;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.dto.DataSourceDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.source.impl.DbDM;
import com.bringspring.common.database.source.impl.DbKingbase;
import com.bringspring.common.database.source.impl.DbMySQL;
import com.bringspring.common.database.source.impl.DbOracle;
import com.bringspring.common.database.source.impl.DbPostgre;
import com.bringspring.common.database.source.impl.DbSQLServer;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class DbBase {
    public static final String MYSQL = "MySQL";
    public static final String DM = "DM8";
    public static final String KINGBASE_ES = "KingbaseES";
    public static final String ORACLE = "Oracle";
    public static final String POSTGRE_SQL = "PostgreSQL";
    public static final String SQL_SERVER = "SQLServer";
    public static final DbBase[] DB_BASES = new DbBase[]{new DbMySQL(), new DbSQLServer(), new DbDM(), new DbOracle(), new DbKingbase(), new DbPostgre()};
    public static final String[] DB_ENCODES = new String[]{"MySQL", "DM8", "KingbaseES", "Oracle", "PostgreSQL", "SQLServer"};
    protected String dbEncode;
    protected DbType mpDbType;
    protected String connUrlEncode;
    protected String driver;
    protected String defaultPort;
    protected String defaultPrepareUrl;
    protected SqlBase sqlBase;
    public String oracleParam;
    public static List<String> dynamicAllTableName = Collections.emptyList();

    protected DbBase() {
        this.init();
    }

    protected void init() {
    }

    protected void setInstance(String dbEncode, DbType mpDbType, String defaultPort, String connUrlEncode, String driver, String defaultPrepareUrl, SqlBase sqlBase) {
        this.dbEncode = dbEncode;
        this.mpDbType = mpDbType;
        this.connUrlEncode = connUrlEncode;
        this.sqlBase = sqlBase;
        this.driver = driver;
        this.defaultPrepareUrl = defaultPrepareUrl;
        this.defaultPort = defaultPort;
    }

    public String toString() {
        return "DbBase{dbEncode='" + this.dbEncode + '\'' + ", mpDbType=" + this.mpDbType + ", connUrlEncode='" + this.connUrlEncode + '\'' + ", driver='" + this.driver + '\'' + ", defaultPort='" + this.defaultPort + '\'' + ", defaultPrepareUrl='" + this.defaultPrepareUrl + '\'' + ", sqlBase=" + this.sqlBase + ", oracleParam='" + this.oracleParam + '\'' + '}';
    }

    public DataTypeModel getDataTypeModel(DataTypeEnum dte) throws DataException {
        try {
            String jsbosDbEncode = this.getDbEncode().equals(DM) ? "DM" : this.getDbEncode();
            Class<?> clz = Class.forName("com.bringspring.common.database.enums.datatype.viewshow.DataTypeEnum");
            Method method = clz.getMethod("getDt" + jsbosDbEncode, new Class[0]);
            DtInterface dt = (DtInterface)method.invoke((Object)dte, null);
            return dt.getDataTypeModel();
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    public DataTypeModel getDataTypeModel(String dbFieldType) throws Exception {
        DtInterface[] dataTypes;
        String jsbosDbEncode = this.getDbEncode().equals(DM) ? "DM" : this.getDbEncode();
        Class<?> clz = Class.forName("com.bringspring.common.database.enums.datatype.Dt" + jsbosDbEncode);
        Method method = clz.getMethod("values", new Class[0]);
        for (DtInterface dataType : dataTypes = (DtInterface[])method.invoke(null, null)) {
            if (!dbFieldType.equals(dataType.getDbFieldType())) continue;
            return dataType.getDataTypeModel();
        }
        return null;
    }

    public TableNameHandler getDynamicTableNameHandler() {
        return (sql, tableName) -> {
            boolean isAssignDataSource;
            boolean bl = isAssignDataSource = StringUtils.isNotEmpty(DataSourceContextHolder.getDatasourceName()) && "true".equals(DataSourceContextHolder.getDatasourceName());
            if (isAssignDataSource) {
                return tableName;
            }
            boolean hasDataSource = StringUtils.isNotEmpty(DataSourceContextHolder.getDatasourceName()) && dynamicAllTableName.contains(tableName.toLowerCase());
            return hasDataSource ? this.getDynamicTableName(tableName) : tableName;
        };
    }

    protected String getDynamicTableName(String tableName) {
        return DataSourceContextHolder.getDatasourceName() + "." + tableName;
    }

    public DbTableFieldModel getPartFieldModel(ResultSet result) throws Exception {
        return new DbTableFieldModel();
    }

    protected String getConnUrl(String prepareUrl, String host, Integer port, String dbName, String schema) {
        if (StringUtils.isEmpty(prepareUrl)) {
            prepareUrl = this.defaultPrepareUrl;
        }
        if (StringUtils.isNotEmpty(dbName)) {
            prepareUrl = prepareUrl.replace("{dbname}", dbName);
        }
        if (StringUtils.isNotEmpty(schema)) {
            prepareUrl = prepareUrl.replace("{schema}", schema);
        }
        if (StringUtils.isNotEmpty(host)) {
            prepareUrl = prepareUrl.replace("{host}", host);
        }
        if (port != null) {
            prepareUrl = prepareUrl.replace("{port}", port.toString());
        }
        return prepareUrl;
    }

    public LinkedList<Object> getStructParams(String structParams, String table, DataSourceMod dbSourceOrDbLink) {
        DataSourceDTO dto = dbSourceOrDbLink.convertDTO();
        LinkedList<Object> data = new LinkedList<Object>();
        for (String paramStr : structParams.split(":")) {
            if (paramStr.equals(ParamEnum.TABLE.getTarget())) {
                data.add(table);
                continue;
            }
            if (paramStr.equals(ParamEnum.DB_NAME.getTarget())) {
                String dbName = dto.getDbName();
                if (dbName == null) {
                    dbName = dto.getUserName();
                }
                data.add(dbName);
                continue;
            }
            if (paramStr.equals(ParamEnum.DB_SCHEMA.getTarget())) {
                data.add(dto.getDbSchema());
                continue;
            }
            if (!paramStr.equals(ParamEnum.TABLE_SPACE.getTarget())) continue;
            data.add(dto.getDbTableSpace());
        }
        return data;
    }

    public String getDbEncode() {
        return this.dbEncode;
    }

    public DbType getMpDbType() {
        return this.mpDbType;
    }

    public String getConnUrlEncode() {
        return this.connUrlEncode;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getDefaultPort() {
        return this.defaultPort;
    }

    public String getDefaultPrepareUrl() {
        return this.defaultPrepareUrl;
    }

    public SqlBase getSqlBase() {
        return this.sqlBase;
    }

    public String getOracleParam() {
        return this.oracleParam;
    }

    public void setDbEncode(String dbEncode) {
        this.dbEncode = dbEncode;
    }

    public void setMpDbType(DbType mpDbType) {
        this.mpDbType = mpDbType;
    }

    public void setConnUrlEncode(String connUrlEncode) {
        this.connUrlEncode = connUrlEncode;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setDefaultPort(String defaultPort) {
        this.defaultPort = defaultPort;
    }

    public void setDefaultPrepareUrl(String defaultPrepareUrl) {
        this.defaultPrepareUrl = defaultPrepareUrl;
    }

    public void setSqlBase(SqlBase sqlBase) {
        this.sqlBase = sqlBase;
    }

    public void setOracleParam(String oracleParam) {
        this.oracleParam = oracleParam;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbBase)) {
            return false;
        }
        DbBase other = (DbBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dbEncode = this.getDbEncode();
        String other$dbEncode = other.getDbEncode();
        if (this$dbEncode == null ? other$dbEncode != null : !this$dbEncode.equals(other$dbEncode)) {
            return false;
        }
        DbType this$mpDbType = this.getMpDbType();
        DbType other$mpDbType = other.getMpDbType();
        if (this$mpDbType == null ? other$mpDbType != null : !this$mpDbType.equals(other$mpDbType)) {
            return false;
        }
        String this$connUrlEncode = this.getConnUrlEncode();
        String other$connUrlEncode = other.getConnUrlEncode();
        if (this$connUrlEncode == null ? other$connUrlEncode != null : !this$connUrlEncode.equals(other$connUrlEncode)) {
            return false;
        }
        String this$driver = this.getDriver();
        String other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
            return false;
        }
        String this$defaultPort = this.getDefaultPort();
        String other$defaultPort = other.getDefaultPort();
        if (this$defaultPort == null ? other$defaultPort != null : !this$defaultPort.equals(other$defaultPort)) {
            return false;
        }
        String this$defaultPrepareUrl = this.getDefaultPrepareUrl();
        String other$defaultPrepareUrl = other.getDefaultPrepareUrl();
        if (this$defaultPrepareUrl == null ? other$defaultPrepareUrl != null : !this$defaultPrepareUrl.equals(other$defaultPrepareUrl)) {
            return false;
        }
        SqlBase this$sqlBase = this.getSqlBase();
        SqlBase other$sqlBase = other.getSqlBase();
        if (this$sqlBase == null ? other$sqlBase != null : !((Object)this$sqlBase).equals(other$sqlBase)) {
            return false;
        }
        String this$oracleParam = this.getOracleParam();
        String other$oracleParam = other.getOracleParam();
        return !(this$oracleParam == null ? other$oracleParam != null : !this$oracleParam.equals(other$oracleParam));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DbBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dbEncode = this.getDbEncode();
        result = result * 59 + ($dbEncode == null ? 43 : $dbEncode.hashCode());
        DbType $mpDbType = this.getMpDbType();
        result = result * 59 + ($mpDbType == null ? 43 : $mpDbType.hashCode());
        String $connUrlEncode = this.getConnUrlEncode();
        result = result * 59 + ($connUrlEncode == null ? 43 : $connUrlEncode.hashCode());
        String $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : $driver.hashCode());
        String $defaultPort = this.getDefaultPort();
        result = result * 59 + ($defaultPort == null ? 43 : $defaultPort.hashCode());
        String $defaultPrepareUrl = this.getDefaultPrepareUrl();
        result = result * 59 + ($defaultPrepareUrl == null ? 43 : $defaultPrepareUrl.hashCode());
        SqlBase $sqlBase = this.getSqlBase();
        result = result * 59 + ($sqlBase == null ? 43 : ((Object)$sqlBase).hashCode());
        String $oracleParam = this.getOracleParam();
        result = result * 59 + ($oracleParam == null ? 43 : $oracleParam.hashCode());
        return result;
    }

    public static class BaseCommon {
        public static String getDbBaseConnUrl(DbBase dbBase, String prepareUrl, String host, Integer port, String dbName, String schema) {
            return dbBase.getConnUrl(prepareUrl, host, port, dbName, schema);
        }
    }
}

