/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql;

import com.bringspring.common.database.model.DbFieldMod;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.dto.DataSourceDTO;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.append.create.CreateSql;
import com.bringspring.common.database.sql.append.create.CreateSqlDTO;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.exception.DataException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.util.HtmlUtils;

public abstract class SqlBase {
    protected String fieldListSql;
    protected String fieldListParams;
    protected String tableListSql;
    protected String tableListParams;
    protected String existsTableSql;
    protected String existsTableParams;
    protected String deleteSql = "DROP TABLE IF EXISTS ?;";
    public static final String INSERT_AUTHORIZE = "INSERT INTO base_authorize (ID, ITEM_TYPE, ITEM_ID, OBJECT_TYPE, OBJECT_ID, SORT_CODE, CREATOR_TIME, CREATOR_USER_ID ) VALUES  (?,?,?,?,?,?,?,?)";
    public static final String INSERT_AUTHORIZE2 = "INSERT INTO base_authorize (ID, ITEM_TYPE, ITEM_ID, OBJECT_TYPE, OBJECT_ID, SORT_CODE, CREATOR_TIME, CREATOR_USER_ID ) VALUES  (?,?,?,?,?,?,TO_DATE(?,'yyyy-mm-dd hh24:mi:ss'),?)";

    public String getDataSql(String table) {
        return "SELECT * FROM " + table;
    }

    public String getRenameSql(String oldTableName, String newTableName) {
        return "ALTER TABLE " + oldTableName + " RENAME TO " + newTableName + ";";
    }

    public static String getAuthorDelSql(List<String> objectIdAll) {
        return "DELETE FROM base_authorize WHERE (OBJECT_ID in( '" + String.join((CharSequence)",", objectIdAll) + "') AND ITEM_TYPE <> 'portal')";
    }

    public SqlBase() {
        this.init();
    }

    protected void setInstance(String fieldListSql, String tableListSql, String existsTableSql, String fieldListParams, String tableListParams, String existsTableParams) {
        this.fieldListSql = fieldListSql;
        this.tableListSql = tableListSql;
        this.existsTableSql = existsTableSql;
        this.fieldListParams = fieldListParams;
        this.tableListParams = tableListParams;
        this.existsTableParams = existsTableParams;
    }

    protected abstract void init();

    public PreparedStatementDTO getFieldListPSD(Connection conn, String table, DataSourceMod dbSourceOrDbLink) {
        DataSourceDTO dto = dbSourceOrDbLink.convertDTO();
        DbBase db = DbTypeUtil.getDb(conn);
        return new PreparedStatementDTO(conn, this.fieldListSql, db.getStructParams(this.fieldListParams, table, dto));
    }

    public PreparedStatementDTO getTableListPSD(Connection conn, DataSourceMod dbSourceOrDbLink) {
        DataSourceDTO dto = dbSourceOrDbLink.convertDTO();
        DbBase db = DbTypeUtil.getDb(conn);
        return new PreparedStatementDTO(conn, this.tableListSql, db.getStructParams(this.tableListParams, "", dto));
    }

    public PreparedStatementDTO getExistsTablePSD(Connection conn, String table, DataSourceMod dbSourceOrDbLink) {
        DataSourceDTO dto = dbSourceOrDbLink.convertDTO();
        DbBase db = DbTypeUtil.getDb(conn);
        return new PreparedStatementDTO(conn, this.existsTableSql, db.getStructParams(this.existsTableParams, table, dto));
    }

    public List<PreparedStatementDTO> getCreateTablePSD(String table, String tableComment, List<DbTableFieldModel> dbTableFieldModelList, DbBase dbBase) throws Exception {
        return CreateSql.getCreTabSql(new CreateSqlDTO(dbBase, table, tableComment, dbTableFieldModelList));
    }

    public PreparedStatementDTO getDeleteSqlPSD(Connection conn, String deleteTable) {
        deleteTable = HtmlUtils.htmlEscape((String)String.valueOf(deleteTable), (String)"UTF-8");
        return new PreparedStatementDTO(conn, "DROP TABLE IF EXISTS " + deleteTable + ";");
    }

    public PreparedStatementDTO getTableCommentPSD(CreateSqlDTO createSqlDTO) {
        String table = HtmlUtils.htmlEscape((String)String.valueOf(createSqlDTO.getNewTable()), (String)"UTF-8");
        String preparedSql = "COMMENT ON TABLE " + table + " is '" + createSqlDTO.getTableComment() + "'";
        return new PreparedStatementDTO(null, preparedSql);
    }

    public List<PreparedStatementDTO> getFieldCommentPSD(CreateSqlDTO createSqlDTO) {
        String table = HtmlUtils.htmlEscape((String)String.valueOf(createSqlDTO.getNewTable()), (String)"UTF-8");
        String prepareSql = "COMMENT ON COLUMN " + table + ".{column} is '{comment}'";
        ArrayList<PreparedStatementDTO> listPSD = new ArrayList<PreparedStatementDTO>();
        for (DbTableFieldModel fieldModel : createSqlDTO.getFieldModels()) {
            String preparedSql = prepareSql.replace("{column}", fieldModel.getField()).replace("{comment}", fieldModel.getFieldName());
            listPSD.add(new PreparedStatementDTO(null, preparedSql));
        }
        return listPSD;
    }

    public String batchInsertSql(List<List<DbFieldMod>> dataList, String table) throws DataException {
        return "";
    }

    public abstract String[] getPageSql(String var1, String var2, Integer var3, Integer var4) throws DataException;

    public String getFieldListSql() {
        return this.fieldListSql;
    }

    public String getFieldListParams() {
        return this.fieldListParams;
    }

    public String getTableListSql() {
        return this.tableListSql;
    }

    public String getTableListParams() {
        return this.tableListParams;
    }

    public String getExistsTableSql() {
        return this.existsTableSql;
    }

    public String getExistsTableParams() {
        return this.existsTableParams;
    }

    public String getDeleteSql() {
        return this.deleteSql;
    }

    public void setFieldListSql(String fieldListSql) {
        this.fieldListSql = fieldListSql;
    }

    public void setFieldListParams(String fieldListParams) {
        this.fieldListParams = fieldListParams;
    }

    public void setTableListSql(String tableListSql) {
        this.tableListSql = tableListSql;
    }

    public void setTableListParams(String tableListParams) {
        this.tableListParams = tableListParams;
    }

    public void setExistsTableSql(String existsTableSql) {
        this.existsTableSql = existsTableSql;
    }

    public void setExistsTableParams(String existsTableParams) {
        this.existsTableParams = existsTableParams;
    }

    public void setDeleteSql(String deleteSql) {
        this.deleteSql = deleteSql;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlBase)) {
            return false;
        }
        SqlBase other = (SqlBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fieldListSql = this.getFieldListSql();
        String other$fieldListSql = other.getFieldListSql();
        if (this$fieldListSql == null ? other$fieldListSql != null : !this$fieldListSql.equals(other$fieldListSql)) {
            return false;
        }
        String this$fieldListParams = this.getFieldListParams();
        String other$fieldListParams = other.getFieldListParams();
        if (this$fieldListParams == null ? other$fieldListParams != null : !this$fieldListParams.equals(other$fieldListParams)) {
            return false;
        }
        String this$tableListSql = this.getTableListSql();
        String other$tableListSql = other.getTableListSql();
        if (this$tableListSql == null ? other$tableListSql != null : !this$tableListSql.equals(other$tableListSql)) {
            return false;
        }
        String this$tableListParams = this.getTableListParams();
        String other$tableListParams = other.getTableListParams();
        if (this$tableListParams == null ? other$tableListParams != null : !this$tableListParams.equals(other$tableListParams)) {
            return false;
        }
        String this$existsTableSql = this.getExistsTableSql();
        String other$existsTableSql = other.getExistsTableSql();
        if (this$existsTableSql == null ? other$existsTableSql != null : !this$existsTableSql.equals(other$existsTableSql)) {
            return false;
        }
        String this$existsTableParams = this.getExistsTableParams();
        String other$existsTableParams = other.getExistsTableParams();
        if (this$existsTableParams == null ? other$existsTableParams != null : !this$existsTableParams.equals(other$existsTableParams)) {
            return false;
        }
        String this$deleteSql = this.getDeleteSql();
        String other$deleteSql = other.getDeleteSql();
        return !(this$deleteSql == null ? other$deleteSql != null : !this$deleteSql.equals(other$deleteSql));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqlBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fieldListSql = this.getFieldListSql();
        result = result * 59 + ($fieldListSql == null ? 43 : $fieldListSql.hashCode());
        String $fieldListParams = this.getFieldListParams();
        result = result * 59 + ($fieldListParams == null ? 43 : $fieldListParams.hashCode());
        String $tableListSql = this.getTableListSql();
        result = result * 59 + ($tableListSql == null ? 43 : $tableListSql.hashCode());
        String $tableListParams = this.getTableListParams();
        result = result * 59 + ($tableListParams == null ? 43 : $tableListParams.hashCode());
        String $existsTableSql = this.getExistsTableSql();
        result = result * 59 + ($existsTableSql == null ? 43 : $existsTableSql.hashCode());
        String $existsTableParams = this.getExistsTableParams();
        result = result * 59 + ($existsTableParams == null ? 43 : $existsTableParams.hashCode());
        String $deleteSql = this.getDeleteSql();
        result = result * 59 + ($deleteSql == null ? 43 : $deleteSql.hashCode());
        return result;
    }

    public String toString() {
        return "SqlBase(fieldListSql=" + this.getFieldListSql() + ", fieldListParams=" + this.getFieldListParams() + ", tableListSql=" + this.getTableListSql() + ", tableListParams=" + this.getTableListParams() + ", existsTableSql=" + this.getExistsTableSql() + ", existsTableParams=" + this.getExistsTableParams() + ", deleteSql=" + this.getDeleteSql() + ")";
    }
}

