/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.append.create;

import com.bringspring.common.database.enums.DbAliasEnum;
import com.bringspring.common.database.enums.datatype.viewshow.DataTypeEnum;
import com.bringspring.common.database.model.DataTypeModel;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.sql.append.create.CreateSqlDTO;
import com.bringspring.common.database.util.SqlUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.HtmlUtils;

public class CreateSql {
    private static final Logger log = LoggerFactory.getLogger(CreateSql.class);

    public static List<PreparedStatementDTO> getCreTabSql(CreateSqlDTO createSqlDTO) throws Exception {
        LinkedList<PreparedStatementDTO> PSDList = new LinkedList<PreparedStatementDTO>();
        PSDList.add(CreateSql.getFieldsPSD(createSqlDTO));
        PSDList.addAll(CreateSql.getComments(createSqlDTO));
        return PSDList;
    }

    private static PreparedStatementDTO getFieldsPSD(CreateSqlDTO createSqlDTO) throws Exception {
        PreparedStatementDTO dto = new PreparedStatementDTO(null, "", new LinkedList<Object>());
        List<DbTableFieldModel> fieldModels = createSqlDTO.getFieldModels();
        if (CollectionUtils.isNotEmpty(fieldModels)) {
            for (DbTableFieldModel fieldModel : fieldModels) {
                CreateSql.fieldsSqlFrame(createSqlDTO.getDbBase(), fieldModel, dto);
            }
        } else {
            throw new Exception("\u6ca1\u6709\u521d\u59cb\u5b57\u6bb5");
        }
        String preparedSql = dto.getPrepareSql();
        String tableName = HtmlUtils.htmlEscape((String)String.valueOf(createSqlDTO.getNewTable()), (String)"UTF-8");
        dto.setPrepareSql("CREATE TABLE " + tableName + " ( " + preparedSql.substring(0, preparedSql.length() - 1) + " ) ");
        return dto;
    }

    private static void fieldsSqlFrame(DbBase dbBase, DbTableFieldModel fieldModel, PreparedStatementDTO dto) throws Exception {
        String field = fieldModel.getField();
        String dataLength = fieldModel.getDataLength();
        String dataType = fieldModel.getDataType();
        Integer allowNull = fieldModel.getAllowNull();
        Integer primaryKey = fieldModel.getPrimaryKey();
        dataType = CreateSql.dataTypeFormat(dataType, dataLength, primaryKey, dbBase);
        String notNull = DbAliasEnum.ALLOW_NULL.isFalse().equals(allowNull) ? " NOT NULL " : "";
        String primaryKeySqlFragment = DbAliasEnum.PRIMARY_KEY.isTrue().equals(primaryKey) ? " PRIMARY KEY " : "";
        field = HtmlUtils.htmlEscape((String)String.valueOf(field), (String)"UTF-8");
        String sqlFragment = field + " " + dataType + " " + notNull + " " + primaryKeySqlFragment + ",";
        dto.setPrepareSql(dto.getPrepareSql() + sqlFragment);
        LinkedList<Object> prepareDataList = dto.getPrepareDataList();
        dto.setPrepareDataList(prepareDataList);
    }

    public static String dataTypeFormat(String dataType, String dataLength, Integer primaryKey, DbBase dbBase) throws DataException {
        DataTypeModel dataTypeModel = DataTypeEnum.getDataTypeModel(dataType, dbBase);
        if (dataTypeModel != null) {
            dataTypeModel = SqlUtil.getMysqlDataTypeModel(dbBase, primaryKey, dataType, dataTypeModel);
            return CreateSql.getDataType(dataLength, dataTypeModel);
        }
        throw new DataException("\u6570\u636e\u7c7b\u578b\u4e0d\u5b58\u5728");
    }

    private static String getDataType(String dataLength, DataTypeModel dataTypeModel) {
        if (dataTypeModel.getLengthModifyFlag().booleanValue()) {
            String precision = CreateSql.getPrecision(dataTypeModel, dataLength);
            return dataTypeModel.getDbFieldType() + "(" + dataTypeModel.getCurrentLength() + precision + ")";
        }
        return dataTypeModel.getDbFieldType();
    }

    private static String getOriginDataType(String dataLength, String dataType) {
        if (CreateSql.numFlag(dataLength).booleanValue() && Integer.parseInt(dataLength) > 0) {
            return dataType + "(" + dataLength + ")";
        }
        return dataType;
    }

    private static String getPrecision(DataTypeModel dataTypeModel, String dataLength) {
        if (dataLength.contains(",")) {
            String[] split = dataLength.split(",");
            dataLength = split[0];
            dataTypeModel.setCurrentLength(CreateSql.getLengthInfo(dataTypeModel, dataLength));
            String precision = split[1];
            Integer precisionMax = dataTypeModel.getPrecisionMax();
            Integer defaultPrecision = dataTypeModel.getDefaultPrecision();
            if (precisionMax != null) {
                if (CreateSql.numFlag(precision).booleanValue() || Integer.parseInt(precision) > 0 || Integer.parseInt(precision) < precisionMax) {
                    return "," + precision;
                }
                return "," + defaultPrecision;
            }
        } else {
            dataTypeModel.setCurrentLength(CreateSql.getLengthInfo(dataTypeModel, dataLength));
        }
        return "";
    }

    private static Integer getLengthInfo(DataTypeModel dataTypeModel, String dataLength) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)dataLength) || !CreateSql.numFlag(dataLength).booleanValue()) {
            return dataTypeModel.getDefaultLength();
        }
        int lengthNum = Integer.parseInt(dataLength);
        if (lengthNum < 1 || lengthNum > dataTypeModel.getLengthMax()) {
            return dataTypeModel.getDefaultLength();
        }
        return lengthNum;
    }

    private static Boolean numFlag(String num) {
        return Pattern.compile("^[-\\+]?[\\d]*$").matcher(num).matches();
    }

    private static List<PreparedStatementDTO> getComments(CreateSqlDTO createSqlDTO) {
        if (StringUtils.isNotEmpty(createSqlDTO.getTableComment())) {
            List<PreparedStatementDTO> PSDs = SqlUtil.getMysqlSqlServerComments(createSqlDTO);
            if (PSDs != null) {
                return PSDs;
            }
            ArrayList<PreparedStatementDTO> PSDList = new ArrayList<PreparedStatementDTO>();
            SqlBase sqlBase = createSqlDTO.getDbBase().getSqlBase();
            PSDList.add(sqlBase.getTableCommentPSD(createSqlDTO));
            PSDList.addAll(sqlBase.getFieldCommentPSD(createSqlDTO));
            return PSDList;
        }
        return new ArrayList<PreparedStatementDTO>();
    }
}

