/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.sql.impl;

import com.bringspring.common.database.enums.ParamEnum;
import com.bringspring.common.database.model.DbFieldMod;
import com.bringspring.common.database.model.dto.PreparedStatementDTO;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.sql.SqlBase;
import com.bringspring.common.database.sql.append.insert.InsertSql;
import com.bringspring.common.database.sql.append.insert.InsertSqlDTO;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.StringUtils;
import java.sql.Connection;
import java.util.List;
import org.springframework.web.util.HtmlUtils;

public class SqlOracle
extends SqlBase {
    private final String dbTimeSql = "select to_char(sysdate,'yyyy-mm-dd hh24:mi:ss') as TIME from dual";
    protected String deleteSql = "DROP TABLE ?;";

    @Override
    protected void init() {
        String fieldListSql = "SELECT * FROM \n\n(\nSELECT DISTINCT\n\tA.column_name AS FIELD_NAME,\n\tA.data_type AS DATATYPE,\n\tA.CHAR_COL_DECL_LENGTH AS DATA_LENGTH,\nCASE\n\t\tA.nullable \n\t\tWHEN 'N' THEN\n\t\t'0' ELSE '1' \n\tEND AS ALLOW_NULL,\nCASE\n\tA.nullable \n\tWHEN 'N' THEN\n\t'1' ELSE '0' \n\tEND AS PRIMARY_KEY,\n\tB.comments AS FIELD_COMMENT\nFROM\n\tuser_tab_columns A,\n\tuser_col_comments B,\n\tall_cons_columns C,\n\tUSER_TAB_COMMENTS D \nWHERE\n\ta.COLUMN_NAME = b.column_name \n\tAND A.Table_Name = B.Table_Name \n\tAND A.Table_Name = D.Table_Name \n\tAND ( A.TABLE_NAME = c.table_name ) \n\tAND A.Table_Name = " + ParamEnum.TABLE.getParamSign() + "\n) A,\n(\nselect a.column_name name,case when a.column_name=t.column_name then 1 else 0 end " + "PRIMARY_KEY" + "\nfrom user_tab_columns a\nleft join (select b.table_name,b.column_name from user_cons_columns b\njoin user_constraints c on c.CONSTRAINT_NAME=b.CONSTRAINT_NAME\nwhere c.constraint_type   ='P') t\non a.table_name=t.table_name\nwhere a.table_name= " + ParamEnum.TABLE.getParamSign() + "\n) B WHERE A." + "FIELD_NAME" + " = b.NAME";
        String tableListSql = "SELECT a.TABLE_NAME TABLE_NAME, b.COMMENTS TABLE_COMMENT, a.num_rows TABLE_SUM\nFROM user_tables a, user_tab_comments b WHERE a.TABLE_NAME = b.TABLE_NAME ";
        String existsTableSql = "SELECT a.TABLE_NAME TABLE_NAME FROM user_tables a WHERE a.TABLE_NAME = " + ParamEnum.TABLE.getParamSign();
        this.setInstance(fieldListSql, tableListSql, existsTableSql, "{table}:{table}", "", "{table}");
    }

    @Override
    public String batchInsertSql(List<List<DbFieldMod>> dataList, String table) throws DataException {
        DbBase dbBase = DbTypeUtil.getDriver("Oracle");
        InsertSqlDTO iInsertSqlDTO = new InsertSqlDTO(dbBase, table, dataList, ";");
        return InsertSql.batch(iInsertSqlDTO);
    }

    @Override
    public String[] getPageSql(String sql, String sortType, Integer currentPage, Integer pageSize) {
        String sortSql = StringUtils.isEmpty(sortType) ? "" : " ORDER BY " + sortType;
        String dataListSql = "SELECT *FROM (SELECT jsbos_tt.*, ROWNUM AS rowno FROM (" + sql + ") jsbos_tt " + sortSql + ") jnfp_tab WHERE jnfp_tab.rowno between " + (currentPage - 1) * pageSize + " and " + currentPage * pageSize;
        String totalSql = "SELECT COUNT(*) totalRecord FROM (" + sql + ") jsbos_tab";
        return new String[]{dataListSql, totalSql};
    }

    @Override
    public PreparedStatementDTO getDeleteSqlPSD(Connection conn, String deleteTable) {
        deleteTable = HtmlUtils.htmlEscape((String)String.valueOf(deleteTable), (String)"UTF-8");
        return new PreparedStatementDTO(conn, "DROP TABLE " + deleteTable);
    }

    public static String getOracleDataTime(String dataType, String value) {
        value = "date".equals(dataType.toLowerCase()) || dataType.toLowerCase().contains("time") ? "TO_DATE('" + value + "','YYYY-MM-DD HH24:MI:SS')" : (null == value ? "" + value + "," : "'" + value + "',");
        return value;
    }

    public String jdbcCreUpSql(String sql) {
        String jdbcSql = "";
        if (sql.toLowerCase().contains("insert") && sql.replaceAll(" ", "").contains("),(")) {
            String[] splitSql = sql.split("\\),\\(");
            String centerSql = splitSql[0].split("VALUES")[0].split("INSERT")[1];
            String lastSql = splitSql[splitSql.length - 1];
            splitSql[splitSql.length - 1] = lastSql.substring(0, lastSql.length() - 1);
            for (int i = 0; i < splitSql.length; ++i) {
                String sqlFlagm = i == 0 ? splitSql[i] + ")" : "INSERT " + centerSql + "VALUES (" + splitSql[i] + ")";
                jdbcSql = jdbcSql + sqlFlagm;
            }
        } else {
            jdbcSql = sql;
        }
        return jdbcSql;
    }

    public String getDbTimeSql() {
        return this.dbTimeSql;
    }

    @Override
    public String getDeleteSql() {
        return this.deleteSql;
    }

    @Override
    public void setDeleteSql(String deleteSql) {
        this.deleteSql = deleteSql;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqlOracle)) {
            return false;
        }
        SqlOracle other = (SqlOracle)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dbTimeSql = this.getDbTimeSql();
        String other$dbTimeSql = other.getDbTimeSql();
        if (this$dbTimeSql == null ? other$dbTimeSql != null : !this$dbTimeSql.equals(other$dbTimeSql)) {
            return false;
        }
        String this$deleteSql = this.getDeleteSql();
        String other$deleteSql = other.getDeleteSql();
        return !(this$deleteSql == null ? other$deleteSql != null : !this$deleteSql.equals(other$deleteSql));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SqlOracle;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dbTimeSql = this.getDbTimeSql();
        result = result * 59 + ($dbTimeSql == null ? 43 : $dbTimeSql.hashCode());
        String $deleteSql = this.getDeleteSql();
        result = result * 59 + ($deleteSql == null ? 43 : $deleteSql.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SqlOracle(dbTimeSql=" + this.getDbTimeSql() + ", deleteSql=" + this.getDeleteSql() + ")";
    }
}

