/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.util;

import com.bringspring.common.database.model.dto.DataSourceDTO;
import com.bringspring.common.database.model.interfaces.DataSourceMod;
import com.bringspring.common.database.source.DbBase;
import com.bringspring.common.database.util.ConnUtil;
import com.bringspring.common.database.util.DbTypeUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.context.SpringContext;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ConnUtil2 {
    public static Connection getConnTimeout(DataSourceMod dbSourceOrDbLink) throws DataException {
        return ConnUtil2.getConnTimeout(dbSourceOrDbLink, null);
    }

    public static Connection getConnTimeout(DataSourceMod dataSourceUtil, String dbName) throws DataException {
        DataSourceDTO dsd = dataSourceUtil.convertDTO(dbName);
        DbBase dbBase = DbTypeUtil.getDb(dataSourceUtil);
        return ConnUtil2.createConn(dbBase.getDriver(), dsd.getUserName(), dsd.getPassword(), ConnUtil.getUrl(dsd), 3L, "254");
    }

    public static Connection getConnTimeout(String userName, String password, String url) throws DataException {
        return ConnUtil2.createConn(DbTypeUtil.getDb(url).getDriver(), userName, password, url, 3L, "254");
    }

    private static Connection createConn(String driverClass, String userName, String password, String url, Long timeoutNum, String warning) throws DataException {
        Connection[] conn = new Connection[]{null};
        Callable<String> task = ConnUtil2.getTask(userName, password, url, driverClass, conn);
        ConnUtil2.futureGo(task, warning, timeoutNum);
        try {
            Connection cConn = conn[0];
            return cConn;
        }
        catch (Exception e) {
            throw new DataException(e.getMessage());
        }
    }

    private static void futureGo(Callable<String> task, String warning, Long timeoutNum) throws DataException {
        ThreadPoolTaskExecutor executor = SpringContext.getBean(ThreadPoolTaskExecutor.class);
        Future future = executor.submit(task);
        try {
            String string = (String)future.get(timeoutNum, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw DataException.errorLink("\u8fde\u63a5\u8d85\u65f6");
        }
        catch (Exception e) {
            throw DataException.errorLink("\u8fde\u63a5\u9519\u8bef");
        }
        finally {
            executor.shutdown();
        }
    }

    private static Callable<String> getTask(String userName, String password, String url, String driverClass, Connection[] conn) throws DataException {
        Callable<String> task = () -> {
            try {
                Class.forName(driverClass);
                conn[0] = DriverManager.getConnection(url, userName, password);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DataException(e.getMessage());
            }
            return "jdbc\u8fde\u63a5\u6210\u529f";
        };
        return task;
    }
}

