/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.database.util;

import com.bringspring.common.database.model.DbFieldMod;
import com.bringspring.common.database.model.DbTableFieldModel;
import com.bringspring.common.database.model.DbTableInfoModel;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JdbcOriginUtil {
    public static DbTableInfoModel getTableInfo(Connection conn, String table) {
        return JdbcOriginUtil.getTableInfoAll(conn).stream().filter(t -> t.getTable().equals(table)).findFirst().orElse(null);
    }

    public static List<DbTableInfoModel> getTableInfoAll(Connection conn) {
        ArrayList<DbTableInfoModel> dbTableInfoModelList = new ArrayList<DbTableInfoModel>();
        JdbcOriginUtil.setTableInfo(conn, dbTableInfoModelList, null);
        return dbTableInfoModelList;
    }

    public static List<DbTableFieldModel> getFields(Connection conn, String table) {
        String primaryField = JdbcOriginUtil.getPrimaryField(conn, table);
        List<DbFieldMod> DbFieldModList = JdbcOriginUtil.getFieldsMeta(conn, table);
        ArrayList<DbTableFieldModel> dbTableFieldModelList = new ArrayList<DbTableFieldModel>();
        DbFieldModList.forEach(x -> {
            DbTableFieldModel dbTableFieldModel = new DbTableFieldModel();
            dbTableFieldModel.setField(x.getColumnName());
            dbTableFieldModel.setDefaults(x.getColumnDefault());
            dbTableFieldModel.setIdentity(x.getIsAutoIncrement());
            dbTableFieldModel.setFieldName(x.getColumnComment());
            dbTableFieldModel.setDataType(x.getColumnTypeName());
            dbTableFieldModel.setPrimaryKey(x.getColumnName().equals(primaryField) ? 1 : 0);
            dbTableFieldModel.setAllowNull(x.getIsNull());
            dbTableFieldModel.setDataLength(x.getColumnSize());
            dbTableFieldModelList.add(dbTableFieldModel);
        });
        return dbTableFieldModelList;
    }

    public static List<DbFieldMod> getFieldsMeta(Connection conn, String table) {
        ArrayList<DbFieldMod> dbFieldModList = new ArrayList<DbFieldMod>();
        JdbcOriginUtil.setFieldInfo(conn, dbFieldModList, null, table);
        return dbFieldModList;
    }

    public static List<Map<String, String>> getFieldsMap(Connection conn, String table) {
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        JdbcOriginUtil.setFieldInfo(conn, null, mapList, table);
        return mapList;
    }

    private static List<Map<String, String>> getTableMetaDataAll(Connection conn) {
        ArrayList<Map<String, String>> mapList = new ArrayList<Map<String, String>>();
        JdbcOriginUtil.setTableInfo(conn, null, mapList);
        return mapList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setTableInfo(Connection conn, List<DbTableInfoModel> dbTableInfoModelList, List<Map<String, String>> mapList) {
        try {
            ResultSet rs = conn.getMetaData().getTables(conn.getCatalog(), null, null, new String[]{"TABLE"});
            try {
                while (rs.next()) {
                    if (dbTableInfoModelList != null) {
                        DbTableInfoModel dbTableInfoModel = new DbTableInfoModel();
                        dbTableInfoModel.setTable(rs.getString("TABLE_NAME"));
                        dbTableInfoModel.setTableType(rs.getString("TABLE_TYPE"));
                        dbTableInfoModel.setComment(rs.getString("REMARKS"));
                        dbTableInfoModelList.add(dbTableInfoModel);
                        continue;
                    }
                    ResultSetMetaData resultSetMetaData = rs.getMetaData();
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        map.put(resultSetMetaData.getColumnName(i), rs.getString(i));
                    }
                    mapList.add(map);
                }
            }
            finally {
                if (Collections.singletonList(rs).get(0) != null) {
                    rs.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPrimaryField(Connection conn, String table) {
        try {
            ResultSet rs2 = conn.getMetaData().getPrimaryKeys(conn.getCatalog(), null, table);
            try {
                if (!rs2.next()) return "";
                String string = rs2.getString("COLUMN_NAME");
                return string;
            }
            finally {
                if (Collections.singletonList(rs2).get(0) != null) {
                    rs2.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setFieldInfo(Connection conn, List<DbFieldMod> dbFieldModList, List<Map<String, String>> mapList, String table) {
        try {
            DatabaseMetaData dbMetaData = conn.getMetaData();
            ResultSet resultSet = dbMetaData.getColumns(conn.getCatalog(), dbMetaData.getUserName(), table, null);
            try {
                while (resultSet.next()) {
                    if (dbFieldModList != null) {
                        DbFieldMod dbFieldMod = new DbFieldMod();
                        dbFieldMod.setTableName(resultSet.getString("TABLE_NAME"));
                        dbFieldMod.setColumnName(resultSet.getString("COLUMN_NAME"));
                        dbFieldMod.setTableName(resultSet.getString("TYPE_NAME"));
                        dbFieldMod.setColumnTypeName(resultSet.getString("TYPE_NAME"));
                        dbFieldMod.setColumnSize(resultSet.getString("COLUMN_SIZE"));
                        dbFieldMod.setDecimalDigits(resultSet.getString("DECIMAL_DIGITS"));
                        dbFieldMod.setColumnDefault(resultSet.getString("COLUMN_DEF"));
                        dbFieldMod.setColumnComment(resultSet.getString("REMARKS"));
                        dbFieldMod.setOrdinalPosition(resultSet.getString("ORDINAL_POSITION"));
                        dbFieldMod.setIsAutoIncrement(resultSet.getString("IS_AUTOINCREMENT"));
                        String isNull = resultSet.getString("IS_NULLABLE");
                        dbFieldMod.setIsNull(isNull.equals("YES") ? 1 : 0);
                        dbFieldModList.add(dbFieldMod);
                        continue;
                    }
                    JdbcOriginUtil.setMetadataInfo(mapList, resultSet);
                }
            }
            finally {
                if (Collections.singletonList(resultSet).get(0) != null) {
                    resultSet.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setMetadataInfo(List<Map<String, String>> mapList, ResultSet resultSet) {
        try {
            HashMap<String, String> map = new HashMap<String, String>(16);
            for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                map.put(resultSet.getMetaData().getColumnName(i), resultSet.getString(i));
            }
            mapList.add(map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

