/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.security.MessageDigest;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class DesUtil {
    private static final String MD5 = "MD5";
    private static final String SHA1 = "SHA1";
    private static final String HMAC_MD5 = "HmacMD5";
    private static final String HMAC_SHA_1 = "HmacSHA1";
    private static final String DES = "DES";
    private static final String AES = "AES";
    private static String charset = "utf-8";
    private static int keysizeDES = 0;
    private static int keysizeAES = 128;
    private static String key = "com/bringspring";

    private static String messageDigest(String res, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] resBytes = charset == null ? res.getBytes() : res.getBytes(charset);
            return DesUtil.base64(md.digest(resBytes));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String keyGeneratorMac(String res, String algorithm, String key) {
        try {
            SecretKey sk = null;
            if (key == null) {
                KeyGenerator kg = KeyGenerator.getInstance(algorithm);
                sk = kg.generateKey();
            } else {
                byte[] keyBytes = charset == null ? key.getBytes() : key.getBytes(charset);
                sk = new SecretKeySpec(keyBytes, algorithm);
            }
            Mac mac = Mac.getInstance(algorithm);
            mac.init(sk);
            byte[] result = mac.doFinal(res.getBytes());
            return DesUtil.base64(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String keyGeneratorEs(String res, String algorithm, String key, int keysize, boolean isEncode) {
        try {
            SecretKeySpec sks = null;
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            KeyGenerator kg = KeyGenerator.getInstance(algorithm);
            if (key != null) {
                random.setSeed(key.getBytes());
                if (keysize == 0) {
                    kg.init(random);
                } else {
                    kg.init(keysize, random);
                }
            } else {
                kg.init(keysize);
            }
            SecretKey sk = kg.generateKey();
            sks = new SecretKeySpec(sk.getEncoded(), algorithm);
            Cipher cipher = Cipher.getInstance(algorithm);
            if (isEncode) {
                cipher.init(1, sks);
                byte[] resBytes = charset == null ? res.getBytes() : res.getBytes(charset);
                return DesUtil.parseByte2HexStr(cipher.doFinal(resBytes));
            }
            cipher.init(2, sks);
            return new String(cipher.doFinal(DesUtil.parseHexStr2Byte(res)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String base64(byte[] res) {
        return Base64.encode(res);
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static String md5(String res) {
        return DesUtil.messageDigest(res, MD5);
    }

    public static String md5(String res, String key) {
        return DesUtil.keyGeneratorMac(res, HMAC_MD5, key);
    }

    public static String sha1(String res) {
        return DesUtil.messageDigest(res, SHA1);
    }

    public static String sha1(String res, String key) {
        return DesUtil.keyGeneratorMac(res, HMAC_SHA_1, key);
    }

    public static String desEncode(String res) {
        return DesUtil.keyGeneratorEs(res, DES, key, keysizeDES, true);
    }

    public static String desDecode(String res) {
        return DesUtil.keyGeneratorEs(res, DES, key, keysizeDES, false);
    }

    public static String aesEncode(String res) {
        return DesUtil.keyGeneratorEs(res, AES, key, keysizeAES, true);
    }

    public static String aesDecode(String res) {
        return DesUtil.keyGeneratorEs(res, AES, key, keysizeAES, false);
    }

    public static String base64Encode(String res) {
        return Base64.encode(res.getBytes());
    }

    public static String base64Decode(String res) {
        return new String(Base64.decode(res));
    }
}

