/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import cn.hutool.core.img.ImgUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.model.filedownlog.FileDownLogCrForm;
import com.bringspring.common.service.FileDownLogService;
import com.bringspring.common.util.CodeUtil;
import com.bringspring.common.util.DesUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.context.SpringContext;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DownUtil.class);
    private static final ConfigValueUtil configValueUtil = SpringContext.getBean(ConfigValueUtil.class);
    private static final FileDownLogService filedownlogService = SpringContext.getBean(FileDownLogService.class);
    private static final UserProvider userProvider = SpringContext.getBean(UserProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dowloadExcel(Workbook workbook, String fileName) {
        try {
            HttpServletResponse response = ServletUtils.getResponse();
            response.setCharacterEncoding("UTF-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            ServletOutputStream outputStream = response.getOutputStream();
            try {
                workbook.write((OutputStream)outputStream);
            }
            finally {
                if (Collections.singletonList(outputStream).get(0) != null) {
                    outputStream.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dowloadFile(File file, String fileName) {
        String escapeFileName = XSSEscape.escape(fileName);
        HttpServletResponse response = ServletUtils.getResponse();
        HttpServletRequest request = ServletUtils.getRequest();
        try {
            FileInputStream is = new FileInputStream(file);
            try {
                BufferedInputStream bis = new BufferedInputStream(is);
                try {
                    response.setCharacterEncoding("UTF-8");
                    response.setContentType("application/x-download");
                    String codeFileName = "";
                    String agent = request.getHeader("USER-AGENT").toLowerCase();
                    codeFileName = -1 != agent.indexOf("msie") || -1 != agent.indexOf("trident") ? URLEncoder.encode(escapeFileName, "UTF-8") : (-1 != agent.indexOf("mozilla") ? new String(escapeFileName.getBytes("UTF-8"), "iso-8859-1") : URLEncoder.encode(escapeFileName, "UTF-8"));
                    response.setHeader("Content-Disposition", "attachment;filename=\"" + codeFileName + "\"");
                    ServletOutputStream os = response.getOutputStream();
                    try {
                        int i;
                        byte[] buff = new byte[8192];
                        while ((i = bis.read(buff)) != -1) {
                            os.write(buff, 0, i);
                        }
                        os.flush();
                    }
                    finally {
                        if (Collections.singletonList(os).get(0) != null) {
                            os.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(bis).get(0) != null) {
                        bis.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(is).get(0) != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean dowloadFile(String paths, String fileName, String downName) {
        LOG.error("\u538b\u7f29\u5305\u8def\u5f84\uff1a------------------------" + paths);
        if (StringUtils.isNotEmpty(downName)) {
            fileName = downName;
        }
        String escapeFileName = XSSEscape.escape(fileName);
        HttpServletResponse response = ServletUtils.getResponse();
        HttpServletRequest request = ServletUtils.getRequest();
        try {
            File file = new File(XSSEscape.escapePath(paths));
            FileInputStream is = new FileInputStream(file);
            try {
                BufferedInputStream bis = new BufferedInputStream(is);
                try {
                    response.setCharacterEncoding("UTF-8");
                    String contentType = Files.probeContentType(Paths.get(file.getAbsolutePath(), new String[0]));
                    response.setContentType(contentType);
                    if (escapeFileName.contains(".pdf")) {
                        response.setContentType("application/pdf;charset=utf-8");
                    }
                    if (escapeFileName.contains(".svg")) {
                        response.setContentType("image/svg+xml;charset=utf-8");
                    }
                    String codeFileName = "";
                    String agent = request.getHeader("USER-AGENT").toLowerCase();
                    codeFileName = -1 != agent.indexOf("msie") || -1 != agent.indexOf("trident") ? URLEncoder.encode(escapeFileName, "UTF-8") : (-1 != agent.indexOf("mozilla") ? new String(escapeFileName.getBytes("UTF-8"), "iso-8859-1") : URLEncoder.encode(escapeFileName, "UTF-8"));
                    response.setHeader("Content-Disposition", "attachment;filename=" + new String(codeFileName.getBytes(), "utf-8"));
                    ServletOutputStream os = response.getOutputStream();
                    try {
                        int i;
                        byte[] buff = new byte[8192];
                        while ((i = bis.read(buff)) != -1) {
                            os.write(buff, 0, i);
                        }
                        os.flush();
                        DownUtil.downloadFileLog(file, paths, fileName, downName);
                    }
                    finally {
                        if (Collections.singletonList(os).get(0) != null) {
                            os.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(bis).get(0) != null) {
                        bis.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(is).get(0) != null) {
                    ((InputStream)is).close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void downloadFileLog(File file, String paths, String fileName, String downName) {
        byte[] bytes = null;
        try {
            bytes = FileUtil.readBytes((File)file);
        }
        catch (Exception exception) {
            // empty catch block
        }
        FileDownLogCrForm fe = new FileDownLogCrForm();
        String fileId = IdWorker.getIdStr();
        fe.setFileId(fileId);
        fe.setUrl(paths);
        fe.setFileName(fileName);
        fe.setSuffix(FileUtil.getType((File)file));
        fe.setCreatorUserId(userProvider.get(DesUtil.aesDecode(ServletUtils.getRequest().getParameter("encryption")).split("#")[0]).getUserId());
        fe.setFileType(FileUtil.getType((File)file));
        fe.setEngine(configValueUtil.getFileType());
        fe.setFileName(fileName);
        fe.setObjName(fileName);
        fe.setSizeInfo(FileUtil.readableFileSize((File)file));
        fe.setFileDigest(file.getPath().split("\\\\")[file.getPath().split("\\\\").length - 2]);
        fe.setStoragePath(paths);
        if (ObjectUtil.isNotEmpty((Object)fe.getFileType()) && DownUtil.isPic(fe.getFileType())) {
            try {
                fe.setThumbnail(ImgUtil.toBase64DataUri((Image)ImgUtil.scale((Image)ImgUtil.toImage((byte[])bytes), (int)100, (int)100, null), (String)fe.getFileType()));
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        filedownlogService.create(fe);
    }

    private static boolean isPic(String fileSuffix) {
        return "gif".equals(fileSuffix = fileSuffix.toLowerCase()) || "jpg".equals(fileSuffix) || "jpeg".equals(fileSuffix) || "bmp".equals(fileSuffix) || "png".equals(fileSuffix) || "psd".equals(fileSuffix);
    }

    public static void downCode(Integer stringLength) {
        HttpServletResponse response = DownUtil.getResponse();
        CodeUtil codeUtil = new CodeUtil();
        codeUtil.getRandcode(response, stringLength);
    }

    public static void write(BufferedImage image) {
        try {
            HttpServletResponse response = DownUtil.getResponse();
            ServletOutputStream outputStream = response.getOutputStream();
            try {
                ImageIO.write((RenderedImage)image, "PNG", (OutputStream)outputStream);
            }
            finally {
                if (Collections.singletonList(outputStream).get(0) != null) {
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            e.getMessage();
        }
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = ServletUtils.getResponse();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("image/jpeg");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expire", 0L);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dowloadFile(String file) {
        try {
            OutputStream outputStream = null;
            try {
                FileInputStream in = null;
                try {
                    int n;
                    in = new FileInputStream(file);
                    HttpServletResponse response = ServletUtils.getResponse();
                    String range = ServletUtils.getRequest().getHeader("Range");
                    if (StringUtils.isNotEmpty(range)) {
                        byte[] fileBytes = IoUtil.readBytes((InputStream)in);
                        response.setHeader("Accept-Ranges", "bytes");
                        response.setStatus(206);
                        response.setContentLength(fileBytes.length);
                    }
                    outputStream = new BufferedOutputStream((OutputStream)response.getOutputStream());
                    byte[] buff = new byte[1024];
                    while ((n = ((InputStream)in).read(buff)) != -1) {
                        outputStream.write(buff, 0, n);
                    }
                    outputStream.flush();
                }
                finally {
                    if (Collections.singletonList(in).get(0) != null) {
                        ((InputStream)in).close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(outputStream).get(0) != null) {
                    outputStream.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void voidPlay(String path) {
        HttpServletRequest request = ServletUtils.getRequest();
        HttpServletResponse response = ServletUtils.getResponse();
        BufferedInputStream bis = null;
        try {
            File file = new File(path);
            if (file.exists()) {
                String contentRange;
                long p = 0L;
                long toLength = 0L;
                long contentLength = 0L;
                int rangeSwitch = 0;
                String rangBytes = "";
                long fileLength = file.length();
                FileInputStream ins = new FileInputStream(file);
                bis = new BufferedInputStream(ins);
                response.reset();
                response.setHeader("Accept-Ranges", "bytes");
                String range = request.getHeader("Range");
                if (range != null && range.trim().length() > 0 && !"null".equals(range)) {
                    response.setStatus(206);
                    rangBytes = range.replaceAll("bytes=", "");
                    if (rangBytes.endsWith("-")) {
                        rangeSwitch = 1;
                        p = Long.parseLong(rangBytes.substring(0, rangBytes.indexOf("-")));
                        contentLength = fileLength - p;
                    } else {
                        rangeSwitch = 2;
                        String temp1 = rangBytes.substring(0, rangBytes.indexOf("-"));
                        String temp2 = rangBytes.substring(rangBytes.indexOf("-") + 1, rangBytes.length());
                        p = Long.parseLong(temp1);
                        toLength = Long.parseLong(temp2);
                        contentLength = toLength - p + 1L;
                    }
                } else {
                    contentLength = fileLength;
                }
                response.setHeader("Content-Length", Long.toString(contentLength));
                if (rangeSwitch == 1) {
                    contentRange = new StringBuffer("bytes ").append(new Long(p).toString()).append("-").append(new Long(fileLength - 1L).toString()).append("/").append(new Long(fileLength).toString()).toString();
                    response.setHeader("Content-Range", contentRange);
                    bis.skip(p);
                } else if (rangeSwitch == 2) {
                    contentRange = range.replace("=", " ") + "/" + Long.toString(fileLength);
                    response.setHeader("Content-Range", contentRange);
                    bis.skip(p);
                } else {
                    contentRange = new StringBuffer("bytes ").append("0-").append(fileLength - 1L).append("/").append(fileLength).toString();
                    response.setHeader("Content-Range", contentRange);
                }
                String fileName = file.getName();
                response.setContentType("application/octet-stream");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                ServletOutputStream out = response.getOutputStream();
                int n = 0;
                int bsize = 1024;
                byte[] bytes = new byte[bsize];
                if (rangeSwitch == 2) {
                    long readLength;
                    for (readLength = 0L; readLength <= contentLength - (long)bsize; readLength += (long)n) {
                        n = bis.read(bytes);
                        out.write(bytes, 0, n);
                    }
                    if (readLength <= contentLength) {
                        n = bis.read(bytes, 0, (int)(contentLength - readLength));
                        out.write(bytes, 0, n);
                    }
                } else {
                    while ((n = bis.read(bytes)) != -1) {
                        out.write(bytes, 0, n);
                    }
                }
                out.flush();
                out.close();
                bis.close();
            }
        }
        catch (IOException file) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean deleteFile(String sPath) {
        boolean flag = false;
        File file = new File(sPath);
        if (file.isFile() && file.exists()) {
            file.delete();
            flag = true;
        }
        return flag;
    }
}

