/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.imageio.ImageIO;

public class ZxingCodeUtil {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    private static final int QRCOLOR = -16777216;
    private static final int BGCOLOR = -1;

    public static BufferedImage getBarcode(String message, int width, int height) {
        try {
            Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, "code");
            BitMatrix bitMatrix = new MultiFormatWriter().encode(message, BarcodeFormat.CODE_128, width, height, hints);
            return ZxingCodeUtil.toBufferedImage(bitMatrix);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static BufferedImage toBufferedImage(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 2);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    public static BufferedImage createCode(String message, int width, int height) {
        MultiFormatWriter multiFormatWriter = null;
        BitMatrix bm = null;
        BufferedImage image = null;
        Map<EncodeHintType, Object> hints = ZxingCodeUtil.getDecodeHintType();
        try {
            multiFormatWriter = new MultiFormatWriter();
            bm = multiFormatWriter.encode(message, BarcodeFormat.QR_CODE, width, height, hints);
            int w = bm.getWidth();
            int h = bm.getHeight();
            image = new BufferedImage(w, h, 1);
            for (int x = 0; x < w; ++x) {
                for (int y = 0; y < h; ++y) {
                    image.setRGB(x, y, bm.get(x, y) ? -16777216 : -1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public static BufferedImage createCodeWithLogo(String message, String logoPath, int width, int height) {
        BufferedImage bim = ZxingCodeUtil.createCode(message, width, height);
        try {
            BufferedImage image = bim;
            Graphics2D g = image.createGraphics();
            BufferedImage logo = ImageIO.read(new File(logoPath));
            int widthLogo = logo.getWidth(null) > image.getWidth() * 3 / 10 ? image.getWidth() * 3 / 10 : logo.getWidth(null);
            int heightLogo = logo.getHeight(null) > image.getHeight() * 3 / 10 ? image.getHeight() * 3 / 10 : logo.getWidth(null);
            int x = (image.getWidth() - widthLogo) / 2;
            int y = (image.getHeight() - heightLogo) / 2;
            g.drawImage(logo, x, y, widthLogo, heightLogo, null);
            g.dispose();
            logo.flush();
            image.flush();
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage createCodeWithLogoAndText(String message, String logoPath, String text, int width, int height) {
        BufferedImage image = ZxingCodeUtil.createCodeWithLogo(message, logoPath, width, height);
        try {
            if (text != null && !"".equals(text)) {
                BufferedImage outImage = new BufferedImage(400, 445, 6);
                Graphics2D outg = outImage.createGraphics();
                outg.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
                outg.setColor(Color.BLACK);
                outg.setFont(new Font("\u5b8b\u4f53", 1, 30));
                int strWidth = outg.getFontMetrics().stringWidth(text);
                if (strWidth > 399) {
                    String productName1 = text.substring(0, text.length() / 2);
                    String productName2 = text.substring(text.length() / 2, text.length());
                    int strWidth1 = outg.getFontMetrics().stringWidth(productName1);
                    int strWidth2 = outg.getFontMetrics().stringWidth(productName2);
                    outg.drawString(productName1, 200 - strWidth1 / 2, image.getHeight() + (outImage.getHeight() - image.getHeight()) / 2 + 12);
                    BufferedImage outImage2 = new BufferedImage(400, 485, 6);
                    Graphics2D outg2 = outImage2.createGraphics();
                    outg2.drawImage(outImage, 0, 0, outImage.getWidth(), outImage.getHeight(), null);
                    outg2.setColor(Color.BLACK);
                    outg2.setFont(new Font("\u5b8b\u4f53", 1, 30));
                    outg2.drawString(productName2, 200 - strWidth2 / 2, outImage.getHeight() + (outImage2.getHeight() - outImage.getHeight()) / 2 + 5);
                    outg2.dispose();
                    outImage2.flush();
                    outImage = outImage2;
                } else {
                    outg.drawString(text, 200 - strWidth / 2, image.getHeight() + (outImage.getHeight() - image.getHeight()) / 2 + 12);
                }
                outg.dispose();
                outImage.flush();
                image = outImage;
                image.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    private static Map<EncodeHintType, Object> getDecodeHintType() {
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>(16);
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        hints.put(EncodeHintType.MARGIN, 0);
        hints.put(EncodeHintType.MAX_SIZE, 350);
        hints.put(EncodeHintType.MIN_SIZE, 100);
        return hints;
    }
}

