/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util.treeutil;

import com.bringspring.common.util.treeutil.TreeModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TreeUtils {
    public static <T extends TreeModel> List<TreeModel<T>> listToTreeVO(List<T> tList) {
        ArrayList<TreeModel<T>> treeModelList = new ArrayList<TreeModel<T>>();
        if (tList != null && tList.size() > 0) {
            for (TreeModel t : tList) {
                if (TreeUtils.isTreevoExist(tList, t.getParentId()).booleanValue()) continue;
                TreeModel<TreeModel> tTreeModel = TreeUtils.getTreevoByT(t, tList);
                treeModelList.add(tTreeModel);
            }
        }
        return treeModelList;
    }

    private static <T extends TreeModel> Boolean isTreevoExist(List<T> tList, String id) {
        for (TreeModel t : tList) {
            if (!t.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    private static <T extends TreeModel> List<TreeModel<T>> getChildTreevoList(TreeModel<T> parentTreeModel, List<T> tList) {
        ArrayList<TreeModel<T>> childTreeModelList = new ArrayList<TreeModel<T>>();
        for (TreeModel t : tList) {
            if (!parentTreeModel.getId().equals(t.getParentId())) continue;
            TreeModel<TreeModel> tTreeModel = TreeUtils.getTreevoByT(t, tList);
            childTreeModelList.add(tTreeModel);
        }
        return childTreeModelList;
    }

    private static <T extends TreeModel> TreeModel<T> getTreevoByT(T t, List<T> tList) {
        TreeModel tTreeModel = new TreeModel();
        tTreeModel.setId(t.getId());
        tTreeModel.setParentId(t.getParentId());
        tTreeModel.setFullName(t.getFullName());
        tTreeModel.setIcon(t.getIcon());
        List children = TreeUtils.getChildTreevoList(tTreeModel, tList);
        tTreeModel.setHasChildren(children.size() != 0);
        tTreeModel.setChildren(children);
        return tTreeModel;
    }

    public static <T extends TreeModel, K> Set<K> convertTreevoToIdSet(List<TreeModel<T>> treeModelList, Class<K> kClass) {
        HashSet<String> idSet = new HashSet<String>(16);
        if (treeModelList != null && treeModelList.size() > 0) {
            for (TreeModel<T> treeModel : treeModelList) {
                idSet.add(treeModel.getId());
                if (treeModel.getChildren() == null || treeModel.getChildren().size() <= 0) continue;
                idSet.addAll(TreeUtils.convertTreevoToIdSet(treeModel.getChildren(), kClass));
            }
        }
        return idSet;
    }

    public static List<TreeModel> listToTree(List<TreeModel> tList) {
        ArrayList<TreeModel> treeModelList = new ArrayList<TreeModel>();
        if (tList != null && tList.size() > 0) {
            for (TreeModel t : tList) {
                if (TreeUtils.isTreevoExist(tList, t.getParentId()).booleanValue()) continue;
                TreeModel tTreeModel = TreeUtils.getTreeByT(t, tList);
                treeModelList.add(tTreeModel);
            }
        }
        return treeModelList;
    }

    private static List<TreeModel> getChildTreeList(TreeModel parentTreeModel, List<TreeModel> tList) {
        ArrayList<TreeModel> childTreeModelList = new ArrayList<TreeModel>();
        for (TreeModel t : tList) {
            if (!parentTreeModel.getId().equals(t.getParentId())) continue;
            TreeModel<TreeModel> tTreeModel = TreeUtils.getTreevoByT(t, tList);
            childTreeModelList.add(tTreeModel);
        }
        return childTreeModelList;
    }

    private static TreeModel getTreeByT(TreeModel t, List<TreeModel> tList) {
        TreeModel tTreeModel = new TreeModel();
        tTreeModel.setId(t.getId());
        tTreeModel.setParentId(t.getParentId());
        tTreeModel.setFullName(t.getFullName());
        tTreeModel.setIcon(t.getIcon());
        List children = TreeUtils.getChildTreeList(tTreeModel, tList);
        tTreeModel.setHasChildren(children.size() != 0);
        tTreeModel.setChildren(children);
        return tTreeModel;
    }
}

