/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.common.util.treeutil.newtreeutil;

import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.treeutil.SumTree;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class TreeDotUtils {
    public static <T extends SumTree> List<SumTree<T>> convertListToTreeDot(List<T> tList, String parentId) {
        ArrayList<SumTree<T>> sumTrees = new ArrayList<SumTree<T>>();
        ArrayList list = new ArrayList();
        CollectionUtils.addAll(list, tList);
        if (StringUtils.isNotEmpty(parentId)) {
            List data = list.stream().filter(t -> parentId.equals(t.getParentId())).collect(Collectors.toList());
            list.removeAll(data);
            for (int i = 0; i < data.size(); ++i) {
                SumTree t2 = (SumTree)data.get(i);
                if (TreeDotUtils.isTreeDotExist(list, t2.getParentId()).booleanValue()) continue;
                SumTree<SumTree> tSumTree = TreeDotUtils.getTreeDotByT(t2, list);
                sumTrees.add(tSumTree);
            }
        }
        return sumTrees;
    }

    public static <T extends SumTree> List<SumTree<T>> convertListToTreeDot(List<T> tList) {
        ArrayList<SumTree<T>> sumTrees = new ArrayList<SumTree<T>>();
        if (tList != null && tList.size() > 0) {
            for (int i = 0; i < tList.size(); ++i) {
                SumTree t = (SumTree)tList.get(i);
                if (TreeDotUtils.isTreeDotExist(tList, t.getParentId()).booleanValue()) continue;
                SumTree<SumTree> tSumTree = TreeDotUtils.getTreeDotByT(t, tList);
                sumTrees.add(tSumTree);
            }
        }
        return sumTrees;
    }

    public static <T extends SumTree> List<SumTree<T>> convertListToTreeDotFilter(List<T> tList) {
        ArrayList<SumTree<T>> sumTrees = new ArrayList<SumTree<T>>();
        if (tList != null && tList.size() > 0) {
            for (int i = 0; i < tList.size(); ++i) {
                SumTree<SumTree> tSumTree;
                SumTree t = (SumTree)tList.get(i);
                if (TreeDotUtils.isTreeDotExist(tList, t.getParentId()).booleanValue() || !"-1".equals((tSumTree = TreeDotUtils.getTreeDotByT(t, tList)).getParentId()) && !"0".equals(tSumTree.getParentId())) continue;
                sumTrees.add(tSumTree);
            }
        }
        return sumTrees;
    }

    private static <T extends SumTree> Boolean isTreeDotExist(List<T> tList, String id) {
        for (SumTree t : tList) {
            if (!t.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    private static <T extends SumTree> List<SumTree<T>> getChildTreeDotList(SumTree<T> parentTreeDot, List<T> tList) {
        ArrayList<SumTree<T>> childTreeDotList = new ArrayList<SumTree<T>>();
        List data = tList.stream().filter(t -> parentTreeDot.getId().equals(t.getParentId())).collect(Collectors.toList());
        for (SumTree t2 : data) {
            if (!parentTreeDot.getId().equals(t2.getParentId())) continue;
            SumTree<SumTree> tSumTree = TreeDotUtils.getTreeDotByT(t2, tList);
            childTreeDotList.add(tSumTree);
        }
        return childTreeDotList;
    }

    private static <T extends SumTree> SumTree<T> getTreeDotByT(T t, List<T> tList) {
        Object sumTree;
        List<SumTree<T>> children = TreeDotUtils.getChildTreeDotList(sumTree = t, tList);
        ((SumTree)sumTree).setHasChildren(children.size() != 0);
        if (children.size() == 0) {
            children = null;
        }
        ((SumTree)sumTree).setChildren(children);
        return sumTree;
    }
}

