/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.pool.OracleOCIConnectionPool;

public abstract class OracleOCIConnection
extends T2CConnection {
    OracleOCIConnectionPool ociConnectionPool = null;
    boolean isPool = false;
    boolean aliasing = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Aug_26_08:19:15_PDT_2011";
    public static final boolean TRACE = false;

    public OracleOCIConnection(String string, Properties properties, Object object) throws SQLException {
        this(string, properties, (OracleDriverExtension)object);
    }

    OracleOCIConnection(String string, Properties properties, OracleDriverExtension oracleDriverExtension) throws SQLException {
        super(string, properties, oracleDriverExtension);
    }

    public synchronized byte[] getConnectionId() throws SQLException {
        byte[] byArray = this.t2cGetConnectionId(this.m_nativeState);
        if (byArray == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 254, "Cannot create a ByteArray for the connectionId");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.aliasing = true;
        return byArray;
    }

    public synchronized void passwordChange(String string, String string2, String string3) throws SQLException, IOException {
        this.ociPasswordChange(string, string2, string3);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.lifecycle == 2 || this.lifecycle == 4 || this.aliasing) {
            return;
        }
        super.close();
        this.ociConnectionPool.connectionClosed((oracle.jdbc.oci.OracleOCIConnection)this);
    }

    public synchronized void setConnectionPool(OracleOCIConnectionPool oracleOCIConnectionPool) {
        this.ociConnectionPool = oracleOCIConnectionPool;
    }

    @Override
    public synchronized void setStmtCacheSize(int n2, boolean bl) throws SQLException {
        super.setStmtCacheSize(n2, bl);
    }
}

