/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.assets.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.bringspring.assets.entity.OfFixedAssetsEntity;
import com.bringspring.assets.entity.OfFixedAssetsTypeEntity;
import com.bringspring.assets.exception.ExcelValidationException;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsBatchForm;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsCrForm;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsImportModel;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsImportVO;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsInfoVO;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsListQuery;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsListVO;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsPagination;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsPaginationExportModel;
import com.bringspring.assets.model.fixedassets.OfFixedAssetsUpForm;
import com.bringspring.assets.model.offixedassetsorder.OfFixedAssetsOrderPagination;
import com.bringspring.assets.service.OfFixedAssetsLogsService;
import com.bringspring.assets.service.OfFixedAssetsOrderService;
import com.bringspring.assets.service.OfFixedAssetsService;
import com.bringspring.assets.service.OfFixedAssetsTypeService;
import com.bringspring.assets.util.Constants;
import com.bringspring.assets.util.EnabledMarkEnum;
import com.bringspring.assets.util.FixedAssetsOrderStateEnum;
import com.bringspring.assets.util.QrCodeModel;
import com.bringspring.assets.util.QrCodeTypeEnum;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.ExcelUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.logistics.entity.BasSpaceEntity;
import com.bringspring.logistics.service.BasSpaceService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56fa\u5b9a\u8d44\u4ea7\u5217\u8868"}, value="assets")
@RequestMapping(value={"/api/assets/OfFixedAssets"})
public class OfFixedAssetsController {
    private static final Logger log = LoggerFactory.getLogger(OfFixedAssetsController.class);
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OfFixedAssetsService ofFixedAssetsService;
    @Autowired
    private OfFixedAssetsLogsService ofFixedAssetsLogsService;
    @Autowired
    private BasSpaceService basSpaceService;
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private OfFixedAssetsTypeService ofFixedAssetsTypeService;
    @Autowired
    private UserService userService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private OfFixedAssetsOrderService ofFixedAssetsOrderService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OfFixedAssetsPagination ofFixedAssetsPagination) throws IOException {
        List<OfFixedAssetsEntity> list = this.ofFixedAssetsService.getList(ofFixedAssetsPagination);
        Map<String, EnabledMarkEnum> allToMap = EnabledMarkEnum.getAllToMap();
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsListVO.class);
        for (OfFixedAssetsListVO VO : listVO) {
            BasSpaceEntity basSpace;
            String basSpaceId;
            UserEntity infoUser;
            QrCodeModel qrCodeModel = new QrCodeModel();
            qrCodeModel.setType(QrCodeTypeEnum.FIXED_ASSETS.getType());
            qrCodeModel.setDesc(QrCodeTypeEnum.FIXED_ASSETS.getDesc());
            qrCodeModel.setContent(VO.getCode());
            VO.setQrCodeModel(qrCodeModel);
            VO.setEnabledMarkDesc(StrUtil.isNotBlank((CharSequence)VO.getEnabledMark()) ? allToMap.get(VO.getEnabledMark()).getDesc() : "");
            VO.setInDateFormat(ObjectUtil.isNull((Object)VO.getInDate()) ? null : DateUtil.daFormatYmd((Long)VO.getInDate()));
            VO.setCreatorTimeFormat(ObjectUtil.isNull((Object)VO.getCreatorTime()) ? null : DateUtil.dateFormat((Date)VO.getCreatorTime()));
            VO.setLastModifyTimeFormat(ObjectUtil.isNull((Object)VO.getLastModifyTime()) ? null : DateUtil.dateFormat((Date)VO.getLastModifyTime()));
            VO.setCreatorUser(this.baseDataUtil.userSelectValueNoAccount(VO.getCreatorUserId()));
            VO.setLastModifyUser(this.baseDataUtil.userSelectValueNoAccount(VO.getLastModifyUserId()));
            if (StringUtils.isNotEmpty((String)VO.getBaseUserId()) && ObjectUtil.isNotEmpty((Object)(infoUser = this.userService.getInfo(VO.getBaseUserId())))) {
                VO.setBaseUserName(infoUser.getRealName());
                if (StringUtils.isNotEmpty((String)infoUser.getOrganizeId())) {
                    VO.setBaseOrganizeName(this.baseDataUtil.comSelectValue(infoUser.getOrganizeId(), ""));
                }
            }
            if (StringUtils.isNotEmpty((String)(basSpaceId = VO.getBasSpaceId())) && ObjectUtil.isNotEmpty((Object)(basSpace = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))))) {
                VO.setBasSpaceName(basSpace.getSpaceName());
            }
            VO.setFixedAssetsTypeDesc(((OfFixedAssetsTypeEntity)this.ofFixedAssetsTypeService.getById((Serializable)((Object)VO.getFixedAssetsTypeId()))).getName());
            OrganizeEntity companyInfo = this.organizeService.getInfo(VO.getCompanyId());
            if (ObjectUtil.isEmpty((Object)companyInfo)) continue;
            VO.setCompanyName(companyInfo.getFullName());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ofFixedAssetsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getPreviewList"})
    public ActionResult previewList(@RequestBody OfFixedAssetsPagination ofFixedAssetsPagination) throws IOException {
        List<OfFixedAssetsEntity> list = this.ofFixedAssetsService.getPreviewList(ofFixedAssetsPagination);
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsListVO.class);
        Map<String, EnabledMarkEnum> allToMap = EnabledMarkEnum.getAllToMap();
        Iterator iterator = listVO.iterator();
        while (iterator.hasNext()) {
            BasSpaceEntity basSpace;
            String basSpaceId;
            UserEntity infoUser;
            OfFixedAssetsListVO VO;
            VO.setEnabledMarkDesc(StrUtil.isNotBlank((CharSequence)(VO = (OfFixedAssetsListVO)iterator.next()).getEnabledMark()) ? allToMap.get(VO.getEnabledMark()).getDesc() : "");
            if (StringUtils.isNotEmpty((String)VO.getBaseUserId()) && ObjectUtil.isNotEmpty((Object)(infoUser = this.userService.getInfo(VO.getBaseUserId())))) {
                VO.setBaseUserName(infoUser.getRealName());
                if (StringUtils.isNotEmpty((String)infoUser.getOrganizeId())) {
                    VO.setBaseOrganizeName(this.baseDataUtil.comSelectValue(infoUser.getOrganizeId(), ""));
                }
            }
            if (StringUtils.isNotEmpty((String)(basSpaceId = VO.getBasSpaceId())) && ObjectUtil.isNotEmpty((Object)(basSpace = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))))) {
                VO.setBasSpaceName(basSpace.getSpaceName());
            }
            VO.setFixedAssetsTypeDesc(((OfFixedAssetsTypeEntity)this.ofFixedAssetsTypeService.getById((Serializable)((Object)VO.getFixedAssetsTypeId()))).getName());
            OrganizeEntity companyInfo = this.organizeService.getInfo(VO.getCompanyId());
            if (ObjectUtil.isEmpty((Object)companyInfo)) continue;
            VO.setCompanyName(companyInfo.getFullName());
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ofFixedAssetsPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getEmployeeAssetsList"})
    public ActionResult getEmployeeAssetsList(@RequestBody OfFixedAssetsPagination ofFixedAssetsPagination) throws IOException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((String)ofFixedAssetsPagination.getBaseUserId())) {
            ofFixedAssetsPagination.setBaseUserId(this.userProvider.get().getUserId());
        }
        return this.list(ofFixedAssetsPagination);
    }

    @GetMapping(value={"/getSelectOptionsProjectName"})
    public ActionResult getSelectOptionsProjectName(OfFixedAssetsListQuery ofFixedAssetsListQuery) {
        List<OfFixedAssetsEntity> list = this.ofFixedAssetsService.getSelectOptionsProjectName(ofFixedAssetsListQuery);
        return ActionResult.success(list);
    }

    @GetMapping(value={"/getSelectOptionsRfid"})
    public ActionResult getSelectOptionsRfid(OfFixedAssetsListQuery ofFixedAssetsListQuery) {
        List<OfFixedAssetsEntity> list = this.ofFixedAssetsService.getSelectOptionsRfid(ofFixedAssetsListQuery);
        return ActionResult.success(list);
    }

    @GetMapping(value={"/getSelectOptionsName"})
    public ActionResult getSelectOptionsName(OfFixedAssetsListQuery ofFixedAssetsListQuery) {
        List<OfFixedAssetsEntity> list = this.ofFixedAssetsService.getSelectOptionsName(ofFixedAssetsListQuery);
        return ActionResult.success(list);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid OfFixedAssetsCrForm ofFixedAssetsCrForm) throws DataException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5165\u5e93\u5931\u8d25");
        }
        if (!this.ofFixedAssetsService.checkCodeUnique(ofFixedAssetsCrForm.getCode(), null)) {
            return ActionResult.fail((String)"\u8d44\u4ea7\u7f16\u7801\u51b2\u7a81\uff0c\u5165\u5e93\u5931\u8d25");
        }
        String name = ofFixedAssetsCrForm.getName();
        if (StringUtils.isNotEmpty((String)name) && StringUtils.getLength((String)name) > 14) {
            return ActionResult.fail((String)"\u8d44\u4ea7\u540d\u79f0\u6700\u591a\u4e3a14\u4e2a\u5b57\u8282\uff01");
        }
        String modelNumber = ofFixedAssetsCrForm.getModelNumber();
        if (!StringUtils.isNotEmpty((String)modelNumber) || StringUtils.getLength((String)modelNumber) > 24) {
            // empty if block
        }
        OfFixedAssetsEntity entity = (OfFixedAssetsEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsCrForm, OfFixedAssetsEntity.class);
        this.ofFixedAssetsService.create(entity);
        return ActionResult.success((String)"\u5165\u5e93\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OfFixedAssetsInfoVO> info(@PathVariable(value="id") String id) {
        OfFixedAssetsEntity entity = this.ofFixedAssetsService.getInfo(id);
        OfFixedAssetsInfoVO vo = (OfFixedAssetsInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/infoByCode/{code}"})
    public ActionResult<OfFixedAssetsInfoVO> infoByCode(@PathVariable(value="code") String code) {
        BasSpaceEntity basSpace;
        String basSpaceId;
        UserEntity infoUser;
        OfFixedAssetsEntity entity = this.ofFixedAssetsService.getInfoByCode(code);
        OfFixedAssetsInfoVO vo = (OfFixedAssetsInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsInfoVO.class);
        if (StringUtils.isNotEmpty((String)vo.getBaseUserId()) && ObjectUtil.isNotEmpty((Object)(infoUser = this.userService.getInfo(vo.getBaseUserId())))) {
            vo.setBaseUserName(infoUser.getRealName());
            if (StringUtils.isNotEmpty((String)infoUser.getOrganizeId())) {
                vo.setBaseOrganizeName(this.baseDataUtil.comSelectValue(infoUser.getOrganizeId(), ""));
            }
        }
        if (StringUtils.isNotEmpty((String)(basSpaceId = vo.getBasSpaceId())) && ObjectUtil.isNotEmpty((Object)(basSpace = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))))) {
            vo.setBasSpaceName(basSpace.getSpaceName());
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getFixedAssetsTypeId())) {
            vo.setFixedAssetsTypeName(((OfFixedAssetsTypeEntity)this.ofFixedAssetsTypeService.getById((Serializable)((Object)entity.getFixedAssetsTypeId()))).getName());
        }
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OfFixedAssetsInfoVO> detailInfo(@PathVariable(value="id") String id) {
        BasSpaceEntity basSpace;
        String basSpaceId;
        UserEntity infoUser;
        OfFixedAssetsEntity entity = this.ofFixedAssetsService.getInfo(id);
        OfFixedAssetsInfoVO vo = (OfFixedAssetsInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsInfoVO.class);
        QrCodeModel qrCodeModel = new QrCodeModel();
        qrCodeModel.setType(QrCodeTypeEnum.FIXED_ASSETS.getType());
        qrCodeModel.setDesc(QrCodeTypeEnum.FIXED_ASSETS.getDesc());
        qrCodeModel.setContent(vo.getCode());
        vo.setQrCodeModel(qrCodeModel);
        if (StrUtil.isNotBlank((CharSequence)vo.getEnabledMark())) {
            Map<String, EnabledMarkEnum> allToMap = EnabledMarkEnum.getAllToMap();
            vo.setEnabledMarkDesc(allToMap.get(vo.getEnabledMark()).getDesc());
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getCreatorUserId())) {
            vo.setCreatorUser(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getLastModifyUserId())) {
            vo.setLastModifyUser(this.baseDataUtil.userSelectValueNoAccount(vo.getLastModifyUserId()));
        }
        if (StringUtils.isNotEmpty((String)vo.getBaseUserId()) && ObjectUtil.isNotEmpty((Object)(infoUser = this.userService.getInfo(vo.getBaseUserId())))) {
            vo.setBaseUserName(infoUser.getRealName());
            if (StringUtils.isNotEmpty((String)infoUser.getOrganizeId())) {
                vo.setBaseOrganizeName(this.baseDataUtil.comSelectValue(infoUser.getOrganizeId(), ""));
            }
        }
        if (StringUtils.isNotEmpty((String)(basSpaceId = vo.getBasSpaceId())) && ObjectUtil.isNotEmpty((Object)(basSpace = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))))) {
            vo.setBasSpaceName(basSpace.getSpaceName());
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getFixedAssetsTypeId())) {
            vo.setFixedAssetsTypeName(((OfFixedAssetsTypeEntity)this.ofFixedAssetsTypeService.getById((Serializable)((Object)entity.getFixedAssetsTypeId()))).getName());
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getIsFixedAssets())) {
            vo.setIsFixedAssetsDesc(this.baseDataUtil.getDictName(vo.getIsFixedAssets(), Constants.DICTIONARY_SORT));
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getAccess())) {
            vo.setAccessDesc(this.baseDataUtil.getDictName(vo.getAccess(), Constants.DICTIONARY_ACCESS));
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getAssetPurpose())) {
            vo.setAssetPurposeDesc(this.baseDataUtil.getDictName(vo.getAssetPurpose(), Constants.DICTIONARY_PURPOSE));
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getExpenditureSource())) {
            vo.setExpenditureSourceDesc(this.baseDataUtil.getDictName(vo.getExpenditureSource(), Constants.EXPENDITURE_SOURCE));
        }
        if (StrUtil.isNotBlank((CharSequence)vo.getDepreciationMethod())) {
            vo.setDepreciationMethodDesc(this.baseDataUtil.getDictName(vo.getDepreciationMethod(), Constants.DEPRECIATION_METHOD));
        }
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/batchOut/{ids}"})
    public ActionResult updateBatchOut(@PathVariable(value="ids") String[] ids, @RequestBody @Valid OfFixedAssetsBatchForm ofFixedAssetsBatchForm) throws DataException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5931\u8d25");
        }
        if (ObjectUtil.isEmpty((Object)ids)) {
            return ActionResult.fail((String)"\u65e0\u5f85\u64cd\u4f5c\u8d44\u4ea7\u4fe1\u606f");
        }
        String operationDesc = this.ofFixedAssetsService.updateBatchOut(ids, ofFixedAssetsBatchForm);
        return ActionResult.success((String)operationDesc);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsUpForm ofFixedAssetsUpForm) throws DataException {
        OfFixedAssetsEntity entity;
        String modelNumber;
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5931\u8d25");
        }
        ofFixedAssetsUpForm.setCode(StringUtils.trim((String)ofFixedAssetsUpForm.getCode()));
        if (StringUtils.isEmpty((String)ofFixedAssetsUpForm.getCode())) {
            String code = this.baseDataUtil.getBillNumber(Constants.FIXED_ASSETS_CODE, Boolean.valueOf(false));
            ofFixedAssetsUpForm.setCode(code);
        }
        if (!this.ofFixedAssetsService.checkCodeUnique(ofFixedAssetsUpForm.getCode(), ofFixedAssetsUpForm.getId())) {
            return ActionResult.fail((String)"\u8d44\u4ea7\u7f16\u7801\u51b2\u7a81\uff0c\u5165\u5e93\u5931\u8d25");
        }
        String name = ofFixedAssetsUpForm.getName();
        if (!StringUtils.isNotEmpty((String)name) || StringUtils.getLength((String)name) > 14) {
            // empty if block
        }
        if (!StringUtils.isNotEmpty((String)(modelNumber = ofFixedAssetsUpForm.getModelNumber())) || StringUtils.getLength((String)modelNumber) > 24) {
            // empty if block
        }
        if ((entity = this.ofFixedAssetsService.getInfo(id)) != null) {
            this.ofFixedAssetsService.update(id, entity, ofFixedAssetsUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/giveBack/{id}"})
    public ActionResult giveBack(@PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsUpForm ofFixedAssetsUpForm) throws DataException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5931\u8d25");
        }
        OfFixedAssetsEntity entity = this.ofFixedAssetsService.getInfo(id);
        if (entity != null) {
            this.ofFixedAssetsService.updateByGiveBack(id, entity, ofFixedAssetsUpForm);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/updateUser/{id}"})
    public ActionResult updateUser(@PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsUpForm ofFixedAssetsUpForm) throws DataException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u53d8\u66f4\u9886/\u501f\u7528\u4fe1\u606f\u5931\u8d25");
        }
        OfFixedAssetsEntity entity = this.ofFixedAssetsService.getInfo(id);
        if (entity != null) {
            this.ofFixedAssetsService.updateUser(id, entity, ofFixedAssetsUpForm);
            return ActionResult.success((String)"\u53d8\u66f4\u6210\u529f");
        }
        return ActionResult.fail((String)"\u53d8\u66f4\u5931\u8d25\uff0c\u8d44\u4ea7\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/borrowAssets/{id}"})
    public ActionResult updateBorrow(@PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsUpForm ofFixedAssetsUpForm) throws DataException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u501f\u7528\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25");
        }
        OfFixedAssetsEntity entity = this.ofFixedAssetsService.getInfo(id);
        if (entity != null) {
            this.ofFixedAssetsService.updateBorrow(id, entity, ofFixedAssetsUpForm);
            return ActionResult.success((String)"\u501f\u7528\u4fe1\u606f\u4fdd\u5b58\u6210\u529f");
        }
        return ActionResult.fail((String)"\u501f\u7528\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/binding/{id}"})
    public ActionResult binding(@PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsUpForm ofFixedAssetsUpForm) {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7ed1\u5b9a\u5931\u8d25");
        }
        String rfidDecode = StringUtils.trim((String)ofFixedAssetsUpForm.getRfidDecode());
        if (StringUtils.isEmpty((String)rfidDecode)) {
            return ActionResult.fail((String)"rfid\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ofFixedAssetsUpForm.setRfidDecode(rfidDecode);
        OfFixedAssetsEntity entity = this.ofFixedAssetsService.getInfo(id);
        if (entity != null) {
            try {
                this.ofFixedAssetsService.updateByBinding(id, entity, ofFixedAssetsUpForm);
                return ActionResult.success((String)"\u7ed1\u5b9a\u6210\u529f");
            }
            catch (ExcelValidationException e) {
                return ActionResult.fail((String)e.getErrorMessage());
            }
        }
        return ActionResult.fail((String)"\u7ed1\u5b9a\u5931\u8d25\uff0c\u8d44\u4ea7\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/resetRfidCode/{id}"})
    public ActionResult resetRfidCode(@PathVariable(value="id") String id) throws DataException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u7ed1\u5b9a\u5931\u8d25");
        }
        OfFixedAssetsEntity entity = this.ofFixedAssetsService.getInfo(id);
        if (entity != null) {
            this.ofFixedAssetsService.updateByResetRfid(id, entity);
            return ActionResult.success((String)"\u89e3\u7ed1\u6210\u529f");
        }
        return ActionResult.fail((String)"\u89e3\u7ed1\u5931\u8d25\uff0c\u8d44\u4ea7\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/uploadPhotos/{id}"})
    public ActionResult uploadPhotos(@PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsUpForm ofFixedAssetsUpForm) throws DataException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5931\u8d25");
        }
        OfFixedAssetsEntity entity = this.ofFixedAssetsService.getInfo(id);
        if (entity != null) {
            this.ofFixedAssetsService.updateByUploadPhotos(id, entity, ofFixedAssetsUpForm);
            return ActionResult.success((String)"\u4e0a\u4f20\u6210\u529f");
        }
        return ActionResult.fail((String)"\u4e0a\u4f20\u5931\u8d25\uff0c\u8d44\u4ea7\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @PutMapping(value={"/batchAffirm/{ids}"})
    public ActionResult batchAffirm(@PathVariable String[] ids) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5931\u8d25");
        }
        List<String> idList = Arrays.asList(ids);
        List list = this.ofFixedAssetsService.listByIds(idList);
        if (CollectionUtil.isNotEmpty((Collection)list)) {
            this.ofFixedAssetsService.updateByBatchAffirm(list);
        }
        return ActionResult.success((String)"\u6279\u91cf\u4fe1\u606f\u786e\u8ba4\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5220\u9664\u5931\u8d25");
        }
        if (this.ofFixedAssetsLogsService.selectLogCountByAssetsId(id) > 1L) {
            return ActionResult.fail((String)"\u5b58\u5728\u65e5\u5fd7\u5361\u7247\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        OfFixedAssetsEntity entity = this.ofFixedAssetsService.getInfo(id);
        this.ofFixedAssetsService.delete(entity);
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OfFixedAssetsPaginationExportModel ofFixedAssetsPaginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)ofFixedAssetsPaginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OfFixedAssetsPagination ofFixedAssetsPagination = (OfFixedAssetsPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)ofFixedAssetsPaginationExportModel), OfFixedAssetsPagination.class));
        List<OfFixedAssetsEntity> list = this.ofFixedAssetsService.getTypeList(ofFixedAssetsPagination, ofFixedAssetsPaginationExportModel.getDataType());
        Map<String, EnabledMarkEnum> allToMap = EnabledMarkEnum.getAllToMap();
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsListVO.class);
        for (OfFixedAssetsListVO VO : listVO) {
            BasSpaceEntity basSpace;
            String basSpaceId;
            UserEntity infoUser;
            if (ObjectUtil.isNotEmpty((Object)VO.getEnableDate())) {
                VO.setEnableDateStr(DateUtil.daFormat((Date)VO.getEnableDate()));
            }
            VO.setEnabledMarkDesc(StrUtil.isNotBlank((CharSequence)VO.getEnabledMark()) ? allToMap.get(VO.getEnabledMark()).getDesc() : "");
            VO.setInDateFormat(ObjectUtil.isNull((Object)VO.getInDate()) ? null : DateUtil.daFormatYmd((Long)VO.getInDate()));
            VO.setCreatorTimeFormat(ObjectUtil.isNull((Object)VO.getCreatorTime()) ? null : DateUtil.dateFormat((Date)VO.getCreatorTime()));
            VO.setLastModifyTimeFormat(ObjectUtil.isNull((Object)VO.getLastModifyTime()) ? null : DateUtil.dateFormat((Date)VO.getLastModifyTime()));
            VO.setCreatorUser(this.baseDataUtil.userSelectValueNoAccount(VO.getCreatorUserId()));
            VO.setLastModifyUser(this.baseDataUtil.userSelectValueNoAccount(VO.getLastModifyUserId()));
            if (StringUtils.isNotEmpty((String)VO.getBaseUserId()) && ObjectUtil.isNotEmpty((Object)(infoUser = this.userService.getInfo(VO.getBaseUserId())))) {
                VO.setBaseUserName(infoUser.getRealName());
                if (StringUtils.isNotEmpty((String)infoUser.getOrganizeId())) {
                    VO.setBaseOrganizeName(this.baseDataUtil.comSelectValue(infoUser.getOrganizeId(), ""));
                }
            }
            if (StringUtils.isNotEmpty((String)(basSpaceId = VO.getBasSpaceId())) && ObjectUtil.isNotEmpty((Object)(basSpace = (BasSpaceEntity)this.basSpaceService.getById((Serializable)((Object)basSpaceId))))) {
                VO.setBasSpaceName(basSpace.getSpaceName());
            }
            VO.setFixedAssetsTypeDesc(((OfFixedAssetsTypeEntity)this.ofFixedAssetsTypeService.getById((Serializable)((Object)VO.getFixedAssetsTypeId()))).getName());
            OrganizeEntity companyInfo = this.organizeService.getInfo(VO.getCompanyId());
            if (!ObjectUtil.isEmpty((Object)companyInfo)) {
                VO.setCompanyName(companyInfo.getFullName());
            }
            VO.setInventoryWay("010".equals(VO.getInventoryWay()) ? "\u662f" : "\u5426");
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)ofFixedAssetsPaginationExportModel.getSelectKey()) ? ofFixedAssetsPaginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block48: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "companyName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyName"));
                        continue block48;
                    }
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u7f16\u7801", (Object)"code"));
                        continue block48;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u540d\u79f0", (Object)"name"));
                        continue block48;
                    }
                    case "fixedAssetsTypeDesc": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u7c7b\u578b", (Object)"fixedAssetsTypeDesc"));
                        continue block48;
                    }
                    case "enableDate": {
                        entitys.add(new ExcelExportEntity("\u542f\u7528\u65e5\u671f", (Object)"enableDateStr"));
                        continue block48;
                    }
                    case "unitPrice": {
                        entitys.add(new ExcelExportEntity("\u5355\u4ef7", (Object)"unitPrice"));
                        continue block48;
                    }
                    case "modelNumber": {
                        entitys.add(new ExcelExportEntity("\u54c1\u724c\u578b\u53f7", (Object)"modelNumber"));
                        continue block48;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u89c4\u683c\u63cf\u8ff0", (Object)"description"));
                        continue block48;
                    }
                    case "quantity": {
                        entitys.add(new ExcelExportEntity("\u6570\u91cf", (Object)"quantity"));
                        continue block48;
                    }
                    case "unit": {
                        entitys.add(new ExcelExportEntity("\u8ba1\u91cf\u5355\u4f4d", (Object)"unit"));
                        continue block48;
                    }
                    case "baseUserName": {
                        entitys.add(new ExcelExportEntity("\u9886/\u501f\u7528\u4eba", (Object)"baseUserName"));
                        continue block48;
                    }
                    case "baseOrganizeName": {
                        entitys.add(new ExcelExportEntity("\u9886/\u501f\u7528\u4eba\u90e8\u95e8", (Object)"baseOrganizeName"));
                        continue block48;
                    }
                    case "remark": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"remark"));
                        continue block48;
                    }
                    case "projectName": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u7ec4\u540d\u79f0", (Object)"projectName"));
                        continue block48;
                    }
                    case "basSpaceName": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u7a7a\u95f4", (Object)"basSpaceName"));
                        continue block48;
                    }
                    case "enabledMarkDesc": {
                        entitys.add(new ExcelExportEntity("\u8d44\u4ea7\u72b6\u6001", (Object)"enabledMarkDesc"));
                        continue block48;
                    }
                    case "rfidDecode": {
                        entitys.add(new ExcelExportEntity("RFID\u7f16\u7801", (Object)"rfidDecode"));
                        continue block48;
                    }
                    case "inventoryWay": {
                        entitys.add(new ExcelExportEntity("\u76d8\u70b9\u6807\u8bc6", (Object)"inventoryWay"));
                        continue block48;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8d44\u4ea7\u53f0\u8d26\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8d44\u4ea7\u53f0\u8d26\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u56fa\u5b9a\u8d44\u4ea7\u53f0\u8d26\u4fe1\u606f\u5bfc\u5165\u6a21\u677f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/file/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u56fa\u5b9a\u8d44\u4ea7\u53f0\u8d26\u4fe1\u606f\u5bfc\u5165\u6a21\u677f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u56fa\u5b9a\u8d44\u4ea7\u53f0\u8d26\u4fe1\u606f\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7dExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u5165\u9884\u89c8")
    @GetMapping(value={"/importPreview"})
    public ActionResult ImportPreview(String fileName) {
        String filePath = this.configValueUtil.getTemporaryFilePath();
        File temporary = new File(XSSEscape.escapePath((String)(filePath + fileName)));
        List assetList = ExcelUtil.importExcel((File)temporary, (Integer)0, (Integer)1, OfFixedAssetsImportModel.class);
        Map<String, Object> map = this.ofFixedAssetsService.importPreview(assetList);
        return ActionResult.success(map);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/importData/{menuId}"})
    public ActionResult ImportData(@RequestBody OfFixedAssetsImportModel data, @PathVariable(value="menuId") String menuId) {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u5bfc\u5165\u5931\u8d25");
        }
        List dataList = JsonUtil.getJsonToList(data.getList(), OfFixedAssetsImportModel.class);
        try {
            OfFixedAssetsImportVO result = this.ofFixedAssetsService.importData(dataList, menuId);
            return ActionResult.success((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ActionResult.fail((String)("\u5bfc\u5165\u5931\u8d25:" + e.getMessage()));
        }
    }

    @ApiOperation(value="\u95e8\u6237\u9762\u677f\u6570\u636e\u96c6")
    @PostMapping(value={"/portalPanelData"})
    public ActionResult portalPanelData(@RequestBody OfFixedAssetsPagination ofFixedAssetsPagination) {
        String menuId = ofFixedAssetsPagination.getMenuId();
        String companyId = ofFixedAssetsPagination.getCompanyId();
        String isFixedAssets = ofFixedAssetsPagination.getIsFixedAssets();
        if (StringUtils.isEmpty((String)menuId) || StringUtils.isEmpty((String)companyId) || StringUtils.isEmpty((String)isFixedAssets)) {
            return ActionResult.fail((String)"\u83dc\u5355id\u3001\u516c\u53f8id\u3001\u53f0\u8d26\u5206\u7c7b\u5747\u4e0d\u53ef\u4e3a\u7a7a");
        }
        ActionResult result = new ActionResult();
        HashMap<String, Number> data = new HashMap<String, Number>();
        long assetsCount = this.ofFixedAssetsService.selectAssetsCount(ofFixedAssetsPagination);
        data.put("assetsCount", assetsCount);
        double priceSum = this.ofFixedAssetsService.selectAssetsPriceSum(menuId, companyId, isFixedAssets);
        data.put("priceSum", priceSum);
        int quantitySum = this.ofFixedAssetsService.selectAssetsQuantitySum(menuId, companyId, isFixedAssets);
        data.put("quantitySum", quantitySum);
        long assetsRfidCount = this.ofFixedAssetsService.selectAssetsBindingRfidCount(menuId, companyId, isFixedAssets);
        data.put("assetsRfidCount", assetsRfidCount);
        List<OfFixedAssetsEntity> list = this.ofFixedAssetsService.selectAssetsBorrowExpire(menuId, companyId, isFixedAssets, false);
        data.put("assetsBorrowExpireCount", CollectionUtil.isNotEmpty(list) ? list.size() : 0);
        OfFixedAssetsOrderPagination pagination = new OfFixedAssetsOrderPagination();
        pagination.setMenuId(menuId);
        pagination.setCompanyId(companyId);
        pagination.setAssetsSorts(isFixedAssets);
        Integer[] orderStates = new Integer[]{FixedAssetsOrderStateEnum.CHECK_NO_START.getState(), FixedAssetsOrderStateEnum.CHECK_ING.getState()};
        pagination.setOrderStates(orderStates);
        long assetsOrderCount = this.ofFixedAssetsOrderService.selectAssetsOrderCount(pagination);
        data.put("assetsOrderCount", assetsOrderCount);
        result.setData(data);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @ApiOperation(value="\u7edf\u8ba1\u8d44\u4ea7\u603b\u6570\u91cf")
    @GetMapping(value={"/countAssetsNum/{menuId}/{companyId}/{isFixedAssets}"})
    public ActionResult countAssetsNum(@PathVariable(value="menuId") String menuId, @PathVariable(value="companyId") String companyId, @PathVariable(value="isFixedAssets") String isFixedAssets) {
        ActionResult result = new ActionResult();
        OfFixedAssetsPagination ofFixedAssetsPagination = new OfFixedAssetsPagination();
        ofFixedAssetsPagination.setMenuId(menuId);
        ofFixedAssetsPagination.setCompanyId(companyId);
        ofFixedAssetsPagination.setIsFixedAssets(isFixedAssets);
        long assetsCount = this.ofFixedAssetsService.selectAssetsCount(ofFixedAssetsPagination);
        result.setData((Object)assetsCount);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @ApiOperation(value="\u6c42\u548c\u8d44\u4ea7\u603b\u4ef7\u503c")
    @GetMapping(value={"/countAssetsPriceSum/{menuId}/{companyId}/{isFixedAssets}"})
    public ActionResult countAssetsPriceSum(@PathVariable(value="menuId") String menuId, @PathVariable(value="companyId") String companyId, @PathVariable(value="isFixedAssets") String isFixedAssets) {
        ActionResult result = new ActionResult();
        double priceSum = this.ofFixedAssetsService.selectAssetsPriceSum(menuId, companyId, isFixedAssets);
        result.setData((Object)priceSum);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @ApiOperation(value="\u6c42\u548c\u8d44\u4ea7\u6570\u91cf")
    @GetMapping(value={"/countAssetsQuantitySum/{menuId}/{companyId}/{isFixedAssets}"})
    public ActionResult countAssetsQuantitySum(@PathVariable(value="menuId") String menuId, @PathVariable(value="companyId") String companyId, @PathVariable(value="isFixedAssets") String isFixedAssets) {
        ActionResult result = new ActionResult();
        int quantitySum = this.ofFixedAssetsService.selectAssetsQuantitySum(menuId, companyId, isFixedAssets);
        result.setData((Object)quantitySum);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @ApiOperation(value="\u7edf\u8ba1\u7ed1\u5b9aRFID\u7684\u8d44\u4ea7\u6570\u91cf")
    @GetMapping(value={"/countBindingRfid/{menuId}/{companyId}/{isFixedAssets}"})
    public ActionResult countBindingRfid(@PathVariable(value="menuId") String menuId, @PathVariable(value="companyId") String companyId, @PathVariable(value="isFixedAssets") String isFixedAssets) {
        ActionResult result = new ActionResult();
        long assetsCount = this.ofFixedAssetsService.selectAssetsBindingRfidCount(menuId, companyId, isFixedAssets);
        result.setData((Object)assetsCount);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @ApiOperation(value="\u67e5\u8be2\u501f\u7528\u9884\u8ba1\u5f52\u8fd8\u65e5\u671f\u5230\u671f")
    @GetMapping(value={"/countBorrowExpire/{menuId}/{companyId}/{isFixedAssets}"})
    public ActionResult countBorrowExpire(@PathVariable(value="menuId") String menuId, @PathVariable(value="companyId") String companyId, @PathVariable(value="isFixedAssets") String isFixedAssets) {
        ActionResult result = new ActionResult();
        List<OfFixedAssetsEntity> list = this.ofFixedAssetsService.selectAssetsBorrowExpire(menuId, companyId, isFixedAssets, false);
        long assetsCount = list != null ? (long)list.size() : 0L;
        result.setData((Object)assetsCount);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @ApiOperation(value="\u6309\u7a7a\u95f4\u6c42\u548c\u8d44\u4ea7\u4ef7\u503c")
    @GetMapping(value={"/countPriceSumGroupBySpace/{menuId}/{companyId}/{isFixedAssets}"})
    public ActionResult countPriceSumGroupBySpace(@PathVariable(value="menuId") String menuId, @PathVariable(value="companyId") String companyId, @PathVariable(value="isFixedAssets") String isFixedAssets) {
        ActionResult result = new ActionResult();
        List<Map<String, Object>> maps = this.ofFixedAssetsService.selectPriceSumGroupBySpace(menuId, companyId, isFixedAssets);
        result.setData(maps);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @ApiOperation(value="\u6211\u7684\u8d44\u4ea7")
    @GetMapping(value={"/countPriceSumForMy/{menuId}/{userId}"})
    public ActionResult countPriceSumForMy(@PathVariable(value="menuId") String menuId, @PathVariable(value="userId") String userId) {
        if (StringUtils.isEmpty((String)userId)) {
            UserInfo userInfo = this.userProvider.get();
            if (ObjectUtil.isEmpty((Object)userInfo)) {
                return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a");
            }
            userId = userInfo.getUserId();
        }
        ActionResult result = new ActionResult();
        List<Map<String, Object>> maps = this.ofFixedAssetsService.selectEmployeeAssets(userId, menuId);
        result.setData(maps);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @ApiOperation(value="\u6309\u7a7a\u95f4\u7edf\u8ba1\u8d44\u4ea7\u6570\u91cf")
    @GetMapping(value={"/countNumGroupBySpace/{menuId}/{companyId}/{isFixedAssets}"})
    public ActionResult countNumGroupBySpace(@PathVariable(value="menuId") String menuId, @PathVariable(value="companyId") String companyId, @PathVariable(value="isFixedAssets") String isFixedAssets) {
        ActionResult result = new ActionResult();
        List<Map<String, Object>> maps = this.ofFixedAssetsService.selectNumGroupBySpace(menuId, companyId, isFixedAssets);
        result.setData(maps);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }

    @ApiOperation(value="\u6309\u72b6\u6001\u5206\u7c7b\u7edf\u8ba1")
    @GetMapping(value={"/countGroupByEnabledMark/{menuId}/{companyId}/{isFixedAssets}"})
    public ActionResult countGroupByEnabledMark(@PathVariable(value="menuId") String menuId, @PathVariable(value="companyId") String companyId, @PathVariable(value="isFixedAssets") String isFixedAssets) {
        ActionResult result = new ActionResult();
        List<Map<String, Object>> maps = this.ofFixedAssetsService.selectGroupByEnabledMark(menuId, companyId, isFixedAssets);
        if (maps != null && maps.size() != 0) {
            for (Map<String, Object> item : maps) {
                String enabled_mark = String.valueOf(item.get("enabled_mark"));
                String dicName = this.baseDataUtil.getDictName(enabled_mark, Constants.DICTIONARY_TYPE);
                item.put("dicName", dicName);
            }
        }
        result.setData(maps);
        result.setCode(Integer.valueOf(200));
        result.setMsg(MsgCode.SU000.get());
        return result;
    }
}

