/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.assets.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.afterturn.easypoi.excel.entity.params.ExcelExportEntity;
import cn.hutool.core.util.ObjectUtil;
import com.bringspring.assets.entity.OfFixedAssetsDepreciationEntity;
import com.bringspring.assets.entity.OfFixedAssetsEntity;
import com.bringspring.assets.model.offixedassetsdepreciation.OfFixedAssetsDepreciationCrForm;
import com.bringspring.assets.model.offixedassetsdepreciation.OfFixedAssetsDepreciationInfoVO;
import com.bringspring.assets.model.offixedassetsdepreciation.OfFixedAssetsDepreciationListQuery;
import com.bringspring.assets.model.offixedassetsdepreciation.OfFixedAssetsDepreciationListVO;
import com.bringspring.assets.model.offixedassetsdepreciation.OfFixedAssetsDepreciationPagination;
import com.bringspring.assets.model.offixedassetsdepreciation.OfFixedAssetsDepreciationPaginationExportModel;
import com.bringspring.assets.model.offixedassetsdepreciation.OfFixedAssetsDepreciationResultVO;
import com.bringspring.assets.model.offixedassetsdepreciation.OfFixedAssetsDepreciationUpForm;
import com.bringspring.assets.service.OfFixedAssetsDepreciationService;
import com.bringspring.assets.service.OfFixedAssetsService;
import com.bringspring.assets.util.Constants;
import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.DownloadVO;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UploaderUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.XSSEscape;
import com.bringspring.common.util.file.UploadUtil;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u56fa\u5b9a\u8d44\u4ea7\u6298\u65e7\u65b9\u6848"}, value="assets")
@RequestMapping(value={"/api/assets/OfFixedAssetsDepreciation"})
public class OfFixedAssetsDepreciationController {
    private static final Logger log = LoggerFactory.getLogger(OfFixedAssetsDepreciationController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private OfFixedAssetsDepreciationService ofFixedAssetsDepreciationService;
    @Autowired
    private OfFixedAssetsService ofFixedAssetsService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody OfFixedAssetsDepreciationPagination ofFixedAssetsDepreciationPagination) throws IOException {
        List<OfFixedAssetsDepreciationEntity> list = this.ofFixedAssetsDepreciationService.getList(ofFixedAssetsDepreciationPagination);
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsDepreciationListVO.class);
        for (OfFixedAssetsDepreciationListVO vo : listVO) {
            vo.setDepreciationMethod(this.baseDataUtil.getDictName(vo.getDepreciationMethod(), Constants.DEPRECIATION_METHOD));
            vo.setFirstDepreciationMethod(this.baseDataUtil.getDictName(vo.getFirstDepreciationMethod(), Constants.DEPRECIATION_METHOD));
            vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "1", "0"));
            vo.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
            vo.setLastModifyUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getLastModifyUserId()));
            vo.setCompanyName(this.baseDataUtil.comSelectValue(vo.getCompanyId(), "last"));
        }
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)((Object)ofFixedAssetsDepreciationPagination), PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping(value={"/getListAll"})
    public ActionResult list(@RequestBody OfFixedAssetsDepreciationListQuery ofFixedAssetsDepreciationListQuery) throws IOException {
        List<OfFixedAssetsDepreciationEntity> list = this.ofFixedAssetsDepreciationService.getListAll(ofFixedAssetsDepreciationListQuery);
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsDepreciationListVO.class);
        for (OfFixedAssetsDepreciationListVO vo : listVO) {
            vo.setDepreciationMethod(this.baseDataUtil.getDictName(vo.getDepreciationMethod(), Constants.DEPRECIATION_METHOD));
            vo.setFirstDepreciationMethod(this.baseDataUtil.getDictName(vo.getFirstDepreciationMethod(), Constants.DEPRECIATION_METHOD));
            vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "1", "0"));
            vo.setCreatorUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getCreatorUserId()));
            vo.setLastModifyUserName(this.baseDataUtil.userSelectValueNoAccount(vo.getLastModifyUserId()));
            vo.setCompanyName(this.baseDataUtil.comSelectValue(vo.getCompanyId(), "last"));
        }
        return ActionResult.success(list);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid OfFixedAssetsDepreciationCrForm ofFixedAssetsDepreciationCrForm) throws DataException {
        if (ObjectUtil.isEmpty((Object)this.userProvider.get())) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u521b\u5efa\u5931\u8d25");
        }
        OfFixedAssetsDepreciationEntity entity = (OfFixedAssetsDepreciationEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsDepreciationCrForm, OfFixedAssetsDepreciationEntity.class);
        this.ofFixedAssetsDepreciationService.create(entity);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @ApiOperation(value="\u6a21\u677f\u4e0b\u8f7d")
    @GetMapping(value={"/templateDownload"})
    public ActionResult<DownloadVO> TemplateDownload() {
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = DownloadVO.builder().build();
        try {
            vo.setName("\u804c\u5458\u4fe1\u606f.xlsx");
            vo.setUrl(UploaderUtil.uploaderFile((String)"/api/Common/DownloadModel?encryption=", (String)(userInfo.getId() + "#\u804c\u5458\u4fe1\u606f.xlsx#Temporary")));
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
        }
        return ActionResult.success((Object)vo);
    }

    @ApiOperation(value="\u5bfc\u51faExcel")
    @GetMapping(value={"/Actions/Export"})
    public ActionResult Export(OfFixedAssetsDepreciationPaginationExportModel paginationExportModel) throws IOException {
        if (StringUtils.isEmpty((String)paginationExportModel.getSelectKey())) {
            return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5bfc\u51fa\u5b57\u6bb5");
        }
        OfFixedAssetsDepreciationPagination pagination = (OfFixedAssetsDepreciationPagination)((Object)JsonUtil.getJsonToBean((Object)((Object)paginationExportModel), OfFixedAssetsDepreciationPagination.class));
        List<OfFixedAssetsDepreciationEntity> list = this.ofFixedAssetsDepreciationService.getTypeList(pagination, paginationExportModel.getDataType());
        List listVO = JsonUtil.getJsonToList(list, OfFixedAssetsDepreciationListVO.class);
        for (OfFixedAssetsDepreciationListVO VO : listVO) {
            VO.setDepreciationMethod(this.baseDataUtil.getDictName(VO.getDepreciationMethod(), Constants.DEPRECIATION_METHOD));
            VO.setFirstDepreciationMethod(this.baseDataUtil.getDictName(VO.getFirstDepreciationMethod(), Constants.DEPRECIATION_METHOD));
            VO.setEnabledMark(this.baseDataUtil.switchSelectValue(VO.getEnabledMark(), "1", "0"));
            VO.setCreatorUserId(this.baseDataUtil.userSelectValue(VO.getCreatorUserId()));
            VO.setLastModifyUserId(this.baseDataUtil.userSelectValue(VO.getLastModifyUserId()));
            VO.setCompanyId(this.baseDataUtil.comSelectValue(VO.getCompanyId(), "last"));
        }
        List mapList = JsonUtil.getJsonToListMap((String)JsonUtil.getObjectToStringDateFormat((Object)listVO, (String)"yyyy-MM-dd HH:mm:ss"));
        String[] keys = !StringUtils.isEmpty((String)paginationExportModel.getSelectKey()) ? paginationExportModel.getSelectKey().split(",") : new String[]{};
        UserInfo userInfo = this.userProvider.get();
        DownloadVO vo = this.creatModelExcel(this.configValueUtil.getTemporaryFilePath(), mapList, keys, userInfo);
        return ActionResult.success((Object)vo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadVO creatModelExcel(String path, List<Map<String, Object>> list, String[] keys, UserInfo userInfo) {
        DownloadVO vo = DownloadVO.builder().build();
        ArrayList<ExcelExportEntity> entitys = new ArrayList<ExcelExportEntity>();
        if (keys.length > 0) {
            String[] stringArray = keys;
            int n = stringArray.length;
            block42: for (int i = 0; i < n; ++i) {
                String key;
                switch (key = stringArray[i]) {
                    case "code": {
                        entitys.add(new ExcelExportEntity("\u7f16\u7801", (Object)"code"));
                        continue block42;
                    }
                    case "name": {
                        entitys.add(new ExcelExportEntity("\u6298\u65e7\u65b9\u6848", (Object)"name"));
                        continue block42;
                    }
                    case "depreciationLife": {
                        entitys.add(new ExcelExportEntity("\u6298\u65e7\u5e74\u9650", (Object)"depreciationLife"));
                        continue block42;
                    }
                    case "depreciationMethod": {
                        entitys.add(new ExcelExportEntity("\u6298\u65e7\u65b9\u6cd5", (Object)"depreciationMethod"));
                        continue block42;
                    }
                    case "residualRatio": {
                        entitys.add(new ExcelExportEntity("\u6b8b\u503c\u7387", (Object)"residualRatio"));
                        continue block42;
                    }
                    case "residualValueSelect": {
                        entitys.add(new ExcelExportEntity("\u6b8b\u503c\u9009\u62e9", (Object)"residualValueSelect"));
                        continue block42;
                    }
                    case "firstDepreciationMethod": {
                        entitys.add(new ExcelExportEntity("\u9996\u6b21\u6298\u65e7\u65b9\u5f0f", (Object)"firstDepreciationMethod"));
                        continue block42;
                    }
                    case "enabledMark": {
                        entitys.add(new ExcelExportEntity("\u6709\u6548\u6807\u5fd7", (Object)"enabledMark"));
                        continue block42;
                    }
                    case "description": {
                        entitys.add(new ExcelExportEntity("\u5907\u6ce8", (Object)"description"));
                        continue block42;
                    }
                    case "creatorUserId": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u7528\u6237", (Object)"creatorUserId"));
                        continue block42;
                    }
                    case "creatorTime": {
                        entitys.add(new ExcelExportEntity("\u521b\u5efa\u65f6\u95f4", (Object)"creatorTime"));
                        continue block42;
                    }
                    case "lastModifyUserId": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u7528\u6237", (Object)"lastModifyUserId"));
                        continue block42;
                    }
                    case "lastModifyTime": {
                        entitys.add(new ExcelExportEntity("\u4fee\u6539\u65f6\u95f4", (Object)"lastModifyTime"));
                        continue block42;
                    }
                    case "companyId": {
                        entitys.add(new ExcelExportEntity("\u6240\u5c5e\u516c\u53f8", (Object)"companyId"));
                        continue block42;
                    }
                    case "version": {
                        entitys.add(new ExcelExportEntity("\u7248\u672c\u53f7", (Object)"version"));
                        continue block42;
                    }
                }
            }
        }
        ExportParams exportParams = new ExportParams(null, "\u8868\u5355\u4fe1\u606f");
        exportParams.setType(ExcelType.XSSF);
        try {
            HSSFWorkbook workbook = new HSSFWorkbook();
            try {
                if (entitys.size() > 0) {
                    workbook = ExcelExportUtil.exportExcel((ExportParams)exportParams, entitys, list);
                }
                String name = "\u8868\u5355\u4fe1\u606f" + DateUtil.dateNow((String)"yyyyMMdd") + "_" + RandomUtil.uuId() + ".xlsx";
                String fileName = this.configValueUtil.getTemporaryFilePath() + name;
                FileOutputStream output = new FileOutputStream(XSSEscape.escapePath((String)fileName));
                try {
                    workbook.write((OutputStream)output);
                    UploadUtil.uploadFile((String)this.configValueUtil.getFileType(), (String)fileName, (String)"temporary", (String)name);
                    vo.setName(name);
                    vo.setUrl(UploaderUtil.uploaderFile((String)(userInfo.getId() + "#" + name + "#Temporary")));
                }
                finally {
                    if (Collections.singletonList(output).get(0) != null) {
                        output.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(workbook).get(0) != null) {
                    workbook.close();
                }
            }
        }
        catch (Exception e) {
            log.error("\u4fe1\u606f\u5bfc\u51faExcel\u9519\u8bef:{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return vo;
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<OfFixedAssetsDepreciationInfoVO> info(@PathVariable(value="id") String id) {
        OfFixedAssetsDepreciationEntity entity = this.ofFixedAssetsDepreciationService.getInfo(id);
        OfFixedAssetsDepreciationInfoVO vo = (OfFixedAssetsDepreciationInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsDepreciationInfoVO.class);
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        if (vo.getCreatorTime() != null) {
            vo.setCreatorTime(vo.getCreatorTime());
        }
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        if (vo.getLastModifyTime() != null) {
            vo.setLastModifyTime(vo.getLastModifyTime());
        }
        vo.setCompanyId(this.baseDataUtil.comSelectValue(vo.getCompanyId(), "last"));
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<OfFixedAssetsDepreciationInfoVO> detailInfo(@PathVariable(value="id") String id) {
        OfFixedAssetsDepreciationEntity entity = this.ofFixedAssetsDepreciationService.getInfo(id);
        OfFixedAssetsDepreciationInfoVO vo = (OfFixedAssetsDepreciationInfoVO)JsonUtil.getJsonToBean((Object)entity, OfFixedAssetsDepreciationInfoVO.class);
        vo.setDepreciationMethod(this.baseDataUtil.getDictName(vo.getDepreciationMethod(), Constants.DEPRECIATION_METHOD));
        vo.setFirstDepreciationMethod(this.baseDataUtil.getDictName(vo.getFirstDepreciationMethod(), Constants.DEPRECIATION_METHOD));
        vo.setEnabledMark(this.baseDataUtil.switchSelectValue(vo.getEnabledMark(), "1", "0"));
        vo.setCreatorUserId(this.baseDataUtil.userSelectValue(vo.getCreatorUserId()));
        vo.setLastModifyUserId(this.baseDataUtil.userSelectValue(vo.getLastModifyUserId()));
        vo.setCompanyId(this.baseDataUtil.comSelectValue(vo.getCompanyId(), "last"));
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid OfFixedAssetsDepreciationUpForm ofFixedAssetsDepreciationUpForm) throws DataException {
        UserInfo userInfo = this.userProvider.get();
        if (ObjectUtil.isEmpty((Object)userInfo)) {
            return ActionResult.fail((String)"\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u4e3a\u7a7a\uff0c\u66f4\u65b0\u5931\u8d25");
        }
        OfFixedAssetsDepreciationEntity entity = this.ofFixedAssetsDepreciationService.getInfo(id);
        if (entity != null) {
            ofFixedAssetsDepreciationUpForm.setCompanyId(entity.getCompanyId());
            OfFixedAssetsDepreciationEntity subentity = (OfFixedAssetsDepreciationEntity)JsonUtil.getJsonToBean((Object)ofFixedAssetsDepreciationUpForm, OfFixedAssetsDepreciationEntity.class);
            subentity.setCreatorUserId(entity.getCreatorUserId());
            subentity.setCreatorTime(entity.getCreatorTime());
            this.ofFixedAssetsDepreciationService.update(id, subentity);
            return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
        }
        return ActionResult.fail((String)"\u66f4\u65b0\u5931\u8d25\uff0c\u6570\u636e\u4e0d\u5b58\u5728");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        OfFixedAssetsDepreciationEntity entity = this.ofFixedAssetsDepreciationService.getInfo(id);
        if (entity != null) {
            this.ofFixedAssetsDepreciationService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/batchRemove/{ids}"})
    public ActionResult batchRemove(@PathVariable(value="ids") String ids) {
        if (StringUtils.isNotEmpty((String)ids)) {
            this.ofFixedAssetsDepreciationService.delete(ids);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/calculate/{id}/{assetsId}"})
    public ActionResult calculateResult(@PathVariable(value="id") String id, @PathVariable(value="assetsId") String assetsId) {
        if (StringUtils.isNotEmpty((String)id) && StringUtils.isNotEmpty((String)assetsId)) {
            OfFixedAssetsEntity info = this.ofFixedAssetsService.getInfo(assetsId);
            OfFixedAssetsDepreciationEntity info1 = this.ofFixedAssetsDepreciationService.getInfo(id);
            if (info != null && info1 != null) {
                Double unitPrice = info.getUnitPrice();
                Date enableDate = info.getEnableDate();
                String depreciationLife = info1.getDepreciationLife();
                BigDecimal residualRatio = info1.getResidualRatio();
                if (unitPrice != null && StringUtils.isNotEmpty((String)depreciationLife) && residualRatio != null) {
                    int len = Integer.valueOf(depreciationLife);
                    BigDecimal i = BigDecimal.valueOf(len);
                    BigDecimal one = BigDecimal.ONE;
                    BigDecimal s = one.subtract(residualRatio);
                    BigDecimal d = s.divide(i, 2);
                    BigDecimal p = BigDecimal.valueOf(unitPrice);
                    BigDecimal m = s.multiply(p).divide(i, 2);
                    if (enableDate != null) {
                        ArrayList<OfFixedAssetsDepreciationResultVO> list = new ArrayList<OfFixedAssetsDepreciationResultVO>();
                        for (int j = 0; j < len; ++j) {
                            int years = j + 1;
                            OfFixedAssetsDepreciationResultVO vo = new OfFixedAssetsDepreciationResultVO();
                            Date date = DateUtil.dateAddYears((Date)enableDate, (int)years);
                            vo.setDepreciationDate(DateUtil.daFormat((Date)date));
                            vo.setAssetsId(assetsId);
                            vo.setDepreciationId(id);
                            vo.setAnnualDepreciation(m);
                            vo.setAnnualDepreciationRate(d);
                            vo.setNetWorth(p.subtract(m.multiply(BigDecimal.valueOf(years))));
                            list.add(vo);
                        }
                        return ActionResult.success(list);
                    }
                    return ActionResult.fail((String)"\u8d44\u4ea7\u542f\u7528\u65e5\u671f\u4e3a\u7a7a");
                }
                return ActionResult.fail((String)"\u5355\u4ef7\u4e3a\u7a7a\u6216\u6298\u65e7\u6a21\u677f\u6709\u8bef");
            }
            return ActionResult.fail((String)"\u6298\u65e7\u6a21\u677f\u6216\u8d44\u4ea7\u53f0\u8d26\u4e0d\u5b58\u5728");
        }
        return ActionResult.fail((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u6298\u65e7\u6a21\u677f\u548c\u56fa\u5b9a\u8d44\u4ea7\u53f0\u8d26");
    }
}

