/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.assets.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bringspring.assets.entity.OfFixedAssetsLogsEntity;
import com.bringspring.assets.mapper.OfFixedAssetsLogsMapper;
import com.bringspring.assets.model.offixedassetslogs.OfFixedAssetsLogsPagination;
import com.bringspring.assets.service.OfFixedAssetsLogsService;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.model.authorize.AuthorizeConditionModel;
import com.bringspring.system.permission.service.AuthorizeService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OfFixedAssetsLogsServiceImpl
extends ServiceImpl<OfFixedAssetsLogsMapper, OfFixedAssetsLogsEntity>
implements OfFixedAssetsLogsService {
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private AuthorizeService authorizeService;

    @Override
    public List<OfFixedAssetsLogsEntity> getList(OfFixedAssetsLogsPagination pagination) {
        Long sec;
        Long fir;
        Object ofFixedAssetsLogsObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ofFixedAssetsLogsNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsLogsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets_logs"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsLogsObj)) {
                return new ArrayList<OfFixedAssetsLogsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsLogsObj;
            ++ofFixedAssetsLogsNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsLogsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets_logs"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsLogsObj)) {
                return new ArrayList<OfFixedAssetsLogsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsLogsObj;
            ++ofFixedAssetsLogsNum;
        }
        if (StringUtils.isNotEmpty((String)pagination.getFixedAssetsId())) {
            ++ofFixedAssetsLogsNum;
            queryWrapper.lambda().like(OfFixedAssetsLogsEntity::getFixedAssetsId, (Object)pagination.getFixedAssetsId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getNewValue())) {
            ++ofFixedAssetsLogsNum;
            queryWrapper.lambda().like(OfFixedAssetsLogsEntity::getNewValue, (Object)pagination.getNewValue());
        }
        if (StringUtils.isNotEmpty((String)pagination.getOldValue())) {
            ++ofFixedAssetsLogsNum;
            queryWrapper.lambda().like(OfFixedAssetsLogsEntity::getOldValue, (Object)pagination.getOldValue());
        }
        if (StringUtils.isNotEmpty((String)pagination.getDescription())) {
            ++ofFixedAssetsLogsNum;
            queryWrapper.lambda().like(OfFixedAssetsLogsEntity::getDescription, (Object)pagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCreatorUserId())) {
            ++ofFixedAssetsLogsNum;
            queryWrapper.lambda().like(OfFixedAssetsLogsEntity::getCreatorUserId, (Object)pagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty(pagination.getCreatorTime())) {
            ++ofFixedAssetsLogsNum;
            List<String> CreatorTimeList = pagination.getCreatorTime();
            fir = Long.valueOf(CreatorTimeList.get(0));
            sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(OfFixedAssetsLogsEntity::getCreatorTime, (Object)new Date(fir))).le(OfFixedAssetsLogsEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)pagination.getLastModifyUserId())) {
            ++ofFixedAssetsLogsNum;
            queryWrapper.lambda().like(OfFixedAssetsLogsEntity::getLastModifyUserId, (Object)pagination.getLastModifyUserId());
        }
        if (StringUtils.isNotEmpty(pagination.getLastModifyTime())) {
            ++ofFixedAssetsLogsNum;
            List<String> LastModifyTimeList = pagination.getLastModifyTime();
            fir = Long.valueOf(LastModifyTimeList.get(0));
            sec = Long.valueOf(LastModifyTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(OfFixedAssetsLogsEntity::getLastModifyTime, (Object)new Date(fir))).le(OfFixedAssetsLogsEntity::getLastModifyTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(OfFixedAssetsLogsEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(OfFixedAssetsLogsEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                OfFixedAssetsLogsEntity ofFixedAssetsLogsEntity = new OfFixedAssetsLogsEntity();
                Field declaredField = ofFixedAssetsLogsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (total > 0 && AllIdList.size() > 0 || total == 0) {
            Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
            IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
            return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
        }
        ArrayList list = new ArrayList();
        return pagination.setData(list, list.size());
    }

    @Override
    public List<OfFixedAssetsLogsEntity> getTypeList(OfFixedAssetsLogsPagination pagination, String dataType) {
        Long sec;
        Long fir;
        Object ofFixedAssetsLogsObj;
        String userId = this.userProvider.get().getUserId();
        ArrayList AllIdList = new ArrayList();
        int total = 0;
        int ofFixedAssetsLogsNum = 0;
        QueryWrapper queryWrapper = new QueryWrapper();
        boolean pcPermission = false;
        boolean appPermission = false;
        boolean isPc = ServletUtils.getHeader((String)"jsbos-origin").equals("pc");
        if (isPc && pcPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsLogsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsLogsObj)) {
                return new ArrayList<OfFixedAssetsLogsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsLogsObj;
            ++ofFixedAssetsLogsNum;
        }
        if (!isPc && appPermission && !this.userProvider.get().getIsAdministrator().booleanValue()) {
            ofFixedAssetsLogsObj = this.authorizeService.getCondition(new AuthorizeConditionModel(queryWrapper, pagination.getMenuId(), "of_fixed_assets"));
            if (ObjectUtil.isEmpty((Object)ofFixedAssetsLogsObj)) {
                return new ArrayList<OfFixedAssetsLogsEntity>();
            }
            queryWrapper = (QueryWrapper)ofFixedAssetsLogsObj;
            ++ofFixedAssetsLogsNum;
        }
        if (StringUtils.isNotEmpty((String)pagination.getFixedAssetsId())) {
            ++ofFixedAssetsLogsNum;
            queryWrapper.lambda().like(OfFixedAssetsLogsEntity::getFixedAssetsId, (Object)pagination.getFixedAssetsId());
        }
        if (StringUtils.isNotEmpty((String)pagination.getNewValue())) {
            ++ofFixedAssetsLogsNum;
            queryWrapper.lambda().like(OfFixedAssetsLogsEntity::getNewValue, (Object)pagination.getNewValue());
        }
        if (StringUtils.isNotEmpty((String)pagination.getOldValue())) {
            ++ofFixedAssetsLogsNum;
            queryWrapper.lambda().like(OfFixedAssetsLogsEntity::getOldValue, (Object)pagination.getOldValue());
        }
        if (StringUtils.isNotEmpty((String)pagination.getDescription())) {
            ++ofFixedAssetsLogsNum;
            queryWrapper.lambda().like(OfFixedAssetsLogsEntity::getDescription, (Object)pagination.getDescription());
        }
        if (StringUtils.isNotEmpty((String)pagination.getCreatorUserId())) {
            ++ofFixedAssetsLogsNum;
            queryWrapper.lambda().like(OfFixedAssetsLogsEntity::getCreatorUserId, (Object)pagination.getCreatorUserId());
        }
        if (StringUtils.isNotEmpty(pagination.getCreatorTime())) {
            ++ofFixedAssetsLogsNum;
            List<String> CreatorTimeList = pagination.getCreatorTime();
            fir = Long.valueOf(CreatorTimeList.get(0));
            sec = Long.valueOf(CreatorTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(OfFixedAssetsLogsEntity::getCreatorTime, (Object)new Date(fir))).le(OfFixedAssetsLogsEntity::getCreatorTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (StringUtils.isNotEmpty((String)pagination.getLastModifyUserId())) {
            ++ofFixedAssetsLogsNum;
            queryWrapper.lambda().like(OfFixedAssetsLogsEntity::getLastModifyUserId, (Object)pagination.getLastModifyUserId());
        }
        if (StringUtils.isNotEmpty(pagination.getLastModifyTime())) {
            ++ofFixedAssetsLogsNum;
            List<String> LastModifyTimeList = pagination.getLastModifyTime();
            fir = Long.valueOf(LastModifyTimeList.get(0));
            sec = Long.valueOf(LastModifyTimeList.get(1));
            ((LambdaQueryWrapper)queryWrapper.lambda().ge(OfFixedAssetsLogsEntity::getLastModifyTime, (Object)new Date(fir))).le(OfFixedAssetsLogsEntity::getLastModifyTime, (Object)DateUtil.stringToDate((String)(DateUtil.daFormatYmd((Long)sec) + " 23:59:59")));
        }
        if (AllIdList.size() > 0) {
            queryWrapper.lambda().in(OfFixedAssetsLogsEntity::getId, AllIdList);
        }
        if (StringUtils.isEmpty((String)pagination.getSidx())) {
            queryWrapper.lambda().orderByDesc(OfFixedAssetsLogsEntity::getCreatorTime);
        } else {
            try {
                String sidx = pagination.getSidx();
                OfFixedAssetsLogsEntity ofFixedAssetsLogsEntity = new OfFixedAssetsLogsEntity();
                Field declaredField = ofFixedAssetsLogsEntity.getClass().getDeclaredField(sidx);
                declaredField.setAccessible(true);
                String value = declaredField.getAnnotation(TableField.class).value();
                queryWrapper = "asc".equals(pagination.getSort().toLowerCase()) ? (QueryWrapper)queryWrapper.orderByAsc((Object)value) : (QueryWrapper)queryWrapper.orderByDesc((Object)value);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if ("0".equals(dataType)) {
            if (total > 0 && AllIdList.size() > 0 || total == 0) {
                Page page = new Page(pagination.getCurrentPage(), pagination.getPageSize());
                IPage userIPage = this.page((IPage)page, (Wrapper)queryWrapper);
                return pagination.setData(userIPage.getRecords(), userIPage.getTotal());
            }
            ArrayList list = new ArrayList();
            return pagination.setData(list, list.size());
        }
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public OfFixedAssetsLogsEntity getInfo(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OfFixedAssetsLogsEntity::getId, (Object)id);
        return (OfFixedAssetsLogsEntity)this.getOne((Wrapper)queryWrapper);
    }

    @Override
    @DSTransactional
    public void create(OfFixedAssetsLogsEntity entity) {
        UserInfo userInfo = this.userProvider.get();
        String mainId = RandomUtil.uuId();
        String companyId = userInfo.getOrganizeId();
        entity.setId(mainId);
        entity.setCompanyId(companyId);
        this.save(entity);
    }

    @Override
    public void create(String fixedAssetsId, String newValue, String oldValue, String description, String creatorUserId, Date creatorTime) {
        OfFixedAssetsLogsEntity entity = this.getEntity(fixedAssetsId, newValue, oldValue, description, creatorUserId, creatorTime);
        this.save(entity);
    }

    @Override
    public OfFixedAssetsLogsEntity getEntity(String fixedAssetsId, String newValue, String oldValue, String description, String creatorUserId, Date creatorTime) {
        OfFixedAssetsLogsEntity entity = new OfFixedAssetsLogsEntity();
        entity.setFixedAssetsId(fixedAssetsId);
        entity.setNewValue(newValue);
        entity.setOldValue(oldValue);
        entity.setDescription(description);
        entity.setCreatorUserId(creatorUserId);
        entity.setCreatorTime(creatorTime);
        entity.setId(RandomUtil.uuId());
        return entity;
    }

    @Override
    @DSTransactional
    public boolean update(String id, OfFixedAssetsLogsEntity entity) {
        entity.setId(id);
        return this.updateById(entity);
    }

    @Override
    @DSTransactional
    public void delete(OfFixedAssetsLogsEntity entity) {
        if (entity != null) {
            this.removeById((Serializable)((Object)entity.getId()));
        }
    }

    @Override
    @DSTransactional
    public void delete(String ids) {
        String[] idList = ids.split(",");
        if (ObjectUtil.isNotEmpty((Object)idList)) {
            this.removeBatchByIds(Arrays.asList(idList));
        }
    }

    @Override
    public long selectLogCountByAssetsId(String assetsId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(OfFixedAssetsLogsEntity::getFixedAssetsId, (Object)assetsId);
        return this.count((Wrapper)queryWrapper);
    }
}

