/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.assets.util;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bringspring.assets.entity.OfFixedAssetsEntity;
import com.bringspring.assets.service.OfFixedAssetsService;
import com.bringspring.common.annotation.JsbosTask;
import com.bringspring.common.util.DateUtil;
import com.bringspring.system.base.entity.MessageTemplateEntity;
import com.bringspring.system.base.service.MessageTemplateService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.msgcenter.model.BusinessKeys;
import com.bringspring.system.msgcenter.model.TaskMsg;
import com.bringspring.system.msgcenter.model.TextMsgKeys;
import com.bringspring.system.msgcenter.util.SendTaskMsgUtils;
import com.bringspring.workflow.engine.util.ServiceAllUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ScheduleTaskUtils {
    Logger logger = LoggerFactory.getLogger(ScheduleTaskUtils.class);
    @Autowired
    private MessageTemplateService messageTemplateService;
    @Autowired
    private OfFixedAssetsService ofFixedAssetsService;
    @Autowired
    private ServiceAllUtil serviceUtil;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private SendTaskMsgUtils sendTaskMsgUtils;

    @JsbosTask(fullName="\u56fa\u5b9a\u8d44\u4ea7\u501f\u7528\u8d44\u4ea7\u5f52\u8fd8\u901a\u77e5", description="\u56fa\u5b9a\u8d44\u4ea7\u501f\u7528\u8d44\u4ea7\u5f52\u8fd8\u901a\u77e5")
    public void assetsLocalTaskTest() throws Exception {
        List<OfFixedAssetsEntity> list = this.ofFixedAssetsService.selectAssetsBorrowExpire(null, null, null, true);
        if (list != null && list.size() != 0) {
            this.sendMessage(list);
        }
    }

    private void sendMessage(List<OfFixedAssetsEntity> list) throws Exception {
        for (OfFixedAssetsEntity entity : list) {
            ArrayList<String> userIds = new ArrayList<String>();
            userIds.add(entity.getBaseUserId());
            TaskMsg taskMsg = new TaskMsg();
            taskMsg.setTaskCode("\u8d44\u4ea7\u7ba1\u7406");
            taskMsg.setSendCode("borrow_return_notification");
            Map<String, String> parameterMap = this.getParameterMap(entity);
            TextMsgKeys textMsgKeys = new TextMsgKeys();
            textMsgKeys.setKeys(parameterMap);
            taskMsg.setBusinessKey((BusinessKeys)textMsgKeys);
            taskMsg.setToUserIds(String.join((CharSequence)",", userIds));
            this.sendTaskMsgUtils.sendTaskMsg(taskMsg);
        }
    }

    private Map<String, String> getParameterMap(OfFixedAssetsEntity entity) {
        String title = "\u8d44\u4ea7\u81ea\u76d8\u901a\u77e5";
        HashMap<String, String> map = new HashMap<String, String>();
        String assetsName = entity.getName();
        String assetsCode = entity.getCode();
        String borrowDate = DateUtil.daFormat((Date)entity.getBorrowDate());
        String returnDate = DateUtil.daFormat((Date)entity.getReturnDate());
        map.put("title", title);
        map.put("assetsName", assetsName);
        map.put("assetsCode", assetsCode);
        map.put("borrowDate", borrowDate);
        map.put("returnDate", returnDate);
        map.put("informUser", "\u7cfb\u7edf\u901a\u77e5");
        String messageTime = DateUtil.dateFormat((Date)new Date());
        map.put("messageTime", messageTime);
        map.put("remark", "");
        return map;
    }

    private MessageTemplateEntity getMessageTemplate(String templateCode) {
        QueryWrapper templateEntityQueryWrapper = new QueryWrapper();
        templateEntityQueryWrapper.lambda().eq(MessageTemplateEntity::getEnCode, (Object)templateCode);
        MessageTemplateEntity one = (MessageTemplateEntity)this.messageTemplateService.getOne((Wrapper)templateEntityQueryWrapper);
        if (ObjectUtil.isNull((Object)one)) {
            this.logger.info("\u672a\u914d\u7f6e\u6d88\u606f\u6a21\u677f,code:{}", (Object)templateCode);
            return null;
        }
        return one;
    }
}

