/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoUnlinked;
import io.github.classgraph.ClasspathElement;
import io.github.classgraph.ModuleRef;
import io.github.classgraph.ScanResult;
import io.github.classgraph.ScanSpec;
import io.github.classgraph.utils.ClassLoaderAndModuleFinder;
import io.github.classgraph.utils.ClasspathFinder;
import io.github.classgraph.utils.ClasspathOrModulePathEntry;
import io.github.classgraph.utils.InterruptionChecker;
import io.github.classgraph.utils.JarUtils;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.NestedJarHandler;
import io.github.classgraph.utils.SingletonMap;
import io.github.classgraph.utils.WorkQueue;
import java.io.File;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;

class Scanner
implements Callable<ScanResult> {
    private final ScanSpec scanSpec;
    private final ExecutorService executorService;
    private final int numParallelTasks;
    private final InterruptionChecker interruptionChecker = new InterruptionChecker();
    private final ClassGraph.ScanResultProcessor scanResultProcessor;
    private final ClassGraph.FailureHandler failureHandler;
    private final LogNode topLevelLog;
    private NestedJarHandler nestedJarHandler;
    private static final int NUM_FILES_PER_CHUNK = 32;

    Scanner(ScanSpec scanSpec, ExecutorService executorService, int numParallelTasks, ClassGraph.ScanResultProcessor scannResultProcessor, ClassGraph.FailureHandler failureHandler, LogNode log) {
        this.scanSpec = scanSpec;
        scanSpec.sortPrefixes();
        this.executorService = executorService;
        this.numParallelTasks = numParallelTasks;
        this.scanResultProcessor = scannResultProcessor;
        this.failureHandler = failureHandler;
        this.topLevelLog = log;
        scanSpec.log(log);
    }

    private static void findClasspathOrder(ClasspathElement currClasspathElement, ClasspathOrModulePathEntryToClasspathElementMap classpathElementMap, HashSet<ClasspathElement> visitedClasspathElts, ArrayList<ClasspathElement> order) throws InterruptedException {
        if (visitedClasspathElts.add(currClasspathElement)) {
            if (!currClasspathElement.skipClasspathElement) {
                order.add(currClasspathElement);
            }
            if (currClasspathElement.childClasspathElts != null) {
                for (ClasspathOrModulePathEntry childClasspathElt : currClasspathElement.childClasspathElts) {
                    ClasspathElement childSingleton = (ClasspathElement)classpathElementMap.get(childClasspathElt);
                    if (childSingleton == null) continue;
                    Scanner.findClasspathOrder(childSingleton, classpathElementMap, visitedClasspathElts, order);
                }
            }
            if (currClasspathElement.skipClasspathElement) {
                currClasspathElement.closeRecyclers();
            }
        }
    }

    private static List<ClasspathElement> findClasspathOrder(List<ClasspathOrModulePathEntry> rawClasspathElements, ClasspathOrModulePathEntryToClasspathElementMap classpathElementMap) throws InterruptedException {
        HashSet<ClasspathElement> visitedClasspathElts = new HashSet<ClasspathElement>();
        ArrayList<ClasspathElement> order = new ArrayList<ClasspathElement>();
        for (ClasspathOrModulePathEntry toplevelClasspathElt : rawClasspathElements) {
            ClasspathElement toplevelSingleton = (ClasspathElement)classpathElementMap.get(toplevelClasspathElt);
            if (toplevelSingleton == null) continue;
            Scanner.findClasspathOrder(toplevelSingleton, classpathElementMap, visitedClasspathElts, order);
        }
        return order;
    }

    private static List<ClassfileParserChunk> getClassfileParserChunks(List<ClasspathElement> classpathOrder) {
        LinkedList chunks = new LinkedList();
        for (ClasspathElement classpathElement : classpathOrder) {
            LinkedList<ClassfileParserChunk> chunksForClasspathElt = new LinkedList<ClassfileParserChunk>();
            int n = classpathElement.getNumClassfileMatches();
            if (n > 0) {
                int numChunks = (int)Math.ceil((float)n / 32.0f);
                float filesPerChunk = (float)n / (float)numChunks;
                for (int i = 0; i < numChunks; ++i) {
                    int classfileEndIdx;
                    int classfileStartIdx = (int)((float)i * filesPerChunk);
                    int n2 = classfileEndIdx = i < numChunks - 1 ? (int)((float)(i + 1) * filesPerChunk) : n;
                    if (classfileEndIdx <= classfileStartIdx) continue;
                    chunksForClasspathElt.add(new ClassfileParserChunk(classpathElement, classfileStartIdx, classfileEndIdx));
                }
            }
            chunks.add(chunksForClasspathElt);
        }
        ArrayList<ClassfileParserChunk> interleavedChunks = new ArrayList<ClassfileParserChunk>();
        while (!chunks.isEmpty()) {
            LinkedList<LinkedList> nextChunks = new LinkedList<LinkedList>();
            for (LinkedList linkedList : chunks) {
                if (linkedList.isEmpty()) continue;
                ClassfileParserChunk head = (ClassfileParserChunk)linkedList.remove();
                interleavedChunks.add(head);
                if (linkedList.isEmpty()) continue;
                nextChunks.add(linkedList);
            }
            chunks = nextChunks;
        }
        return interleavedChunks;
    }

    @Override
    public ScanResult call() throws InterruptedException, ExecutionException {
        LogNode classpathFinderLog = this.topLevelLog == null ? null : this.topLevelLog.log("Finding classpath entries");
        this.nestedJarHandler = new NestedJarHandler(this.scanSpec, classpathFinderLog);
        final ClasspathOrModulePathEntryToClasspathElementMap classpathElementMap = new ClasspathOrModulePathEntryToClasspathElementMap(this.scanSpec, this.nestedJarHandler);
        try {
            ScanResult scanResult;
            long scanStart = System.nanoTime();
            LogNode getRawElementsLog = classpathFinderLog == null ? null : classpathFinderLog.log("Getting raw classpath elements");
            ClasspathFinder classpathFinder = new ClasspathFinder(this.scanSpec, this.nestedJarHandler, getRawElementsLog);
            ClassLoaderAndModuleFinder classLoaderAndModuleFinder = classpathFinder.getClassLoaderAndModuleFinder();
            ClassLoader[] classLoaderOrder = classLoaderAndModuleFinder.getClassLoaders();
            ArrayList<ClasspathOrModulePathEntry> rawClasspathEltOrder = new ArrayList<ClasspathOrModulePathEntry>();
            if (this.scanSpec.overrideClasspath == null && this.scanSpec.overrideClassLoaders == null) {
                Object nonSystemModules;
                List<ModuleRef> systemModules = classLoaderAndModuleFinder.getSystemModuleRefs();
                if (systemModules != null) {
                    for (ModuleRef moduleRef : systemModules) {
                        String moduleName = moduleRef.getName();
                        if (!this.scanSpec.blacklistSystemJarsOrModules || !JarUtils.isInSystemPackageOrModule(moduleName)) {
                            if (this.scanSpec.moduleWhiteBlackList.isWhitelistedAndNotBlacklisted(moduleName)) {
                                rawClasspathEltOrder.add(new ClasspathOrModulePathEntry(moduleRef, this.nestedJarHandler, getRawElementsLog));
                                continue;
                            }
                            if (classpathFinderLog == null) continue;
                            classpathFinderLog.log("Skipping non-whitelisted or blacklisted system module: " + moduleName);
                            continue;
                        }
                        if (classpathFinderLog == null) continue;
                        classpathFinderLog.log("Skipping system module: " + moduleName);
                    }
                }
                if ((nonSystemModules = classLoaderAndModuleFinder.getNonSystemModuleRefs()) != null) {
                    Iterator iterator = nonSystemModules.iterator();
                    while (iterator.hasNext()) {
                        ModuleRef nonSystemModule = (ModuleRef)iterator.next();
                        String moduleName = nonSystemModule.getName();
                        if (this.scanSpec.moduleWhiteBlackList.isWhitelistedAndNotBlacklisted(moduleName)) {
                            rawClasspathEltOrder.add(new ClasspathOrModulePathEntry(nonSystemModule, this.nestedJarHandler, getRawElementsLog));
                            continue;
                        }
                        if (classpathFinderLog == null) continue;
                        classpathFinderLog.log("Skipping non-whitelisted or blacklisted module: " + moduleName);
                    }
                }
            }
            rawClasspathEltOrder.addAll(classpathFinder.getRawClasspathElements());
            ArrayList<String> rawClasspathEltOrderStrs = new ArrayList<String>(rawClasspathEltOrder.size());
            for (ClasspathOrModulePathEntry classpathOrModulePathEntry : rawClasspathEltOrder) {
                rawClasspathEltOrderStrs.add(classpathOrModulePathEntry.getResolvedPath());
            }
            final LogNode preScanLog = classpathFinderLog == null ? null : classpathFinderLog.log("Reading jarfile metadata");
            WorkQueue.runWorkQueue(rawClasspathEltOrder, this.executorService, this.numParallelTasks, new WorkQueue.WorkUnitProcessor<ClasspathOrModulePathEntry>(){

                @Override
                public void processWorkUnit(ClasspathOrModulePathEntry rawClasspathEltPath) throws Exception {
                    try {
                        classpathElementMap.getOrCreateSingleton(rawClasspathEltPath, preScanLog);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }, new WorkQueue.WorkQueuePreStartHook<ClasspathOrModulePathEntry>(){

                @Override
                public void processWorkQueueRef(WorkQueue<ClasspathOrModulePathEntry> workQueue) {
                    classpathElementMap.setWorkQueue(workQueue);
                }
            }, this.interruptionChecker, preScanLog);
            List<ClasspathElement> list = Scanner.findClasspathOrder(rawClasspathEltOrder, classpathElementMap);
            if (classpathFinderLog != null) {
                LogNode logNode = classpathFinderLog.log("Final classpath element order:");
                for (int i = 0; i < list.size(); ++i) {
                    ClasspathElement classpathElt = list.get(i);
                    ModuleRef classpathElementModuleRef = classpathElt.getClasspathElementModuleRef();
                    if (classpathElementModuleRef != null) {
                        logNode.log(i + ": module " + classpathElementModuleRef.getName() + " ; module location: " + classpathElementModuleRef.getLocationStr());
                        continue;
                    }
                    String classpathEltStr = classpathElt.toString();
                    String classpathEltFileStr = "" + classpathElt.getClasspathElementFile(logNode);
                    String packageRoot = classpathElt.getJarfilePackageRoot();
                    logNode.log(i + ": " + (classpathEltStr.equals(classpathEltFileStr) && packageRoot.isEmpty() ? classpathEltStr : classpathElt + " -> " + classpathEltFileStr + (packageRoot.isEmpty() ? "" : " ; package root: " + packageRoot)));
                }
            }
            if (!this.scanSpec.performScan) {
                if (this.topLevelLog != null) {
                    this.topLevelLog.log("Only returning classpath elements (not performing a scan)");
                }
                scanResult = new ScanResult(this.scanSpec, list, rawClasspathEltOrderStrs, classLoaderOrder, null, null, this.nestedJarHandler, this.topLevelLog);
            } else {
                ArrayList<AbstractMap.SimpleEntry<String, ClasspathElement>> classpathEltResolvedPathToElement = new ArrayList<AbstractMap.SimpleEntry<String, ClasspathElement>>();
                for (int i = 0; i < list.size(); ++i) {
                    ClasspathElement classpathElement = list.get(i);
                    classpathEltResolvedPathToElement.add(new AbstractMap.SimpleEntry<String, ClasspathElement>(classpathElement.classpathEltPath.getResolvedPath(), classpathElement));
                }
                Collections.sort(classpathEltResolvedPathToElement, new Comparator<AbstractMap.SimpleEntry<String, ClasspathElement>>(){

                    @Override
                    public int compare(AbstractMap.SimpleEntry<String, ClasspathElement> o1, AbstractMap.SimpleEntry<String, ClasspathElement> o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
                LogNode nestedClasspathRootNode = null;
                block15: for (int i = 0; i < classpathEltResolvedPathToElement.size(); ++i) {
                    AbstractMap.SimpleEntry ei = (AbstractMap.SimpleEntry)classpathEltResolvedPathToElement.get(i);
                    String basePath = (String)ei.getKey();
                    int basePathLen = basePath.length();
                    for (int j = i + 1; j < classpathEltResolvedPathToElement.size(); ++j) {
                        String nestedClasspathRelativePath;
                        char nextChar;
                        AbstractMap.SimpleEntry ej = (AbstractMap.SimpleEntry)classpathEltResolvedPathToElement.get(j);
                        String comparePath = (String)ej.getKey();
                        int comparePathLen = comparePath.length();
                        boolean foundNestedClasspathRoot = false;
                        if (comparePath.startsWith(basePath) && comparePathLen > basePathLen && ((nextChar = comparePath.charAt(basePathLen)) == '/' || nextChar == '!') && (nestedClasspathRelativePath = comparePath.substring(basePathLen + 1)).indexOf(33) < 0) {
                            foundNestedClasspathRoot = true;
                            ClasspathElement baseElement = (ClasspathElement)ei.getValue();
                            if (baseElement.nestedClasspathRootPrefixes == null) {
                                baseElement.nestedClasspathRootPrefixes = new ArrayList<String>();
                            }
                            baseElement.nestedClasspathRootPrefixes.add(nestedClasspathRelativePath + "/");
                            if (classpathFinderLog != null) {
                                if (nestedClasspathRootNode == null) {
                                    nestedClasspathRootNode = classpathFinderLog.log("Found nested classpath elements");
                                }
                                nestedClasspathRootNode.log(basePath + " is a prefix of the nested element " + comparePath);
                            }
                        }
                        if (!foundNestedClasspathRoot) continue block15;
                    }
                }
                final LogNode pathScanLog = classpathFinderLog == null ? null : classpathFinderLog.log("Scanning filenames within classpath elements");
                WorkQueue.runWorkQueue(list, this.executorService, this.numParallelTasks, new WorkQueue.WorkUnitProcessor<ClasspathElement>(){

                    @Override
                    public void processWorkUnit(ClasspathElement classpathElement) throws Exception {
                        classpathElement.scanPaths(pathScanLog);
                    }
                }, this.interruptionChecker, pathScanLog);
                LogNode maskLog = this.topLevelLog == null ? null : this.topLevelLog.log("Masking classpath files");
                HashSet<String> classpathRelativePathsFound = new HashSet<String>();
                for (int classpathIdx = 0; classpathIdx < list.size(); ++classpathIdx) {
                    ClasspathElement classpathElement = list.get(classpathIdx);
                    classpathElement.maskFiles(classpathIdx, classpathRelativePathsFound, maskLog);
                }
                HashMap<File, Long> fileToLastModified = new HashMap<File, Long>();
                for (ClasspathElement classpathElement : list) {
                    fileToLastModified.putAll(classpathElement.fileToLastModified);
                }
                HashMap<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
                if (!this.scanSpec.enableClassInfo) {
                    if (this.topLevelLog != null) {
                        this.topLevelLog.log("Classfile scanning is disabled");
                    }
                } else {
                    final ConcurrentLinkedQueue classInfoUnlinked = new ConcurrentLinkedQueue();
                    final LogNode classfileScanLog = this.topLevelLog == null ? null : this.topLevelLog.log("Scanning classfile binary headers");
                    List<ClassfileParserChunk> classfileParserChunks = Scanner.getClassfileParserChunks(list);
                    WorkQueue.runWorkQueue(classfileParserChunks, this.executorService, this.numParallelTasks, new WorkQueue.WorkUnitProcessor<ClassfileParserChunk>(){

                        @Override
                        public void processWorkUnit(ClassfileParserChunk chunk) throws Exception {
                            chunk.classpathElement.parseClassfiles(chunk.classfileStartIdx, chunk.classfileEndIdx, classInfoUnlinked, classfileScanLog);
                            Scanner.this.interruptionChecker.check();
                        }
                    }, this.interruptionChecker, classfileScanLog);
                    if (classfileScanLog != null) {
                        classfileScanLog.addElapsedTime();
                    }
                    LogNode classGraphLog = this.topLevelLog == null ? null : this.topLevelLog.log("Building class graph");
                    for (ClassInfoUnlinked c : classInfoUnlinked) {
                        c.link(this.scanSpec, classNameToClassInfo, classGraphLog);
                    }
                    if (classGraphLog != null) {
                        classGraphLog.addElapsedTime();
                    }
                }
                scanResult = new ScanResult(this.scanSpec, list, rawClasspathEltOrderStrs, classLoaderOrder, classNameToClassInfo, fileToLastModified, this.nestedJarHandler, this.topLevelLog);
            }
            if (this.topLevelLog != null) {
                this.topLevelLog.log("Completed", System.nanoTime() - scanStart);
            }
            if (this.scanResultProcessor != null) {
                try {
                    this.scanResultProcessor.processScanResult(scanResult);
                }
                catch (Throwable e) {
                    throw new ExecutionException("Exception while calling scan result processor", e);
                }
            }
            ScanResult scanResult2 = scanResult;
            return scanResult2;
        }
        catch (Throwable e) {
            if (this.nestedJarHandler != null) {
                this.nestedJarHandler.close(this.topLevelLog);
            }
            if (this.topLevelLog != null) {
                this.topLevelLog.log(e);
            }
            if (this.failureHandler != null) {
                try {
                    this.failureHandler.onFailure(e);
                    ScanResult scanResult = null;
                    return scanResult;
                }
                catch (Throwable t) {
                    throw new ExecutionException("Exception while calling failure handler", t);
                }
            }
            throw new ExecutionException("Exception while scanning", e);
        }
        finally {
            if (this.scanSpec.removeTemporaryFilesAfterScan) {
                this.nestedJarHandler.close(this.topLevelLog);
            } else {
                this.nestedJarHandler.closeRecyclers();
            }
            for (ClasspathElement elt : classpathElementMap.values()) {
                if (elt == null) continue;
                elt.closeRecyclers();
            }
            if (this.topLevelLog != null) {
                this.topLevelLog.flush();
            }
        }
    }

    private static class ClassfileParserChunk {
        private final ClasspathElement classpathElement;
        private final int classfileStartIdx;
        private final int classfileEndIdx;

        public ClassfileParserChunk(ClasspathElement classpathElementSingleton, int classfileStartIdx, int classfileEndIdx) {
            this.classpathElement = classpathElementSingleton;
            this.classfileStartIdx = classfileStartIdx;
            this.classfileEndIdx = classfileEndIdx;
        }
    }

    private static class ClasspathOrModulePathEntryToClasspathElementMap
    extends SingletonMap<ClasspathOrModulePathEntry, ClasspathElement> {
        private final ScanSpec scanSpec;
        private final NestedJarHandler nestedJarHandler;
        private WorkQueue<ClasspathOrModulePathEntry> workQueue;

        ClasspathOrModulePathEntryToClasspathElementMap(ScanSpec scanSpec, NestedJarHandler nestedJarHandler) {
            this.scanSpec = scanSpec;
            this.nestedJarHandler = nestedJarHandler;
        }

        void setWorkQueue(WorkQueue<ClasspathOrModulePathEntry> workQueue) {
            this.workQueue = workQueue;
        }

        @Override
        public ClasspathElement newInstance(ClasspathOrModulePathEntry classpathElt, LogNode log) {
            block11: {
                LogNode jarLog;
                LogNode logNode = jarLog = log == null ? null : log.log("Reading " + classpathElt.getResolvedPath());
                if (classpathElt.isValidClasspathElement(this.scanSpec, jarLog)) {
                    try {
                        boolean isDir;
                        boolean isModule = classpathElt.getModuleRef() != null;
                        boolean isFile = !isModule && classpathElt.isFile(jarLog);
                        boolean bl = isDir = !isModule && classpathElt.isDirectory(jarLog);
                        if (isFile && !this.scanSpec.scanJars) {
                            if (jarLog != null) {
                                jarLog.log("Skipping because jar scanning has been disabled: " + classpathElt);
                            }
                            break block11;
                        }
                        if (isFile && !this.scanSpec.jarWhiteBlackList.isWhitelistedAndNotBlacklisted(classpathElt.getCanonicalPath(jarLog))) {
                            if (jarLog != null) {
                                jarLog.log("Skipping jarfile that is blacklisted or not whitelisted: " + classpathElt);
                            }
                            break block11;
                        }
                        if (isDir && !this.scanSpec.scanDirs) {
                            if (jarLog != null) {
                                jarLog.log("Skipping because directory scanning has been disabled: " + classpathElt);
                            }
                            break block11;
                        }
                        if (isModule && !this.scanSpec.scanModules) {
                            if (jarLog != null) {
                                jarLog.log("Skipping because module scanning has been disabled: " + classpathElt);
                            }
                            break block11;
                        }
                        return ClasspathElement.newInstance(classpathElt, this.scanSpec, this.nestedJarHandler, this.workQueue, jarLog);
                    }
                    catch (Exception e) {
                        if (jarLog == null) break block11;
                        jarLog.log("Skipping invalid classpath element " + classpathElt + " : " + e);
                    }
                }
            }
            return null;
        }
    }
}

