/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.files.controller;

import com.bringspring.common.base.ActionResult;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.base.vo.PageListVO;
import com.bringspring.common.base.vo.PaginationVO;
import com.bringspring.common.entity.FileDownLogEntity;
import com.bringspring.common.exception.DataException;
import com.bringspring.common.model.filedownlog.FileDownLogCrForm;
import com.bringspring.common.model.filedownlog.FileDownLogInfoVO;
import com.bringspring.common.model.filedownlog.FileDownLogPagination;
import com.bringspring.common.model.filedownlog.FileDownLogUpForm;
import com.bringspring.common.service.FileDownLogService;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.UserProvider;
import com.bringspring.system.permission.util.BaseDataUtil;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6587\u4ef6\u4e0b\u8f7d\u65e5\u5fd7"}, value="files")
@RequestMapping(value={"/api/files/FileDownLog"})
public class FileDownLogController {
    private static final Logger log = LoggerFactory.getLogger(FileDownLogController.class);
    @Autowired
    private BaseDataUtil baseDataUtil;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private FileDownLogService filedownlogService;

    @PostMapping(value={"/getList"})
    public ActionResult list(@RequestBody FileDownLogPagination filedownlogPagination) throws IOException {
        UserInfo userInfo = this.userProvider.get();
        List list = this.filedownlogService.getList(filedownlogPagination);
        List listVO = JsonUtil.getJsonToList((Object)list, FileDownLogCrForm.class);
        listVO.forEach(v -> v.setCreatorUserName(this.baseDataUtil.userSelectValue(v.getCreatorUserId())));
        PageListVO vo = new PageListVO();
        vo.setList(listVO);
        PaginationVO page = (PaginationVO)JsonUtil.getJsonToBean((Object)filedownlogPagination, PaginationVO.class);
        vo.setPagination(page);
        return ActionResult.success((Object)vo);
    }

    @PostMapping
    public ActionResult create(@RequestBody @Valid FileDownLogCrForm filedownlogCrForm) throws DataException {
        this.filedownlogService.create(filedownlogCrForm);
        return ActionResult.success((String)"\u521b\u5efa\u6210\u529f");
    }

    @GetMapping(value={"/{id}"})
    public ActionResult<FileDownLogInfoVO> info(@PathVariable(value="id") String id) {
        FileDownLogEntity entity = this.filedownlogService.getInfo(id);
        FileDownLogInfoVO vo = (FileDownLogInfoVO)JsonUtil.getJsonToBean((Object)entity, FileDownLogInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @GetMapping(value={"/detail/{id}"})
    public ActionResult<FileDownLogInfoVO> detailInfo(@PathVariable(value="id") String id) {
        FileDownLogEntity entity = this.filedownlogService.getInfo(id);
        FileDownLogInfoVO vo = (FileDownLogInfoVO)JsonUtil.getJsonToBean((Object)entity, FileDownLogInfoVO.class);
        return ActionResult.success((Object)vo);
    }

    @PutMapping(value={"/{id}"})
    public ActionResult update(@PathVariable(value="id") String id, @RequestBody @Valid FileDownLogUpForm filedownlogUpForm) throws DataException {
        this.filedownlogService.update(id, filedownlogUpForm);
        return ActionResult.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @DeleteMapping(value={"/{id}"})
    public ActionResult delete(@PathVariable(value="id") String id) {
        FileDownLogEntity entity = this.filedownlogService.getInfo(id);
        if (entity != null) {
            this.filedownlogService.delete(entity);
        }
        return ActionResult.success((String)"\u5220\u9664\u6210\u529f");
    }
}

