/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.config.cas;

import java.util.EventListener;
import java.util.HashMap;
import javax.servlet.Filter;
import org.jasig.cas.client.authentication.AuthenticationFilter;
import org.jasig.cas.client.session.SingleSignOutFilter;
import org.jasig.cas.client.session.SingleSignOutHttpSessionListener;
import org.jasig.cas.client.util.HttpServletRequestWrapperFilter;
import org.jasig.cas.client.validation.Cas30ProxyReceivingTicketValidationFilter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="config", name={"cas"}, havingValue="true", matchIfMissing=false)
public class CasConfig {
    @Value(value="${cas.server-url-prefix:}")
    private String CAS_SERVER_URL_PREFIX;
    @Value(value="${cas.server-login-url:}")
    private String CAS_SERVER_URL_LOGIN;
    @Value(value="${cas.client-host-url:}")
    private String SERVER_NAME;

    @Bean
    public FilterRegistrationBean filterSingleRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new SingleSignOutFilter());
        registration.addUrlPatterns(new String[]{"/api/cas/*"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("casServerUrlPrefix", this.CAS_SERVER_URL_PREFIX);
        registration.setInitParameters(initParameters);
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public FilterRegistrationBean filterValidationRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new Cas30ProxyReceivingTicketValidationFilter());
        registration.addUrlPatterns(new String[]{"/api/cas/*"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("casServerUrlPrefix", this.CAS_SERVER_URL_PREFIX);
        initParameters.put("serverName", this.SERVER_NAME);
        initParameters.put("useSession", "true");
        registration.setInitParameters(initParameters);
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public FilterRegistrationBean filterAuthenticationRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new AuthenticationFilter());
        registration.addUrlPatterns(new String[]{"/api/cas/*"});
        HashMap<String, String> initParameters = new HashMap<String, String>();
        initParameters.put("casServerLoginUrl", this.CAS_SERVER_URL_LOGIN);
        initParameters.put("serverName", this.SERVER_NAME);
        initParameters.put("ignorePattern", "/system/*");
        registration.setInitParameters(initParameters);
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public FilterRegistrationBean filterWrapperRegistration() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new HttpServletRequestWrapperFilter());
        registration.addUrlPatterns(new String[]{"/api/cas/*"});
        registration.setOrder(1);
        return registration;
    }

    @Bean
    public ServletListenerRegistrationBean<EventListener> singleSignOutListenerRegistration() {
        ServletListenerRegistrationBean registrationBean = new ServletListenerRegistrationBean();
        registrationBean.setListener((EventListener)new SingleSignOutHttpSessionListener());
        registrationBean.setOrder(1);
        return registrationBean;
    }
}

