/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.method.password.provider;

import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.StringUtils;
import com.bringspring.oauth.method.detail.UserDetailsServiceImpl;
import com.bringspring.oauth.method.detail.UserExtend;
import com.bringspring.oauth.method.password.token.AccountPasswordAuthenticationToken;
import com.bringspring.system.base.service.SysConfigService;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class AccountPasswordAuthenticationProvider
implements AuthenticationProvider {
    @Autowired
    private UserDetailsServiceImpl userDetailsService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private CacheUtil cacheUtil;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UserExtend userDetails;
        AccountPasswordAuthenticationToken accountAuthentication = (AccountPasswordAuthenticationToken)authentication;
        String timestamp = accountAuthentication.getTimestamp();
        String code = accountAuthentication.getCode();
        BaseSystemInfo sysConfigInfo = this.sysConfigService.getSysInfo();
        if (Objects.nonNull(sysConfigInfo) && "1".equals(String.valueOf(sysConfigInfo.getEnableVerificationCode()))) {
            if (StringUtils.isEmpty((String)code)) {
                throw new BadCredentialsException("\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((String)timestamp)) {
                throw new BadCredentialsException("\u65f6\u95f4\u6233\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String codeCache = String.valueOf(this.cacheUtil.query("loginCacheSpace", timestamp));
            if (StringUtils.isEmpty((String)codeCache)) {
                throw new BadCredentialsException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6");
            }
            if (!code.toLowerCase().equals(codeCache.toLowerCase())) {
                throw new BadCredentialsException("\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
            }
        }
        String username = accountAuthentication.getName();
        String passwordIn = accountAuthentication.getCredentials().toString();
        if (this.matches(passwordIn, (userDetails = this.userDetailsService.loadUserByUsername(username)).getSecretkey(), userDetails.getPassword())) {
            return authentication;
        }
        throw new BadCredentialsException("\u5bc6\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
    }

    public boolean matches(CharSequence rawEncoder, String secretkey, String encoder) {
        return encoder.equals(Md5Util.getStringMd5((String)(rawEncoder + secretkey.toLowerCase())));
    }

    public boolean supports(Class<?> authentication) {
        return authentication.equals(AccountPasswordAuthenticationToken.class);
    }
}

