/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.method.password.token;

import java.util.Collection;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.util.Assert;

public class AccountPasswordAuthenticationToken
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = 560L;
    private final Object principal;
    private Object credentials;
    private String timestamp;
    private String code;

    public AccountPasswordAuthenticationToken(String username, String password, String timestamp, String code) {
        super((Collection)null);
        this.principal = username;
        this.credentials = password;
        this.timestamp = timestamp;
        this.code = code;
        this.setAuthenticated(false);
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getCode() {
        return this.code;
    }

    public void setAuthenticated(boolean isAuthenticated) throws IllegalArgumentException {
        Assert.isTrue((!isAuthenticated ? 1 : 0) != 0, (String)"Cannot set this token to trusted - use constructor which takes a GrantedAuthority list instead");
        super.setAuthenticated(false);
    }

    public void eraseCredentials() {
        super.eraseCredentials();
        this.credentials = null;
    }
}

