/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaPhoneNumberInfo;
import cn.binarywang.wx.miniapp.util.WxMaConfigHolder;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.dingtalkcontact_1_0.Client;
import com.aliyun.dingtalkcontact_1_0.models.GetUserHeaders;
import com.aliyun.dingtalkoauth2_1_0.models.GetUserTokenRequest;
import com.aliyun.dingtalkoauth2_1_0.models.GetUserTokenResponse;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import com.bringspring.common.base.GlobalMarkEnum;
import com.bringspring.common.base.UserInfo;
import com.bringspring.common.config.ConfigValueUtil;
import com.bringspring.common.constant.MsgCode;
import com.bringspring.common.database.data.DataSourceContextHolder;
import com.bringspring.common.database.model.TenantVO;
import com.bringspring.common.model.login.BaseSystemInfo;
import com.bringspring.common.model.login.LoginForm;
import com.bringspring.common.model.login.MenuTreeVO;
import com.bringspring.common.model.login.PermissionModel;
import com.bringspring.common.model.login.PermissionVO;
import com.bringspring.common.model.login.UserCommonInfoVO;
import com.bringspring.common.model.login.UserMenuModel;
import com.bringspring.common.model.login.UserPositionVO;
import com.bringspring.common.util.CacheKeyUtil;
import com.bringspring.common.util.CacheUtil;
import com.bringspring.common.util.DateUtil;
import com.bringspring.common.util.IpUtil;
import com.bringspring.common.util.JsonUtil;
import com.bringspring.common.util.Md5Util;
import com.bringspring.common.util.RandomUtil;
import com.bringspring.common.util.ServletUtils;
import com.bringspring.common.util.StringUtils;
import com.bringspring.common.util.UserProvider;
import com.bringspring.common.util.treeutil.ListToTreeUtil;
import com.bringspring.common.util.treeutil.newtreeutil.TreeDotUtils;
import com.bringspring.common.util.wxutil.HttpUtil;
import com.bringspring.oauth.model.DingUserInfoModel;
import com.bringspring.oauth.model.PcUserVO;
import com.bringspring.oauth.service.LoginService;
import com.bringspring.system.base.entity.LogEntity;
import com.bringspring.system.base.entity.SysConfigEntity;
import com.bringspring.system.base.enums.LogSortEnum;
import com.bringspring.system.base.exception.BaseException;
import com.bringspring.system.base.exception.LoginException;
import com.bringspring.system.base.model.dingding.DingUserModel;
import com.bringspring.system.base.model.module.ModuleModel;
import com.bringspring.system.base.model.systemconfig.SystemInfo;
import com.bringspring.system.base.service.LogService;
import com.bringspring.system.base.service.SysConfigService;
import com.bringspring.system.base.util.Props;
import com.bringspring.system.external.bean.WeComModel;
import com.bringspring.system.external.bean.linkedcorp.MyWxCpLinkedCorpUser;
import com.bringspring.system.external.config.mutil.WxCpConfiguration;
import com.bringspring.system.external.config.mutil.WxMaConfiguration;
import com.bringspring.system.external.service.WxCpCorpService;
import com.bringspring.system.external.service.WxCpLinkedCorpService;
import com.bringspring.system.external.service.impl.MyWxCpLinkedCorpServiceImpl;
import com.bringspring.system.external.util.ValidateCommonUtil;
import com.bringspring.system.message.entity.SynThirdInfoEntity;
import com.bringspring.system.message.service.SynThirdInfoService;
import com.bringspring.system.permission.entity.OrganizeEntity;
import com.bringspring.system.permission.entity.RoleEntity;
import com.bringspring.system.permission.entity.UserEntity;
import com.bringspring.system.permission.entity.UserRelationEntity;
import com.bringspring.system.permission.exception.PermissionException;
import com.bringspring.system.permission.model.authorize.AuthorizeVO;
import com.bringspring.system.permission.model.user.vo.UserBaseVO;
import com.bringspring.system.permission.service.AuthorizeService;
import com.bringspring.system.permission.service.OrganizeRelationService;
import com.bringspring.system.permission.service.OrganizeService;
import com.bringspring.system.permission.service.PositionService;
import com.bringspring.system.permission.service.RoleService;
import com.bringspring.system.permission.service.UserRelationService;
import com.bringspring.system.permission.service.UserService;
import com.bringspring.visualdev.portal.model.PortalSelectModel;
import com.bringspring.visualdev.portal.service.PortalService;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiGettokenRequest;
import com.dingtalk.api.request.OapiV2UserGetuserinfoRequest;
import com.dingtalk.api.response.OapiGettokenResponse;
import com.dingtalk.api.response.OapiV2UserGetuserinfoResponse;
import com.taobao.api.TaobaoRequest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.cp.api.WxCpService;
import me.chanjar.weixin.cp.bean.WxCpOauth2UserInfo;
import me.chanjar.weixin.cp.bean.WxCpUser;
import me.chanjar.weixin.cp.bean.WxCpUserDetail;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginServiceImpl
implements LoginService {
    protected Log log = LogFactory.getLog(this.getClass());
    @Autowired
    private ConfigValueUtil configValueUtil;
    @Autowired
    private Props props;
    @Autowired
    private UserProvider userProvider;
    @Autowired
    private UserService userService;
    @Autowired
    private UserRelationService userRelationService;
    @Autowired
    private OrganizeService organizeService;
    @Autowired
    private PositionService positionService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private AuthorizeService authorizeService;
    @Autowired
    private SysConfigService sysConfigService;
    @Autowired
    private PortalService portalService;
    @Autowired
    private CacheUtil cacheUtil;
    @Autowired
    private CacheKeyUtil cacheKeyUtil;
    @Autowired
    private OrganizeRelationService organizeRelationService;
    @Autowired
    private SynThirdInfoService synThirdInfoService;
    @Autowired
    private Executor threadPoolExecutor;
    @Autowired
    private WxCpCorpService wxCpCorpService;
    @Autowired
    WxCpConfiguration wxCpConfiguration;
    @Autowired
    ValidateCommonUtil validateCommonUtil;
    @Autowired
    WxCpLinkedCorpService wxCpLinkedCorpService;
    @Autowired
    private WxMaConfiguration wxMaConfiguration;
    private WxMaService wxMaService;
    @Autowired
    private LogService logService;

    @Override
    public UserInfo checkTenant(LoginForm loginForm) throws LoginException {
        UserInfo userInfo = new UserInfo();
        String tenantId = "";
        if (Boolean.parseBoolean(this.configValueUtil.getMultiTenancy())) {
            String[] tenantAccount = loginForm.getAccount().split("\\@");
            tenantId = tenantAccount.length == 1 ? loginForm.getAccount() : tenantAccount[0];
            loginForm.setAccount(tenantAccount.length == 1 ? "admin" : tenantAccount[1]);
            if (tenantAccount.length > 2 || tenantId.length() > 11) {
                throw new LoginException(MsgCode.LOG102.get());
            }
            JSONObject object = this.props.getPortUrl().contains("https") ? HttpUtil.httpRequest((String)(this.props.getPortUrl() + tenantId), (String)"GET", null) : HttpUtil.httpRequest((String)(this.props.getPortUrl() + tenantId), (String)"GET", null);
            if (object == null || "500".equals(object.get((Object)"code").toString())) {
                throw new LoginException(MsgCode.LOG105.get());
            }
            if ("400".equals(object.getString("code"))) {
                throw new LoginException(object.getString("msg"));
            }
            Map resulList = JsonUtil.stringToMap((String)object.getString("data"));
            String name = null;
            if (resulList.get("java") != null) {
                name = String.valueOf(resulList.get("java"));
            } else {
                TenantVO vo = (TenantVO)JsonUtil.getJsonToBean((Object)resulList, TenantVO.class);
                List linkList = vo.getLinkList();
                if (linkList != null && linkList.size() > 0) {
                    name = "true";
                    this.cacheUtil.insert("oneHourCacheSpace", tenantId, (Object)JsonUtil.getObjectToString((Object)linkList), -1L);
                } else {
                    name = vo.getDbName();
                }
            }
            userInfo.setTenantId(tenantId);
            userInfo.setTenantDbConnectionString(name);
            DataSourceContextHolder.setDatasource((String)tenantId, (String)name);
        }
        return userInfo;
    }

    @Override
    public UserInfo userInfo(UserInfo userInfo, UserEntity userEntity, BaseSystemInfo sysConfigInfo) throws LoginException {
        userInfo.setIsAdministrator(Boolean.valueOf(BooleanUtil.toBoolean((String)String.valueOf(userEntity.getIsAdministrator()))));
        userInfo.setUserId(userEntity.getId());
        userInfo.setUserAccount(userEntity.getAccount());
        userInfo.setUserName(userEntity.getRealName());
        userInfo.setRealName(userEntity.getRealName());
        userInfo.setUserIcon(userEntity.getHeadIcon());
        userInfo.setOrganizeId(userEntity.getOrganizeId());
        userInfo.setPortalId(userEntity.getPortalId());
        userInfo.setIsAdministrator(Boolean.valueOf(BooleanUtil.toBoolean((String)String.valueOf(userEntity.getIsAdministrator()))));
        String time = sysConfigInfo.getTokenTimeout();
        Integer minu = Integer.valueOf(time);
        userInfo.setOverdueTime(DateUtil.dateAddMinutes(null, (int)minu));
        userInfo.setTokenTimeout(minu);
        userInfo.setLoginTime(DateUtil.getmmNow());
        userInfo.setLoginPlatForm(ServletUtils.getUserAgent());
        userInfo.setPrevLoginTime(userEntity.getPrevLogTime());
        userInfo.setPrevLoginIpAddress(userEntity.getPrevLogIp());
        userInfo.setPrevLoginIpAddressName(IpUtil.getIpCity((String)userEntity.getPrevLogIp()));
        String token = RandomUtil.uuId();
        userInfo.setId(this.cacheKeyUtil.getLoginToken(userInfo.getTenantId()) + token);
        return userInfo;
    }

    private UserCommonInfoVO data(UserInfo userInfo) throws BaseException {
        String stringMd5;
        SysConfigEntity configByKeyName;
        UserEntity info;
        List list = this.organizeService.getList();
        UserEntity userEntity = this.userService.getInfo(userInfo.getUserId());
        userEntity = userEntity != null ? userEntity : new UserEntity();
        userInfo.setManagerId(userEntity.getManagerId());
        boolean b = userInfo.getIsAdministrator();
        this.userInfo(userInfo, userInfo.getUserId(), b, userEntity);
        userInfo.setSubOrganizeIds(this.getSubOrganizeIds(list, userInfo.getOrganizeId(), b));
        List subordinateIdsList = this.userService.getListByManagerId(userInfo.getUserId(), null).stream().map(UserBaseVO::getId).collect(Collectors.toList());
        userInfo.setSubordinateIds(subordinateIdsList);
        userInfo.setLoginTime(DateUtil.getmmNow());
        userInfo.setLoginPlatForm(ServletUtils.getUserAgent());
        this.cacheUtil.insert("loginCacheSpace", userInfo.getId(), (Object)userInfo, DateUtil.getTime((Date)userInfo.getOverdueTime()) - DateUtil.getTime((Date)new Date()));
        BaseSystemInfo baseSystemInfo = this.sysConfigService.getSysInfo();
        UserCommonInfoVO infoVO = (UserCommonInfoVO)JsonUtil.getJsonToBean(this.userInfo(userInfo, baseSystemInfo), UserCommonInfoVO.class);
        infoVO.setRoleIds(userInfo.getRoleIds());
        StringBuilder roleName = new StringBuilder();
        for (RoleEntity entity : this.roleService.getListByIds(userInfo.getRoleIds())) {
            roleName.append("," + entity.getFullName());
        }
        if (roleName.length() > 0) {
            infoVO.setRoleName(roleName.toString().replaceFirst(",", ""));
        }
        if ((info = this.userService.getInfo(userEntity.getManagerId())) != null) {
            infoVO.setManager(info.getRealName());
        }
        if (ObjectUtil.isNotNull((Object)(configByKeyName = this.sysConfigService.getConfigByKeyName("defaultPassword"))) && (stringMd5 = Md5Util.getStringMd5((String)(Md5Util.getStringMd5((String)configByKeyName.getKeyValue()).toLowerCase() + userEntity.getSecretkey().toLowerCase()))).equals(userEntity.getPassword())) {
            infoVO.setIsNeedUpdatePwd(Boolean.valueOf(true));
        }
        infoVO.setMobilePhone(userEntity.getMobilePhone());
        infoVO.setEmail(userEntity.getEmail());
        infoVO.setBirthday(userEntity.getBirthday() != null ? Long.valueOf(userEntity.getBirthday().getTime()) : null);
        infoVO.setUserName(userEntity.getRealName());
        OrganizeEntity organizeEntity = this.organizeService.getInfo(userInfo.getDepartmentId());
        String organizeName = null;
        String departmentId = null;
        String departmentName = null;
        if (organizeEntity != null) {
            organizeName = organizeEntity.getFullName();
            if (StringUtils.isNotEmpty((String)organizeEntity.getOrganizeIdTree())) {
                String[] split = organizeEntity.getOrganizeIdTree().split(",");
                departmentId = split.length > 0 ? split[split.length - 1] : "";
                departmentName = this.organizeService.getFullNameByOrgIdTree(organizeEntity.getOrganizeIdTree(), "/");
            }
            OrganizeEntity company = this.organizeService.getInfo(organizeEntity.getOrganizeId());
            infoVO.setOrganizeName(company.getFullName());
        }
        infoVO.setDepartmentId(departmentId);
        infoVO.setDepartmentName(departmentName);
        infoVO.setIsAdministrator(Boolean.valueOf(BooleanUtil.toBoolean((String)String.valueOf(userEntity.getIsAdministrator()))));
        return infoVO;
    }

    public void getOrganizeName(List<OrganizeEntity> OrganizeList, String organizeId) throws Exception {
        List OrganizeList2 = OrganizeList.stream().filter(t -> organizeId.equals(t.getId())).collect(Collectors.toList());
        if (OrganizeList2.size() > 0) {
            for (OrganizeEntity organizeEntity : OrganizeList2) {
                if (!organizeEntity.getParentId().equals("-1")) continue;
                throw new Exception(JSON.toJSONString((Object)organizeEntity));
            }
            for (OrganizeEntity orgSub : OrganizeList2) {
                this.getOrganizeName(OrganizeList, orgSub.getParentId());
            }
        }
    }

    @Override
    public UserEntity isExistUser(String account) throws LoginException, PermissionException {
        Integer lockMark;
        List<String> ipList;
        BaseSystemInfo sysConfigInfo = this.sysConfigService.getSysInfo();
        UserEntity userEntity = this.userService.getUserByAccount(account);
        if (userEntity == null) {
            throw new LoginException(MsgCode.LOG003.get());
        }
        if ((!"admin".equals(userEntity.getId()) || userEntity.getIsAdministrator() != 1) && StringUtils.isEmpty((String)userEntity.getOrganizeId())) {
            throw new LoginException(MsgCode.LOG004.get());
        }
        if (userEntity.getEnabledMark() == null) {
            throw new LoginException(MsgCode.LOG005.get());
        }
        if (userEntity.getEnabledMark() == 0) {
            throw new LoginException(MsgCode.LOG006.get());
        }
        if (userEntity.getDeleteMark() != null && userEntity.getDeleteMark() == 1) {
            throw new LoginException(MsgCode.LOG007.get());
        }
        String ipAddr = IpUtil.getIpAddr();
        if (!"admin".equals(userEntity.getId()) && "1".equals(sysConfigInfo.getWhitelistSwitch()) && !(ipList = Arrays.asList(sysConfigInfo.getWhitelistIp().split(","))).contains(ipAddr)) {
            throw new LoginException(MsgCode.LOG010.get());
        }
        if (userEntity.getIsAdministrator() != 1) {
            if (userEntity.getIsAdministrator() == 0) {
                List userAllRole = this.roleService.getListByUserId(userEntity.getId());
                boolean permissionFlag = false;
                for (RoleEntity role : userAllRole) {
                    if (role == null || role.getEnabledMark() == null || role.getEnabledMark() == 0) continue;
                    permissionFlag = true;
                    break;
                }
                if (!permissionFlag) {
                    throw new LoginException(MsgCode.LOG011.get());
                }
            } else {
                throw new LoginException(MsgCode.LOG011.get());
            }
        }
        if (Objects.nonNull(lockMark = userEntity.getEnabledMark()) && lockMark == 2) {
            Date unlockTime = userEntity.getUnlockTime();
            if (Objects.isNull(unlockTime)) {
                throw new LoginException(MsgCode.LOG012.get());
            }
            long millis = System.currentTimeMillis();
            if (unlockTime.getTime() > millis) {
                int time = (int)((unlockTime.getTime() - millis) / 60000L);
                throw new LoginException(MsgCode.LOG013.get().replace("{time}", Integer.toString(time + 1)));
            }
        }
        return userEntity;
    }

    @Override
    public UserInfo loginProcess(UserEntity userEntity) throws LoginException {
        UserInfo userInfo = new UserInfo();
        BaseSystemInfo systemInfo = this.sysConfigService.getSysInfo();
        userInfo = this.userInfo(userInfo, userEntity, systemInfo);
        if ("1".equals(String.valueOf(systemInfo.getSingleLogin()))) {
            this.userProvider.removeWebSocket(userInfo);
        }
        this.userProvider.add(userInfo);
        return userInfo;
    }

    @Override
    public void loginUpdateUser() throws LoginException {
        String userId = this.userProvider.get().getUserId();
        if (StringUtils.isNotEmpty((String)userId)) {
            UserEntity userEntity = this.userService.getInfo(userId);
            userEntity.setLogErrorCount(Integer.valueOf(0));
            userEntity.setUnlockTime(null);
            userEntity.setPrevLogIp(IpUtil.getIpAddr());
            userEntity.setPrevLogTime(DateUtil.getNowDate());
            userEntity.setLastLogIp(IpUtil.getIpAddr());
            userEntity.setLastLogTime(DateUtil.getNowDate());
            userEntity.setLogSuccessCount(Integer.valueOf(userEntity.getLogSuccessCount() != null ? userEntity.getLogSuccessCount() + 1 : 1));
            this.userService.update(userEntity);
        }
    }

    @Override
    public PcUserVO getCurrentUser(String type, String applicationId) throws BaseException {
        UserEntity info;
        UserInfo userInfo = this.userProvider.get();
        UserCommonInfoVO infoVO = this.data(userInfo);
        AuthorizeVO authorizeModel = this.authorizeService.getAuthorize(false);
        List moduleList = authorizeModel.getModuleList();
        List menuList = null;
        List<ModuleModel> systemList = null;
        if (StringUtils.isEmpty((String)type)) {
            systemList = moduleList.stream().filter(t -> "Web".equals(t.getCategory()) && "0".equals(String.valueOf(t.getType()))).sorted(Comparator.comparing(ModuleModel::getSortCode)).collect(Collectors.toList());
            menuList = moduleList.stream().filter(t -> "Web".equals(t.getCategory()) && !"0".equals(String.valueOf(t.getType()))).sorted(Comparator.comparing(ModuleModel::getSortCode)).collect(Collectors.toList());
        } else {
            systemList = moduleList.stream().filter(t -> "App".equals(t.getCategory()) && "0".equals(String.valueOf(t.getType()))).sorted(Comparator.comparing(ModuleModel::getSortCode)).collect(Collectors.toList());
            menuList = moduleList.stream().filter(t -> "App".equals(t.getCategory())).sorted(Comparator.comparing(ModuleModel::getSortCode)).collect(Collectors.toList());
        }
        List finalMenuList = menuList;
        List authSystemList = systemList.stream().filter(t -> finalMenuList.stream().filter(m -> t.getId().equals(m.getParentId())).findAny().isPresent()).collect(Collectors.toList());
        if (StringUtils.isEmpty((String)applicationId) && StringUtils.isEmpty((String)type)) {
            applicationId = ((ModuleModel)authSystemList.get(0)).getId();
        } else if ("App".equals(type)) {
            applicationId = "-1";
        }
        if (StringUtils.isNotEmpty((String)applicationId)) {
            String finalApplicationId = applicationId;
            boolean b = systemList.stream().anyMatch(m -> m.getId().equals(finalApplicationId));
            if (!b) {
                applicationId = ((ModuleModel)authSystemList.get(0)).getId();
            }
        }
        List menu = JsonUtil.getJsonToList(menuList, UserMenuModel.class);
        List menus = TreeDotUtils.convertListToTreeDot((List)menu, (String)applicationId);
        List list = JsonUtil.getJsonToList((Object)menus, MenuTreeVO.class);
        List<String> posiList = Arrays.asList(userInfo.getPositionIds());
        List positionList = this.positionService.getPositionName(posiList);
        ArrayList<UserPositionVO> positionVO = new ArrayList<UserPositionVO>();
        for (Object positionEntity : positionList) {
            UserPositionVO userPositionVO = new UserPositionVO();
            userPositionVO.setName(positionEntity.getFullName());
            userPositionVO.setId(positionEntity.getId());
            positionVO.add(userPositionVO);
        }
        ArrayList<PermissionModel> models = new ArrayList<PermissionModel>();
        for (ModuleModel moduleModel : menuList) {
            PermissionModel model = new PermissionModel();
            model.setModelId(moduleModel.getId());
            model.setModuleName(moduleModel.getFullName());
            List buttonModels = authorizeModel.getButtonList().stream().filter(t -> moduleModel.getId().equals(t.getModuleId())).collect(Collectors.toList());
            List columnModels = authorizeModel.getColumnList().stream().filter(t -> moduleModel.getId().equals(t.getModuleId())).collect(Collectors.toList());
            List resourceModels = authorizeModel.getResourceList().stream().filter(t -> moduleModel.getId().equals(t.getModuleId())).collect(Collectors.toList());
            List moduleFormModels = authorizeModel.getFormsList().stream().filter(t -> moduleModel.getId().equals(t.getModuleId())).collect(Collectors.toList());
            model.setButton(JsonUtil.getJsonToList(buttonModels, PermissionVO.class));
            model.setColumn(JsonUtil.getJsonToList(columnModels, PermissionVO.class));
            model.setResource(JsonUtil.getJsonToList(resourceModels, PermissionVO.class));
            model.setForm(JsonUtil.getJsonToList(moduleFormModels, PermissionVO.class));
            if (moduleModel.getType() == 1) continue;
            models.add(model);
        }
        if (this.configValueUtil.getEnablePreAuth().booleanValue()) {
            this.initSecurityAuthorities(authorizeModel, userInfo);
        }
        if (StringUtils.isEmpty((String)(info = this.userService.getInfo(userInfo.getUserId())).getPortalId())) {
            List portalList = this.portalService.getList("1");
            if (portalList.size() > 0) {
                infoVO.setPortalId(((PortalSelectModel)portalList.get(0)).getId());
            }
        } else {
            infoVO.setPortalId(info.getPortalId());
        }
        infoVO.setPositionIds(positionVO);
        BaseSystemInfo sysInfo = this.sysConfigService.getSysInfo();
        SystemInfo jsonToBean = (SystemInfo)JsonUtil.getJsonToBean((Object)sysInfo, SystemInfo.class);
        PcUserVO userVO = new PcUserVO(systemList, list, models, infoVO, jsonToBean);
        userVO.setPermissionList(models);
        userVO.getUserInfo().setHeadIcon(userInfo.getUserIcon());
        return userVO;
    }

    @Override
    public String getAccountByWxCode(String weComCode, String corpId) {
        String returnAccount = null;
        if (StringUtils.isNotEmpty((String)corpId)) {
            WeComModel weComModel = this.wxCpConfiguration.getWeComModel(corpId);
            if (weComModel == null) {
                throw new LoginException(String.format("\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", corpId));
            }
            WxCpService wxCorpService = this.wxCpConfiguration.getCorpService(corpId);
            String agentId = weComModel.getQyhAgentId();
            WxCpService wxCpService = this.wxCpConfiguration.getCpService(corpId, Integer.valueOf(agentId));
            if (wxCpService == null) {
                throw new LoginException(String.format("\u672a\u627e\u5230\u5bf9\u5e94corpId=[%s]\u3001agentId=[%d]\u7684\u914d\u7f6e\uff0c\u8bf7\u6838\u5b9e\uff01", corpId, agentId));
            }
            try {
                WxCpOauth2UserInfo oauthUserInfo = wxCpService.getOauth2Service().getUserInfo(weComCode);
                String userId = oauthUserInfo.getUserId();
                String userTicket = oauthUserInfo.getUserTicket();
                if (StringUtils.isEmpty((String)userId)) {
                    throw new LoginException("\u83b7\u53d6\u4f01\u4e1a\u5fae\u4fe1\u5f53\u524d\u8bbf\u95ee\u7528\u6237\u8eab\u4efd\u5931\u8d25\uff01");
                }
                Boolean isLinkedCorp = weComModel.getIsLinkedCorp();
                if (isLinkedCorp.booleanValue()) {
                    String systemObjectId;
                    UserEntity entity;
                    String thirdObjid = StringUtils.isNotEmpty((String)userId) && userId.contains("/") ? userId : corpId + "/" + userId;
                    SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoByThirdObjId("1", "2", thirdObjid, corpId);
                    if (ObjectUtil.isNotEmpty((Object)synThirdInfoEntity) && ObjectUtil.isNotEmpty((Object)(entity = this.userService.getInfo(systemObjectId = synThirdInfoEntity.getSystemObjectId())))) {
                        returnAccount = entity.getAccount();
                    }
                    if (StringUtils.isEmpty(returnAccount)) {
                        MyWxCpLinkedCorpServiceImpl myWxCpLinkedCorpService = new MyWxCpLinkedCorpServiceImpl();
                        myWxCpLinkedCorpService.setWxCpService(wxCpService);
                        MyWxCpLinkedCorpUser qyuser = myWxCpLinkedCorpService.getLinkedCorpUser(thirdObjid);
                        String corpid = qyuser.getCorpId();
                        String userid = qyuser.getUserId();
                        if (ObjectUtil.isEmpty((Object)qyuser) || StringUtils.isEmpty((String)corpid) || StringUtils.isEmpty((String)userid)) {
                            throw new LoginException("\u83b7\u53d6\u4e92\u8054\u4f01\u4e1a\u6210\u5458\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
                        }
                        UserEntity userEntity = this.wxCpLinkedCorpService.registerSysAccount(qyuser, wxCpService);
                        if (ObjectUtil.isEmpty((Object)userEntity)) {
                            throw new LoginException("\u672a\u5173\u8054\u5230\u7528\u6237\uff01");
                        }
                        returnAccount = userEntity.getAccount();
                    }
                } else {
                    String systemObjectId;
                    UserEntity entity;
                    String thirdObjid = userId;
                    SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoByThirdObjId("1", "2", thirdObjid, corpId);
                    if (ObjectUtil.isNotEmpty((Object)synThirdInfoEntity) && ObjectUtil.isNotEmpty((Object)(entity = this.userService.getInfo(systemObjectId = synThirdInfoEntity.getSystemObjectId())))) {
                        WxCpUserDetail userDetail;
                        returnAccount = entity.getAccount();
                        if (StringUtils.isNotEmpty((String)userTicket) && ObjectUtil.isNotEmpty((Object)(userDetail = wxCpService.getOauth2Service().getUserDetail(userTicket))) && StringUtils.isNotEmpty((String)userDetail.getAvatar())) {
                            entity.setHeadIcon(userDetail.getAvatar());
                            this.userService.update(entity);
                        }
                    }
                    if (StringUtils.isEmpty(returnAccount)) {
                        WxCpUser wxCpUser = wxCpService.getUserService().getById(userId);
                        if (ObjectUtil.isEmpty((Object)wxCpUser)) {
                            throw new LoginException("\u83b7\u53d6\u4f01\u4e1a\u6210\u5458\u8be6\u7ec6\u4fe1\u606f\u5931\u8d25\uff01");
                        }
                        ArrayList<WxCpUser> users = new ArrayList<WxCpUser>();
                        users.add(wxCpUser);
                        List synThirdInfoEntities = this.wxCpCorpService.saveOrUpdateUserList(users, wxCpService);
                        if (CollectionUtil.isNotEmpty((Collection)synThirdInfoEntities)) {
                            UserEntity entity2 = (UserEntity)synThirdInfoEntities.get(0);
                            returnAccount = entity2.getAccount();
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.saveLogEntity(e, "QyWxLogin");
                throw new LoginException("\u4f01\u4e1a\u5fae\u4fe1\u767b\u5f55\u5931\u6548\uff0c\u6b63\u5728\u91cd\u65b0\u767b\u5f55\uff01");
            }
        }
        return returnAccount;
    }

    private void saveLogEntity(Exception e, String module) {
        UserInfo userInfo = this.userProvider.get();
        LogEntity entity = new LogEntity();
        entity.setId(RandomUtil.uuId());
        entity.setCategory(LogSortEnum.Operate.getCode());
        entity.setUserId(userInfo.getUserId());
        entity.setUserName(userInfo.getRealName() + "/" + userInfo.getUserAccount());
        if (!ServletUtils.getIsMobileDevice()) {
            String modelName = module;
            entity.setModuleName(modelName);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(e.toString() + "\n");
        StackTraceElement[] stackArray = e.getStackTrace();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        entity.setJsons(sb.toString());
        entity.setRequestUrl(ServletUtils.getRequest().getServletPath());
        entity.setRequestMethod(ServletUtils.getRequest().getMethod());
        entity.setCategory(Integer.valueOf(4));
        entity.setUserId(userInfo.getUserId());
        entity.setIpAddress(IpUtil.getIpAddr());
        entity.setCreatorTime(new Date());
        entity.setPlatForm(ServletUtils.getUserAgent());
        this.logService.save((Object)entity);
    }

    public static com.aliyun.dingtalkoauth2_1_0.Client authClient() throws Exception {
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        return new com.aliyun.dingtalkoauth2_1_0.Client(config);
    }

    @Override
    public String getAccountByDingCode(String authCode) throws Exception {
        com.aliyun.dingtalkoauth2_1_0.Client client = LoginServiceImpl.authClient();
        GetUserTokenRequest getUserTokenRequest = new GetUserTokenRequest().setClientId("dingqgbtl0pzm45qbonu").setClientSecret("299RRMGBuD-Hsw9LE76DzJi-ApKmq3MABXm-tS8-plFFt189RrSJi_qB0U7tAot1").setCode(authCode).setGrantType("authorization_code");
        GetUserTokenResponse getUserTokenResponse = client.getUserToken(getUserTokenRequest);
        String accessToken = getUserTokenResponse.getBody().getAccessToken();
        DingUserInfoModel jsonToBean = (DingUserInfoModel)JsonUtil.getJsonToBean((String)this.getUserinfo(accessToken), DingUserInfoModel.class);
        UserEntity infoByMobile = this.userService.getUserByAccount(jsonToBean.getMobile());
        return infoByMobile.getAccount();
    }

    @Override
    public String getAccountByDingCodeH5(String dingCode) throws Exception {
        DefaultDingTalkClient clientToken = new DefaultDingTalkClient("https://oapi.dingtalk.com/gettoken");
        OapiGettokenRequest request = new OapiGettokenRequest();
        request.setAppkey("dingqgbtl0pzm45qbonu");
        request.setAppsecret("299RRMGBuD-Hsw9LE76DzJi-ApKmq3MABXm-tS8-plFFt189RrSJi_qB0U7tAot1");
        request.setHttpMethod("GET");
        OapiGettokenResponse response = (OapiGettokenResponse)clientToken.execute((TaobaoRequest)request);
        System.out.println(response.getBody());
        Map stringObjectMap = JsonUtil.stringToMap((String)response.getBody());
        stringObjectMap.get("access_token");
        DefaultDingTalkClient client = new DefaultDingTalkClient("https://oapi.dingtalk.com/topapi/v2/user/getuserinfo");
        OapiV2UserGetuserinfoRequest req = new OapiV2UserGetuserinfoRequest();
        req.setCode(dingCode);
        OapiV2UserGetuserinfoResponse rsp = (OapiV2UserGetuserinfoResponse)client.execute((TaobaoRequest)req, String.valueOf(stringObjectMap.get("access_token")));
        System.out.println(rsp.getBody());
        DingUserModel map = (DingUserModel)JsonUtil.getJsonToBean((String)String.valueOf(JsonUtil.stringToMap((String)rsp.getBody()).get("result")), DingUserModel.class);
        List infoByThirdObjIds = this.synThirdInfoService.getInfoByThirdObjIds("2", "2", map.getUserid());
        UserEntity info = new UserEntity();
        if (!ObjectUtil.isEmpty((Object)infoByThirdObjIds)) {
            info = this.userService.getInfo(((SynThirdInfoEntity)infoByThirdObjIds.get(0)).getSystemObjectId());
        }
        return info.getAccount();
    }

    @Override
    public String getAccountByWxMiniappCode(String appid, String code, String phoneCode) {
        String returnAccount;
        block13: {
            if (StringUtils.isBlank((CharSequence)code)) {
                throw new LoginException("empty jscode");
            }
            this.wxMaService = this.wxMaConfiguration.getWxMaService(appid);
            try {
                WxMaJscode2SessionResult session = this.wxMaService.getUserService().getSessionInfo(code);
                String thirdObjid = session.getOpenid();
                if (StringUtils.isEmpty((String)thirdObjid)) {
                    throw new LoginException("\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7528\u6237\u8eab\u4efd\u5931\u8d25\uff01");
                }
                SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoByThirdObjId("3", "2", thirdObjid, appid);
                if (ObjectUtil.isNotEmpty((Object)synThirdInfoEntity)) {
                    String systemObjectId = synThirdInfoEntity.getSystemObjectId();
                    UserEntity entity = this.userService.getInfo(systemObjectId);
                    if (entity != null) {
                        returnAccount = entity.getAccount();
                        break block13;
                    }
                    throw new LoginException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7528\u6237(openid)\u7ed1\u5b9a\u8d26\u6237\u65e0\u6548", 904, (Object)entity);
                }
                if (StringUtils.isNotEmpty((String)phoneCode)) {
                    try {
                        returnAccount = this.bindingWxMiniappCode(appid, thirdObjid, phoneCode);
                        break block13;
                    }
                    catch (LoginException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new LoginException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u8c03\u7528\u5f02\u5e38" + e);
                    }
                }
                throw new LoginException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7528\u6237(openid)\u672a\u7ed1\u5b9a\u7cfb\u7edf\u8d26\u6237", 901, (Object)session);
            }
            catch (WxErrorException e) {
                this.log.error(e.getMessage(), (Throwable)e);
                throw new LoginException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u8c03\u7528\u5f02\u5e38" + (Object)((Object)e));
            }
            finally {
                WxMaConfigHolder.remove();
            }
        }
        return returnAccount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String bindingWxMiniappCode(String appid, String openid, String phoneCode) throws Exception {
        if (StringUtils.isBlank((CharSequence)openid) || StringUtils.isBlank((CharSequence)phoneCode)) {
            throw new LoginException("empty phoneCode \u65e0\u6cd5\u7ed1\u5b9a");
        }
        WxMaPhoneNumberInfo phoneNumberInfo = this.wxMaService.getUserService().getPhoneNumber(phoneCode);
        if (!ObjectUtil.isNotEmpty((Object)phoneNumberInfo) || !StringUtils.isNotEmpty((String)phoneNumberInfo.getPhoneNumber())) throw new LoginException("\u5c06phoneCode\u6362\u53d6\u7528\u6237\u624b\u673a\u53f7\u5931\u8d25\uff01", 903, (Object)phoneNumberInfo);
        String phoneNumber = phoneNumberInfo.getPhoneNumber();
        UserEntity userByAccount = this.userService.getUserByAccount(phoneNumber);
        if (!ObjectUtil.isNotEmpty((Object)userByAccount)) throw new LoginException(phoneNumber + "\u672a\u6ce8\u518c", 902, (Object)userByAccount);
        SynThirdInfoEntity synThirdInfoEntity = this.synThirdInfoService.getInfoBySysObjId("3", "2", userByAccount.getId());
        if (ObjectUtil.isEmpty((Object)synThirdInfoEntity)) {
            synThirdInfoEntity = new SynThirdInfoEntity();
            synThirdInfoEntity.setId(RandomUtil.uuId());
            synThirdInfoEntity.setThirdType(Integer.valueOf("3"));
            synThirdInfoEntity.setDataType(Integer.valueOf("2"));
        }
        synThirdInfoEntity.setSystemObjectId(userByAccount.getId());
        synThirdInfoEntity.setCropId(appid);
        synThirdInfoEntity.setThirdObjectId(openid);
        this.synThirdInfoService.saveOrUpdate((Object)synThirdInfoEntity);
        this.log.debug("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u7528\u6237\u7ed1\u5b9a\u6210\u529f");
        return phoneNumber;
    }

    public static Client contactClient() throws Exception {
        Config config = new Config();
        config.protocol = "https";
        config.regionId = "central";
        return new Client(config);
    }

    public String getUserinfo(String accessToken) throws Exception {
        Client client = LoginServiceImpl.contactClient();
        GetUserHeaders getUserHeaders = new GetUserHeaders();
        getUserHeaders.xAcsDingtalkAccessToken = accessToken;
        String me = JSON.toJSONString((Object)client.getUserWithOptions("me", getUserHeaders, new RuntimeOptions()).getBody());
        System.out.println(me);
        return me;
    }

    private void initSecurityAuthorities(AuthorizeVO authorizeModel, UserInfo userInfo) {
        HashSet<String> authorityList = new HashSet<String>();
        Map<String, ModuleModel> moduleModelMap = authorizeModel.getModuleList().stream().filter(m -> {
            authorityList.add(m.getEnCode());
            return true;
        }).collect(Collectors.toMap(m -> m.getId(), m -> m));
        for (ModuleModel moduleModel : authorizeModel.getModuleList()) {
            String permissionKey = moduleModel.getEnCode();
            authorityList.add(permissionKey);
        }
        authorizeModel.getButtonList().stream().forEach(t -> {
            ModuleModel m = (ModuleModel)moduleModelMap.get(t.getModuleId());
            if (m != null) {
                authorityList.add(m.getEnCode() + "::" + t.getEnCode());
            }
        });
        authorizeModel.getColumnList().stream().forEach(t -> {
            ModuleModel m = (ModuleModel)moduleModelMap.get(t.getModuleId());
            if (m != null) {
                authorityList.add(m.getEnCode() + "::" + t.getEnCode());
            }
        });
        authorizeModel.getFormsList().stream().forEach(t -> {
            ModuleModel m = (ModuleModel)moduleModelMap.get(t.getModuleId());
            if (m != null) {
                authorityList.add(m.getEnCode() + "::" + t.getEnCode());
            }
        });
        String authorityKey = "authorize_:" + this.cacheKeyUtil.getUserAuthorize() + "authority_" + (userInfo.getIsAdministrator() != false ? "admin" : userInfo.getUserAccount());
        this.cacheUtil.remove("foreverCacheSpace", authorityKey);
        this.cacheUtil.insert("foreverCacheSpace", authorityKey, authorityList, 172800L);
        if (userInfo.getRoleIds() != null && !userInfo.getRoleIds().isEmpty() || userInfo.getIsAdministrator().booleanValue()) {
            String rolesKey = "authorize_:" + this.cacheKeyUtil.getUserAuthorize() + "role_" + (userInfo.getIsAdministrator() != false ? "admin" : userInfo.getUserAccount());
            List roles = userInfo.getIsAdministrator() != false ? this.roleService.getList() : this.roleService.getListByIds(userInfo.getRoleIds());
            Set roleAuthorityList = roles.stream().filter(r -> r.getEnabledMark().equals(1)).map(r -> "ROLE_" + r.getEnCode()).collect(Collectors.toSet());
            this.cacheUtil.remove("foreverCacheSpace", rolesKey);
            this.cacheUtil.insert("foreverCacheSpace", rolesKey, roleAuthorityList, 172800L);
        }
    }

    private String[] getRoleId(String userId, boolean isAdmin) {
        List data = this.userRelationService.getListByUserId(userId);
        if (!isAdmin) {
            data = data.stream().filter(m -> "Role".equals(m.getObjectType())).collect(Collectors.toList());
        }
        List<String> list = data.stream().map(t -> t.getObjectId()).collect(Collectors.toList());
        return list.toArray(new String[list.size()]);
    }

    private String[] getSubOrganizeIds(List<OrganizeEntity> data, String organizeId, boolean isAdmin) {
        if (!isAdmin) {
            data = JsonUtil.getJsonToList((Object)ListToTreeUtil.treeWhere((String)organizeId, data), OrganizeEntity.class);
        }
        List<String> list = data.stream().map(t -> t.getId()).collect(Collectors.toList());
        return list.toArray(new String[list.size()]);
    }

    private String[] getPositionId(String userId, boolean isAdmin) {
        List data = this.userRelationService.getListByUserId(userId);
        List<String> list = data.stream().filter(m -> "Position".equals(m.getObjectType())).map(t -> t.getObjectId()).collect(Collectors.toList());
        return list.toArray(new String[list.size()]);
    }

    private void userInfo(UserInfo userInfo, String userId, boolean isAdmin, UserEntity userEntity) {
        List data = this.userRelationService.getListByUserIdAndObjType(userId, "Organize");
        String organizeId = "";
        String departmentId = "";
        List<Object> roleIdList = new ArrayList();
        if (!this.organizeRelationService.checkBasePermission(userEntity.getId(), userEntity.getOrganizeId()).booleanValue()) {
            if (data.size() > 0) {
                departmentId = this.organizeRelationService.autoGetMajorOrganizeId(userId, data.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList()), userEntity.getOrganizeId());
            }
        } else {
            departmentId = userEntity.getOrganizeId();
            if (isAdmin) {
                roleIdList = data.stream().map(t -> t.getObjectId()).collect(Collectors.toList());
            }
        }
        if (StringUtils.isNotEmpty((String)departmentId)) {
            OrganizeEntity companyListById = this.organizeService.getDirectlyUnderCompanyById(departmentId);
            organizeId = companyListById.getId();
        }
        List listByObjectId = this.userRelationService.getListByUserId(userInfo.getUserId(), "Role");
        List collect = listByObjectId.stream().map(UserRelationEntity::getObjectId).collect(Collectors.toList());
        for (String roleId : collect) {
            RoleEntity info = this.roleService.getInfo(roleId);
            if (ObjectUtil.isNotEmpty((Object)info) && ObjectUtil.isNotEmpty((Object)info.getGlobalMark()) && GlobalMarkEnum.NOT_ORGANIZE.getCode().intValue() == info.getGlobalMark().intValue()) {
                roleIdList.add(info.getId());
                continue;
            }
            Boolean exist = this.organizeRelationService.existByObejctIdAndOrgIdAndObjectType(organizeId, roleId, "Role");
            if (!exist.booleanValue()) continue;
            roleIdList.add(roleId);
        }
        List positionList = data.stream().filter(m -> "Position".equals(m.getObjectType())).map(t -> t.getObjectId()).collect(Collectors.toList());
        LinkedHashSet id = new LinkedHashSet();
        String[] position = StringUtils.isNotEmpty((String)userEntity.getPositionId()) ? userEntity.getPositionId().split(",") : new String[]{};
        List positions = positionList.stream().filter(t -> Arrays.asList(position).contains(t)).collect(Collectors.toList());
        id.addAll(positions);
        id.addAll(positionList);
        String[] positionId = id.toArray(new String[id.size()]);
        userInfo.setOrganizeId(organizeId);
        userInfo.setDepartmentId(departmentId);
        userInfo.setRoleIds(roleIdList);
        userInfo.setPositionIds(positionId);
        String positionId1 = this.organizeRelationService.autoGetMajorPositionId(userId, organizeId, userEntity.getPositionId());
        userEntity.setPositionId(positionId1);
    }

    private Map<String, Object> userInfo(UserInfo userInfo, BaseSystemInfo systemInfo) {
        HashMap<String, Object> dictionary = new HashMap<String, Object>(16);
        dictionary.put("userId", userInfo.getUserId());
        dictionary.put("userAccount", userInfo.getUserAccount());
        dictionary.put("userName", userInfo.getRealName());
        dictionary.put("icon", userInfo.getUserIcon());
        dictionary.put("portalId", userInfo.getPortalId());
        dictionary.put("gender", userInfo.getUserGender());
        dictionary.put("organizeId", userInfo.getOrganizeId());
        dictionary.put("prevLogin", systemInfo.getLastLoginTimeSwitch() == 1 ? 1 : 0);
        dictionary.put("prevLoginTime", userInfo.getPrevLoginTime());
        dictionary.put("prevLoginIPAddress", userInfo.getPrevLoginIpAddress());
        dictionary.put("prevLoginIPAddressName", userInfo.getPrevLoginIpAddressName());
        dictionary.put("serviceDirectory", this.configValueUtil.getServiceDirectoryPath());
        dictionary.put("webDirectory", this.configValueUtil.getCodeAreasName());
        return dictionary;
    }
}

