/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Hashtable;
import javax.imageio.ImageIO;
import org.springframework.core.io.ByteArrayResource;

public class MatrixToImageWriter {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;

    private MatrixToImageWriter() {
    }

    private static BufferedImage toBufferedImage(BitMatrix matrix, String words) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        Graphics2D outg = image.createGraphics();
        MatrixToImageWriter.setGraphics2D(outg);
        outg.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
        outg.setColor(Color.BLACK);
        outg.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        int strWidth = outg.getFontMetrics().stringWidth(words);
        int wordStartX = (width - strWidth) / 2;
        int wordStartY = height - 20;
        outg.drawString(words, wordStartX, wordStartY);
        outg.dispose();
        image.flush();
        return image;
    }

    private static void setGraphics2D(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        BasicStroke s = new BasicStroke(1.0f, 1, 0);
        graphics2D.setStroke(s);
    }

    static void writeToFile(BitMatrix matrix, String format, File file, String words) throws IOException {
        BufferedImage image = MatrixToImageWriter.toBufferedImage(matrix, words);
        if (!ImageIO.write((RenderedImage)image, format, file)) {
            throw new IOException("Could not write an image of format " + format + " to " + file);
        }
    }

    static void writeToStream(BitMatrix matrix, String format, OutputStream stream, String words) throws IOException {
        BufferedImage image = MatrixToImageWriter.toBufferedImage(matrix, words);
        if (!ImageIO.write((RenderedImage)image, format, stream)) {
            throw new IOException("Could not write an image of format " + format);
        }
    }

    public static ByteArrayResource createQrCode(String url, String words) {
        try {
            HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            BitMatrix bitMatrix = new MultiFormatWriter().encode(url, BarcodeFormat.QR_CODE, 400, 400, hints);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream(bitMatrix, "jpg", outputStream, words);
            ByteArrayResource arrayResource = new ByteArrayResource(outputStream.toByteArray()){

                public String getFilename() throws IllegalStateException {
                    return System.currentTimeMillis() + "";
                }
            };
            return arrayResource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        String text = "http://www.uniapp.hnxiaogugongsi.com/#/pages/public/login?invitecode=20210013";
        int width = 400;
        int height = 400;
        String format = "jpg";
        Hashtable<EncodeHintType, String> hints = new Hashtable<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = new MultiFormatWriter().encode(text, BarcodeFormat.QR_CODE, width, height, hints);
        File outputFile = new File("D:\\\u9080\u8bf7\u4e8c\u7ef4\u7801" + File.separator + "20210013.jpg");
        MatrixToImageWriter.writeToFile(bitMatrix, format, outputFile, "\u626b\u63cf\u6ce8\u518c");
    }
}

