/*
 * Decompiled with CFR 0.152.
 */
package com.bringspring.oauth.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidatorUtils {
    public static boolean notEmpty(Object str) {
        return str != null && str.toString().trim().length() > 0;
    }

    public static boolean notEmptyIncludeArray(Object str) {
        if (str != null && String.valueOf(str).trim().length() > 0) {
            if (str instanceof Object[]) {
                Object[] array = (Object[])str;
                return array.length > 0;
            }
            if (str instanceof List) {
                List list = (List)str;
                return list.size() > 0;
            }
            return true;
        }
        return false;
    }

    public static boolean isEmpty(Object str) {
        return str == null || str.toString().trim().length() == 0;
    }

    public static boolean empty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String && obj.equals("")) {
            return true;
        }
        if (obj instanceof Number && ((Number)obj).doubleValue() == 0.0) {
            return true;
        }
        if (obj instanceof Boolean && !((Boolean)obj).booleanValue()) {
            return true;
        }
        if (obj instanceof Collection && ((Collection)obj).isEmpty()) {
            return true;
        }
        if (obj instanceof Map && ((Map)obj).isEmpty()) {
            return true;
        }
        return obj instanceof Object[] && ((Object[])obj).length == 0;
    }

    public static boolean isEmail(String email) {
        Pattern p = Pattern.compile("^\\w+([\\-+.]\\w+)*@\\w+([-.]\\w+)*\\.[a-z]{2,3}");
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean onlyNumAndChar(String str) {
        String regex = "^[a-zA-Z0-9_]+$";
        Pattern pattern = Pattern.compile(regex);
        return pattern.matcher(str).matches();
    }

    public static boolean hasLetterAndNum(String str) {
        Pattern pattern = Pattern.compile("^(?=.*[a-zA-Z].*).{6,}$");
        return pattern.matcher(str).matches();
    }

    public static boolean lengthBetween(String str, int min, int max) {
        return str.length() >= min && str.length() <= max;
    }

    public static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[0-9]*");
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static Double rountTwo(Double num) {
        if (num != null) {
            BigDecimal b = new BigDecimal(num);
            Double d = b.setScale(2, 4).doubleValue();
            return d;
        }
        return null;
    }

    public static String doubleTrans(double d) {
        if ((double)Math.round(d) - d == 0.0) {
            return String.valueOf((long)d);
        }
        return String.valueOf(d);
    }
}

