/*
 * Decompiled with CFR 0.152.
 */
package com.dingtalk.open.app.stream.network.core;

import com.dingtalk.open.app.stream.network.api.ClientConnectionListener;
import com.dingtalk.open.app.stream.network.api.ConnectOption;
import com.dingtalk.open.app.stream.network.api.EndPointConnection;
import com.dingtalk.open.app.stream.network.api.Protocol;
import com.dingtalk.open.app.stream.network.api.Session;
import com.dingtalk.open.app.stream.network.api.TransportConnector;
import com.dingtalk.open.app.stream.network.api.TransportProtocol;
import com.dingtalk.open.app.stream.network.api.exception.DingTalkNetworkException;
import com.dingtalk.open.app.stream.network.api.exception.NetWorkError;
import com.dingtalk.open.app.stream.network.api.logger.InternalLogger;
import com.dingtalk.open.app.stream.network.api.logger.InternalLoggerFactory;
import java.time.Duration;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Connector {
    private static final InternalLogger LOGGER = InternalLoggerFactory.getLogger(Connector.class);
    private static final Duration KEEP_ALIVE_TIMEOUT = Duration.ofMillis(5000L);
    private static final Map<TransportProtocol, TransportConnector> CONNECTOR_REGISTRY = new ConcurrentHashMap<TransportProtocol, TransportConnector>();
    private static final Lock INIT_LOCK = new ReentrantLock();
    private static volatile Boolean INIT = false;

    public static Session connect(EndPointConnection connection, ClientConnectionListener listener, long timeout, long ttl, long keepAliveIdle) throws Exception {
        Connector.ensureActive();
        TransportConnector connector = CONNECTOR_REGISTRY.get((Object)connection.getProtocol());
        if (connector == null) {
            throw new DingTalkNetworkException(NetWorkError.PROTOCOL_ILLEGAL);
        }
        ConnectOption option = ConnectOption.builder().setTimeout(timeout).setTtl(ttl).setKeepAliveIdle(Duration.ofMillis(keepAliveIdle)).setKeepAliveTimeout(KEEP_ALIVE_TIMEOUT).build();
        return connector.connect(connection, listener, option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureActive() {
        if (INIT.booleanValue()) {
            return;
        }
        INIT_LOCK.lock();
        try {
            if (INIT.booleanValue()) {
                return;
            }
            ServiceLoader<TransportConnector> transportConnectors = ServiceLoader.load(TransportConnector.class);
            for (TransportConnector transportConnector : transportConnectors) {
                TransportProtocol[] supportedProtocols;
                Protocol protocols = transportConnector.getClass().getAnnotation(Protocol.class);
                if (protocols == null) continue;
                for (TransportProtocol supportedProtocol : supportedProtocols = protocols.protocol()) {
                    CONNECTOR_REGISTRY.put(supportedProtocol, transportConnector);
                }
            }
            INIT = true;
        }
        catch (Exception e) {
            LOGGER.error("[DingTalk] client init transport failed", e, new Object[0]);
        }
        finally {
            INIT_LOCK.unlock();
        }
    }
}

